import time

from pytoniq_core import Cell

from pytvm.transaction_emulator import TransactionEmulator


def test_emulator():
    emulator = TransactionEmulator()
    emulator.set_unixtime(int(time.time()) - 1000000)

    sh_state = Cell.one_from_boc('b5ee9c72010217010003660001506876beba58b20e7a2773c8eb8b00196439fdb572909b87533356483f31a1c89b000028855718bb4501026fc008f099537efe682a263cb81a40170e91ebe7e31e4624749f66c16de9e17d0e91d22c858e432e4eceb00000a2155c62ed190a9f2f90134002160114ff00f4a413f4bcf2c80b030201200411020148050802e6d001d0d3032171b0925f04e022d749c120925f04e002d31f218210706c7567bd22821064737472bdb0925f05e003fa403020fa4401c8ca07cbffc9d0ed44d0810140d721f404305c810108f40a6fa131b3925f07e005d33fc8258210706c7567ba923830e30d03821064737472ba925f06e30d0607007801fa00f40430f8276f2230500aa121bef2e0508210706c7567831eb17080185004cb0526cf1658fa0219f400cb6917cb1f5260cb3f20c98040fb0006008a5004810108f45930ed44d0810140d720c801cf16f400c9ed540172b08e23821064737472831eb17080185005cb055003cf1623fa0213cb6acb1fcb3fc98040fb00925f03e202012009100201200a0f0201580b0c003db29dfb513420405035c87d010c00b23281f2fff274006040423d029be84c600201200d0e0019adce76a26840206b90eb85ffc00019af1df6a26840106b90eb858fc00011b8c97ed44d0d70b1f80059bd242b6f6a2684080a06b90fa0218470d4080847a4937d29910ce6903e9ff9837812801b7810148987159f318404f8f28308d71820d31fd31fd31f02f823bbf264ed44d0d31fd31fd3fff404d15143baf2a15151baf2a205f901541064f910f2a3f80024a4c8cb1f5240cb1f5230cbff5210f400c9ed54f80f01d30721c0009f6c519320d74a96d307d402fb00e830e021c001e30021c002e30001c0039130e30d03a4c8cb1f12cb1fcbff12131415006ed207fa00d4d422f90005c8ca0715cbffc9d077748018c8cb05cb0222cf165005fa0214cb6b12ccccc973fb00c84014810108f451f2a7020070810108d718fa00d33fc8542047810108f451f2a782106e6f746570748018c8cb05cb025006cf165004fa0214cb6a12cb1fcb3fc973fb0002006c810108d718fa00d33f305224810108f459f2a782106473747270748018c8cb05cb025005cf165003fa0213cb6acb1f12cb3fc973fb00000af400c9ed5400510000004629a9a31722f1d146dcc2a181f593205cfdcc7f1b845c15947dfe7ee1a9152175f096f89440')

    result = emulator.emulate_transaction(sh_state, Cell.one_from_boc(b'\xb5\xee\x9cr\x01\x02\x04\x01\x00\x01P\x00\x03\xe5\x88\x01\x1e\x13*o\xdf\xcd\x05D\xc7\x97\x03H\x02\xe1\xd2=|\xfcc\xc8\xc4\x8e\x93\xec\xd8-\xbd</\xa1\xd2:\x04\xe3:\xdc\x9d&\xc9\xad\xe4\xfb\xc9jp\r\x8e\xd1\x89Z\xd5!I\xbd\x85W\xa9\x00\x98\x92\xe03\xaa\xf3C\x8f\xec\xd5&\xf0\\mm\xc9\xe5\xcc\xcc\xc5\x02s\xf8*\x9cI\x97[h\x19\xbbP\xc2\xb2}\xabz\xc8qMM\x18\xbb.\xeb`\x08\x00\x00\x020\x00\x18\x18\x1c\x01\x02\x03\x00\x8cB\x00G\x84\xca\x9b\xf7\xf3AQ1\xe5\xc0\xd2\x00\xb8t\x8f_?\x18\xf21#\xa4\xfb6\x0boO\x0b\xe8t\x8e\xa0\x17\xd7\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00test overlay 3\x00\x8cB\x00G\x84\xca\x9b\xf7\xf3AQ1\xe5\xc0\xd2\x00\xb8t\x8f_?\x18\xf21#\xa4\xfb6\x0boO\x0b\xe8t\x8e\xa0\x1c\x9c8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00test overlay 3\x00\x8cB\x00G\x84\xca\x9b\xf7\xf3AQ1\xe5\xc0\xd2\x00\xb8t\x8f_?\x18\xf21#\xa4\xfb6\x0boO\x0b\xe8t\x8e\xa0!`\xec\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00test overlay 3'))

    assert result['success']
    assert result['transaction'].description.compute_ph.exit_code == 0
