from pytvm.tvm_emulator.tvm_emulator import TvmEmulator
from pytoniq_core import Cell


def test_emulator():
    code = Cell.one_from_boc('b5ee9c72410214010002d4000114ff00f4a413f4bcf2c80b010201200203020148040504f8f28308d71820d31fd31fd31f02f823bbf264ed44d0d31fd31fd3fff404d15143baf2a15151baf2a205f901541064f910f2a3f80024a4c8cb1f5240cb1f5230cbff5210f400c9ed54f80f01d30721c0009f6c519320d74a96d307d402fb00e830e021c001e30021c002e30001c0039130e30d03a4c8cb1f12cb1fcbff1011121302e6d001d0d3032171b0925f04e022d749c120925f04e002d31f218210706c7567bd22821064737472bdb0925f05e003fa403020fa4401c8ca07cbffc9d0ed44d0810140d721f404305c810108f40a6fa131b3925f07e005d33fc8258210706c7567ba923830e30d03821064737472ba925f06e30d06070201200809007801fa00f40430f8276f2230500aa121bef2e0508210706c7567831eb17080185004cb0526cf1658fa0219f400cb6917cb1f5260cb3f20c98040fb0006008a5004810108f45930ed44d0810140d720c801cf16f400c9ed540172b08e23821064737472831eb17080185005cb055003cf1623fa0213cb6acb1fcb3fc98040fb00925f03e20201200a0b0059bd242b6f6a2684080a06b90fa0218470d4080847a4937d29910ce6903e9ff9837812801b7810148987159f31840201580c0d0011b8c97ed44d0d70b1f8003db29dfb513420405035c87d010c00b23281f2fff274006040423d029be84c600201200e0f0019adce76a26840206b90eb85ffc00019af1df6a26840106b90eb858fc0006ed207fa00d4d422f90005c8ca0715cbffc9d077748018c8cb05cb0222cf165005fa0214cb6b12ccccc973fb00c84014810108f451f2a7020070810108d718fa00d33fc8542047810108f451f2a782106e6f746570748018c8cb05cb025006cf165004fa0214cb6a12cb1fcb3fc973fb0002006c810108d718fa00d33f305224810108f459f2a782106473747270748018c8cb05cb025005cf165003fa0213cb6acb1f12cb3fc973fb00000af400c9ed54696225e5')
    data = Cell.one_from_boc('b5ee9c7201010101002b0000510000004629a9a31722f1d146dcc2a181f593205cfdcc7f1b845c15947dfe7ee1a9152175f096f89440')

    emulator = TvmEmulator(code, data, 0)

    result = emulator.run_get_method('seqno', [])
    assert result['success']
    assert result['gas_used'] == 769
    assert result['vm_exit_code'] == 0
    assert result['stack'] == [70]

    result = emulator.run_get_method('get_public_key', [])
    assert result['success']
    assert result['gas_used'] == 1021
    assert result['vm_exit_code'] == 0
    assert result['stack'] == [15805891369874164427404339195218829417759249195229050328701160893742440708244]

    body = Cell.one_from_boc('b5ee9c720102040100012d0003a013a81eed9d285291b55989ee8e18d9365cd13a108be8bd4c90a06575c9dcfc425cff22f2744f55059add5ba3997762bb2530b7afc3eb2cd78f884a1cbffec00b29a9a31765dcb5e40000004600030303010203008c42004784ca9bf7f3415131e5c0d200b8748f5f3f18f23123a4fb360b6f4f0be8748ea017d78400000000000000000000000000000000000074657374206f7665726c61792033008c42004784ca9bf7f3415131e5c0d200b8748f5f3f18f23123a4fb360b6f4f0be8748ea01c9c3800000000000000000000000000000000000074657374206f7665726c61792033008c42004784ca9bf7f3415131e5c0d200b8748f5f3f18f23123a4fb360b6f4f0be8748ea02160ec00000000000000000000000000000000000074657374206f7665726c61792033')

    result = emulator.send_external_message(body)

    assert result['success']
    assert result['gas_used'] == 4592
    assert result['vm_exit_code'] == 0
    assert result['accepted']
    assert len(result['actions']) == 3
    assert result['actions'][0].type_ == 'action_send_msg'
    assert result['actions'][0].out_msg.info.dest.to_str() == 'EQCPCZU37-aComPLgaQBcOkevn4x5GJHSfZsFt6eF9DpHcw4'

    result = emulator.send_internal_message(Cell.empty(), 1)
    assert result['success']
    assert result['gas_used'] == 775
    assert result['vm_exit_code'] == 0
    assert result['accepted']
    assert len(result['actions']) == 0
