# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['AccountAuthentication']


class AccountAuthentication(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 authentication_id: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 saml_acs_url: Optional[pulumi.Input[str]] = None,
                 saml_certificate: Optional[pulumi.Input[str]] = None,
                 saml_entity_id: Optional[pulumi.Input[str]] = None,
                 saml_idp_url: Optional[pulumi.Input[str]] = None,
                 saml_metadata_url: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a AccountAuthentication resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account id
        :param pulumi.Input[str] authentication_id: Account authentication id
        :param pulumi.Input[str] create_time: Time of creation
        :param pulumi.Input[bool] enabled: Status of account authentication method
        :param pulumi.Input[str] name: Account team name
        :param pulumi.Input[str] saml_acs_url: SAML Assertion Consumer Service URL
        :param pulumi.Input[str] saml_certificate: SAML Certificate
        :param pulumi.Input[str] saml_entity_id: SAML Entity id
        :param pulumi.Input[str] saml_idp_url: SAML Idp URL
        :param pulumi.Input[str] saml_metadata_url: SAML Metadata URL
        :param pulumi.Input[str] type: Account authentication id
        :param pulumi.Input[str] update_time: Time of last update
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if account_id is None:
                raise TypeError("Missing required property 'account_id'")
            __props__['account_id'] = account_id
            __props__['authentication_id'] = authentication_id
            __props__['create_time'] = create_time
            __props__['enabled'] = enabled
            __props__['name'] = name
            __props__['saml_acs_url'] = saml_acs_url
            __props__['saml_certificate'] = saml_certificate
            __props__['saml_entity_id'] = saml_entity_id
            __props__['saml_idp_url'] = saml_idp_url
            __props__['saml_metadata_url'] = saml_metadata_url
            if type is None:
                raise TypeError("Missing required property 'type'")
            __props__['type'] = type
            __props__['update_time'] = update_time
        super(AccountAuthentication, __self__).__init__(
            'aiven:index/accountAuthentication:AccountAuthentication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            authentication_id: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            saml_acs_url: Optional[pulumi.Input[str]] = None,
            saml_certificate: Optional[pulumi.Input[str]] = None,
            saml_entity_id: Optional[pulumi.Input[str]] = None,
            saml_idp_url: Optional[pulumi.Input[str]] = None,
            saml_metadata_url: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'AccountAuthentication':
        """
        Get an existing AccountAuthentication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account id
        :param pulumi.Input[str] authentication_id: Account authentication id
        :param pulumi.Input[str] create_time: Time of creation
        :param pulumi.Input[bool] enabled: Status of account authentication method
        :param pulumi.Input[str] name: Account team name
        :param pulumi.Input[str] saml_acs_url: SAML Assertion Consumer Service URL
        :param pulumi.Input[str] saml_certificate: SAML Certificate
        :param pulumi.Input[str] saml_entity_id: SAML Entity id
        :param pulumi.Input[str] saml_idp_url: SAML Idp URL
        :param pulumi.Input[str] saml_metadata_url: SAML Metadata URL
        :param pulumi.Input[str] type: Account authentication id
        :param pulumi.Input[str] update_time: Time of last update
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["account_id"] = account_id
        __props__["authentication_id"] = authentication_id
        __props__["create_time"] = create_time
        __props__["enabled"] = enabled
        __props__["name"] = name
        __props__["saml_acs_url"] = saml_acs_url
        __props__["saml_certificate"] = saml_certificate
        __props__["saml_entity_id"] = saml_entity_id
        __props__["saml_idp_url"] = saml_idp_url
        __props__["saml_metadata_url"] = saml_metadata_url
        __props__["type"] = type
        __props__["update_time"] = update_time
        return AccountAuthentication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        Account id
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="authenticationId")
    def authentication_id(self) -> pulumi.Output[str]:
        """
        Account authentication id
        """
        return pulumi.get(self, "authentication_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time of creation
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Status of account authentication method
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Account team name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="samlAcsUrl")
    def saml_acs_url(self) -> pulumi.Output[str]:
        """
        SAML Assertion Consumer Service URL
        """
        return pulumi.get(self, "saml_acs_url")

    @property
    @pulumi.getter(name="samlCertificate")
    def saml_certificate(self) -> pulumi.Output[Optional[str]]:
        """
        SAML Certificate
        """
        return pulumi.get(self, "saml_certificate")

    @property
    @pulumi.getter(name="samlEntityId")
    def saml_entity_id(self) -> pulumi.Output[Optional[str]]:
        """
        SAML Entity id
        """
        return pulumi.get(self, "saml_entity_id")

    @property
    @pulumi.getter(name="samlIdpUrl")
    def saml_idp_url(self) -> pulumi.Output[Optional[str]]:
        """
        SAML Idp URL
        """
        return pulumi.get(self, "saml_idp_url")

    @property
    @pulumi.getter(name="samlMetadataUrl")
    def saml_metadata_url(self) -> pulumi.Output[str]:
        """
        SAML Metadata URL
        """
        return pulumi.get(self, "saml_metadata_url")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Account authentication id
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time of last update
        """
        return pulumi.get(self, "update_time")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

