# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['AccountTeamMember']


class AccountTeamMember(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accepted: Optional[pulumi.Input[bool]] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 invited_by_user_email: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a AccountTeamMember resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accepted: Team member invitation status
        :param pulumi.Input[str] account_id: Account id
        :param pulumi.Input[str] create_time: Time of creation
        :param pulumi.Input[str] invited_by_user_email: Team invited by user email
        :param pulumi.Input[str] team_id: Account team id
        :param pulumi.Input[str] user_email: Team invite user email
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['accepted'] = accepted
            if account_id is None:
                raise TypeError("Missing required property 'account_id'")
            __props__['account_id'] = account_id
            __props__['create_time'] = create_time
            __props__['invited_by_user_email'] = invited_by_user_email
            if team_id is None:
                raise TypeError("Missing required property 'team_id'")
            __props__['team_id'] = team_id
            if user_email is None:
                raise TypeError("Missing required property 'user_email'")
            __props__['user_email'] = user_email
        super(AccountTeamMember, __self__).__init__(
            'aiven:index/accountTeamMember:AccountTeamMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accepted: Optional[pulumi.Input[bool]] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            invited_by_user_email: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None,
            user_email: Optional[pulumi.Input[str]] = None) -> 'AccountTeamMember':
        """
        Get an existing AccountTeamMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accepted: Team member invitation status
        :param pulumi.Input[str] account_id: Account id
        :param pulumi.Input[str] create_time: Time of creation
        :param pulumi.Input[str] invited_by_user_email: Team invited by user email
        :param pulumi.Input[str] team_id: Account team id
        :param pulumi.Input[str] user_email: Team invite user email
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["accepted"] = accepted
        __props__["account_id"] = account_id
        __props__["create_time"] = create_time
        __props__["invited_by_user_email"] = invited_by_user_email
        __props__["team_id"] = team_id
        __props__["user_email"] = user_email
        return AccountTeamMember(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accepted(self) -> pulumi.Output[bool]:
        """
        Team member invitation status
        """
        return pulumi.get(self, "accepted")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        Account id
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time of creation
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="invitedByUserEmail")
    def invited_by_user_email(self) -> pulumi.Output[str]:
        """
        Team invited by user email
        """
        return pulumi.get(self, "invited_by_user_email")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        Account team id
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> pulumi.Output[str]:
        """
        Team invite user email
        """
        return pulumi.get(self, "user_email")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

