# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['ConnectionPool']


class ConnectionPool(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 pool_mode: Optional[pulumi.Input[str]] = None,
                 pool_name: Optional[pulumi.Input[str]] = None,
                 pool_size: Optional[pulumi.Input[float]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a ConnectionPool resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_name: Name of the database the pool connects to
        :param pulumi.Input[str] pool_mode: Mode the pool operates in (session, transaction, statement)
        :param pulumi.Input[str] pool_name: Name of the pool
        :param pulumi.Input[float] pool_size: Number of connections the pool may create towards the backend server
        :param pulumi.Input[str] project: Project to link the connection pool to
        :param pulumi.Input[str] service_name: Service to link the connection pool to
        :param pulumi.Input[str] username: Name of the service user used to connect to the database
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if database_name is None:
                raise TypeError("Missing required property 'database_name'")
            __props__['database_name'] = database_name
            __props__['pool_mode'] = pool_mode
            if pool_name is None:
                raise TypeError("Missing required property 'pool_name'")
            __props__['pool_name'] = pool_name
            __props__['pool_size'] = pool_size
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if service_name is None:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
            if username is None:
                raise TypeError("Missing required property 'username'")
            __props__['username'] = username
            __props__['connection_uri'] = None
        super(ConnectionPool, __self__).__init__(
            'aiven:index/connectionPool:ConnectionPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_uri: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            pool_mode: Optional[pulumi.Input[str]] = None,
            pool_name: Optional[pulumi.Input[str]] = None,
            pool_size: Optional[pulumi.Input[float]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'ConnectionPool':
        """
        Get an existing ConnectionPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_uri: URI for connecting to the pool
        :param pulumi.Input[str] database_name: Name of the database the pool connects to
        :param pulumi.Input[str] pool_mode: Mode the pool operates in (session, transaction, statement)
        :param pulumi.Input[str] pool_name: Name of the pool
        :param pulumi.Input[float] pool_size: Number of connections the pool may create towards the backend server
        :param pulumi.Input[str] project: Project to link the connection pool to
        :param pulumi.Input[str] service_name: Service to link the connection pool to
        :param pulumi.Input[str] username: Name of the service user used to connect to the database
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["connection_uri"] = connection_uri
        __props__["database_name"] = database_name
        __props__["pool_mode"] = pool_mode
        __props__["pool_name"] = pool_name
        __props__["pool_size"] = pool_size
        __props__["project"] = project
        __props__["service_name"] = service_name
        __props__["username"] = username
        return ConnectionPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionUri")
    def connection_uri(self) -> pulumi.Output[str]:
        """
        URI for connecting to the pool
        """
        return pulumi.get(self, "connection_uri")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[str]:
        """
        Name of the database the pool connects to
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="poolMode")
    def pool_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Mode the pool operates in (session, transaction, statement)
        """
        return pulumi.get(self, "pool_mode")

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> pulumi.Output[str]:
        """
        Name of the pool
        """
        return pulumi.get(self, "pool_name")

    @property
    @pulumi.getter(name="poolSize")
    def pool_size(self) -> pulumi.Output[Optional[float]]:
        """
        Number of connections the pool may create towards the backend server
        """
        return pulumi.get(self, "pool_size")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Project to link the connection pool to
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Service to link the connection pool to
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        Name of the service user used to connect to the database
        """
        return pulumi.get(self, "username")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

