# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['KafkaAcl']


class KafkaAcl(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 permission: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 topic: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a KafkaAcl resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] permission: Kafka permission to grant (admin, read, readwrite, write)
        :param pulumi.Input[str] project: Project to link the Kafka ACL to
        :param pulumi.Input[str] service_name: Service to link the Kafka ACL to
        :param pulumi.Input[str] topic: Topic name pattern for the ACL entry
        :param pulumi.Input[str] username: Username pattern for the ACL entry
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if permission is None:
                raise TypeError("Missing required property 'permission'")
            __props__['permission'] = permission
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if service_name is None:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
            if topic is None:
                raise TypeError("Missing required property 'topic'")
            __props__['topic'] = topic
            if username is None:
                raise TypeError("Missing required property 'username'")
            __props__['username'] = username
        super(KafkaAcl, __self__).__init__(
            'aiven:index/kafkaAcl:KafkaAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            permission: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            topic: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'KafkaAcl':
        """
        Get an existing KafkaAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] permission: Kafka permission to grant (admin, read, readwrite, write)
        :param pulumi.Input[str] project: Project to link the Kafka ACL to
        :param pulumi.Input[str] service_name: Service to link the Kafka ACL to
        :param pulumi.Input[str] topic: Topic name pattern for the ACL entry
        :param pulumi.Input[str] username: Username pattern for the ACL entry
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["permission"] = permission
        __props__["project"] = project
        __props__["service_name"] = service_name
        __props__["topic"] = topic
        __props__["username"] = username
        return KafkaAcl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Output[str]:
        """
        Kafka permission to grant (admin, read, readwrite, write)
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Project to link the Kafka ACL to
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Service to link the Kafka ACL to
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Output[str]:
        """
        Topic name pattern for the ACL entry
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        Username pattern for the ACL entry
        """
        return pulumi.get(self, "username")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

