# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['KafkaTopic']


class KafkaTopic(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cleanup_policy: Optional[pulumi.Input[str]] = None,
                 minimum_in_sync_replicas: Optional[pulumi.Input[float]] = None,
                 partitions: Optional[pulumi.Input[float]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replication: Optional[pulumi.Input[float]] = None,
                 retention_bytes: Optional[pulumi.Input[float]] = None,
                 retention_hours: Optional[pulumi.Input[float]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a KafkaTopic resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cleanup_policy: Topic cleanup policy. Allowed values: delete, compact
        :param pulumi.Input[float] minimum_in_sync_replicas: Minimum required nodes in-sync replicas (ISR) to produce to a partition
        :param pulumi.Input[float] partitions: Number of partitions to create in the topic
        :param pulumi.Input[str] project: Project to link the kafka topic to
        :param pulumi.Input[float] replication: Replication factor for the topic
        :param pulumi.Input[float] retention_bytes: Retention bytes
        :param pulumi.Input[float] retention_hours: Retention period (hours)
        :param pulumi.Input[str] service_name: Service to link the kafka topic to
        :param pulumi.Input[bool] termination_protection: It is a Terraform client-side deletion protection, which prevents a Kafka topic from being deleted. It is recommended to
               enable this for any production Kafka topic containing critical data.
        :param pulumi.Input[str] topic_name: Topic name
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['cleanup_policy'] = cleanup_policy
            __props__['minimum_in_sync_replicas'] = minimum_in_sync_replicas
            if partitions is None:
                raise TypeError("Missing required property 'partitions'")
            __props__['partitions'] = partitions
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if replication is None:
                raise TypeError("Missing required property 'replication'")
            __props__['replication'] = replication
            __props__['retention_bytes'] = retention_bytes
            __props__['retention_hours'] = retention_hours
            if service_name is None:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
            __props__['termination_protection'] = termination_protection
            if topic_name is None:
                raise TypeError("Missing required property 'topic_name'")
            __props__['topic_name'] = topic_name
        super(KafkaTopic, __self__).__init__(
            'aiven:index/kafkaTopic:KafkaTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cleanup_policy: Optional[pulumi.Input[str]] = None,
            minimum_in_sync_replicas: Optional[pulumi.Input[float]] = None,
            partitions: Optional[pulumi.Input[float]] = None,
            project: Optional[pulumi.Input[str]] = None,
            replication: Optional[pulumi.Input[float]] = None,
            retention_bytes: Optional[pulumi.Input[float]] = None,
            retention_hours: Optional[pulumi.Input[float]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            termination_protection: Optional[pulumi.Input[bool]] = None,
            topic_name: Optional[pulumi.Input[str]] = None) -> 'KafkaTopic':
        """
        Get an existing KafkaTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cleanup_policy: Topic cleanup policy. Allowed values: delete, compact
        :param pulumi.Input[float] minimum_in_sync_replicas: Minimum required nodes in-sync replicas (ISR) to produce to a partition
        :param pulumi.Input[float] partitions: Number of partitions to create in the topic
        :param pulumi.Input[str] project: Project to link the kafka topic to
        :param pulumi.Input[float] replication: Replication factor for the topic
        :param pulumi.Input[float] retention_bytes: Retention bytes
        :param pulumi.Input[float] retention_hours: Retention period (hours)
        :param pulumi.Input[str] service_name: Service to link the kafka topic to
        :param pulumi.Input[bool] termination_protection: It is a Terraform client-side deletion protection, which prevents a Kafka topic from being deleted. It is recommended to
               enable this for any production Kafka topic containing critical data.
        :param pulumi.Input[str] topic_name: Topic name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["cleanup_policy"] = cleanup_policy
        __props__["minimum_in_sync_replicas"] = minimum_in_sync_replicas
        __props__["partitions"] = partitions
        __props__["project"] = project
        __props__["replication"] = replication
        __props__["retention_bytes"] = retention_bytes
        __props__["retention_hours"] = retention_hours
        __props__["service_name"] = service_name
        __props__["termination_protection"] = termination_protection
        __props__["topic_name"] = topic_name
        return KafkaTopic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cleanupPolicy")
    def cleanup_policy(self) -> pulumi.Output[Optional[str]]:
        """
        Topic cleanup policy. Allowed values: delete, compact
        """
        return pulumi.get(self, "cleanup_policy")

    @property
    @pulumi.getter(name="minimumInSyncReplicas")
    def minimum_in_sync_replicas(self) -> pulumi.Output[Optional[float]]:
        """
        Minimum required nodes in-sync replicas (ISR) to produce to a partition
        """
        return pulumi.get(self, "minimum_in_sync_replicas")

    @property
    @pulumi.getter
    def partitions(self) -> pulumi.Output[float]:
        """
        Number of partitions to create in the topic
        """
        return pulumi.get(self, "partitions")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Project to link the kafka topic to
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def replication(self) -> pulumi.Output[float]:
        """
        Replication factor for the topic
        """
        return pulumi.get(self, "replication")

    @property
    @pulumi.getter(name="retentionBytes")
    def retention_bytes(self) -> pulumi.Output[Optional[float]]:
        """
        Retention bytes
        """
        return pulumi.get(self, "retention_bytes")

    @property
    @pulumi.getter(name="retentionHours")
    def retention_hours(self) -> pulumi.Output[Optional[float]]:
        """
        Retention period (hours)
        """
        return pulumi.get(self, "retention_hours")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Service to link the kafka topic to
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        It is a Terraform client-side deletion protection, which prevents a Kafka topic from being deleted. It is recommended to
        enable this for any production Kafka topic containing critical data.
        """
        return pulumi.get(self, "termination_protection")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> pulumi.Output[str]:
        """
        Topic name
        """
        return pulumi.get(self, "topic_name")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

