# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['MirrorMakerReplicationFlow']


class MirrorMakerReplicationFlow(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 source_cluster: Optional[pulumi.Input[str]] = None,
                 target_cluster: Optional[pulumi.Input[str]] = None,
                 topics: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 topics_blacklists: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a MirrorMakerReplicationFlow resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable: Enable of disable replication flows for a service
        :param pulumi.Input[str] project: Project to link the kafka topic to
        :param pulumi.Input[str] service_name: Service to link the kafka topic to
        :param pulumi.Input[str] source_cluster: Source cluster alias
        :param pulumi.Input[str] target_cluster: Target cluster alias
        :param pulumi.Input[List[pulumi.Input[str]]] topics: List of topics and/or regular expressions to replicate
        :param pulumi.Input[List[pulumi.Input[str]]] topics_blacklists: List of topics and/or regular expressions to not replicate.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if enable is None:
                raise TypeError("Missing required property 'enable'")
            __props__['enable'] = enable
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if service_name is None:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
            if source_cluster is None:
                raise TypeError("Missing required property 'source_cluster'")
            __props__['source_cluster'] = source_cluster
            if target_cluster is None:
                raise TypeError("Missing required property 'target_cluster'")
            __props__['target_cluster'] = target_cluster
            __props__['topics'] = topics
            __props__['topics_blacklists'] = topics_blacklists
        super(MirrorMakerReplicationFlow, __self__).__init__(
            'aiven:index/mirrorMakerReplicationFlow:MirrorMakerReplicationFlow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            source_cluster: Optional[pulumi.Input[str]] = None,
            target_cluster: Optional[pulumi.Input[str]] = None,
            topics: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            topics_blacklists: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None) -> 'MirrorMakerReplicationFlow':
        """
        Get an existing MirrorMakerReplicationFlow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable: Enable of disable replication flows for a service
        :param pulumi.Input[str] project: Project to link the kafka topic to
        :param pulumi.Input[str] service_name: Service to link the kafka topic to
        :param pulumi.Input[str] source_cluster: Source cluster alias
        :param pulumi.Input[str] target_cluster: Target cluster alias
        :param pulumi.Input[List[pulumi.Input[str]]] topics: List of topics and/or regular expressions to replicate
        :param pulumi.Input[List[pulumi.Input[str]]] topics_blacklists: List of topics and/or regular expressions to not replicate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["enable"] = enable
        __props__["project"] = project
        __props__["service_name"] = service_name
        __props__["source_cluster"] = source_cluster
        __props__["target_cluster"] = target_cluster
        __props__["topics"] = topics
        __props__["topics_blacklists"] = topics_blacklists
        return MirrorMakerReplicationFlow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Output[bool]:
        """
        Enable of disable replication flows for a service
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Project to link the kafka topic to
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Service to link the kafka topic to
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="sourceCluster")
    def source_cluster(self) -> pulumi.Output[str]:
        """
        Source cluster alias
        """
        return pulumi.get(self, "source_cluster")

    @property
    @pulumi.getter(name="targetCluster")
    def target_cluster(self) -> pulumi.Output[str]:
        """
        Target cluster alias
        """
        return pulumi.get(self, "target_cluster")

    @property
    @pulumi.getter
    def topics(self) -> pulumi.Output[Optional[List[str]]]:
        """
        List of topics and/or regular expressions to replicate
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter(name="topicsBlacklists")
    def topics_blacklists(self) -> pulumi.Output[Optional[List[str]]]:
        """
        List of topics and/or regular expressions to not replicate.
        """
        return pulumi.get(self, "topics_blacklists")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

