# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['MySql']


class MySql(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 mysql: Optional[pulumi.Input[pulumi.InputType['MySqlMysqlArgs']]] = None,
                 mysql_user_config: Optional[pulumi.Input[pulumi.InputType['MySqlMysqlUserConfigArgs']]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 service_integrations: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['MySqlServiceIntegrationArgs']]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a MySql resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cloud_name: Cloud the service runs in
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input[pulumi.InputType['MySqlMysqlArgs']] mysql: MySQL specific server provided values
        :param pulumi.Input[pulumi.InputType['MySqlMysqlUserConfigArgs']] mysql_user_config: MySQL specific user configurable settings
        :param pulumi.Input[str] plan: Subscription plan
        :param pulumi.Input[str] project: Target project
        :param pulumi.Input[str] project_vpc_id: Identifier of the VPC the service should be in, if any
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['MySqlServiceIntegrationArgs']]]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: Service name
        :param pulumi.Input[bool] termination_protection: Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['cloud_name'] = cloud_name
            __props__['maintenance_window_dow'] = maintenance_window_dow
            __props__['maintenance_window_time'] = maintenance_window_time
            __props__['mysql'] = mysql
            __props__['mysql_user_config'] = mysql_user_config
            __props__['plan'] = plan
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['project_vpc_id'] = project_vpc_id
            __props__['service_integrations'] = service_integrations
            if service_name is None:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
            __props__['termination_protection'] = termination_protection
            __props__['components'] = None
            __props__['service_host'] = None
            __props__['service_password'] = None
            __props__['service_port'] = None
            __props__['service_type'] = None
            __props__['service_uri'] = None
            __props__['service_username'] = None
            __props__['state'] = None
        super(MySql, __self__).__init__(
            'aiven:index/mySql:MySql',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_name: Optional[pulumi.Input[str]] = None,
            components: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['MySqlComponentArgs']]]]] = None,
            maintenance_window_dow: Optional[pulumi.Input[str]] = None,
            maintenance_window_time: Optional[pulumi.Input[str]] = None,
            mysql: Optional[pulumi.Input[pulumi.InputType['MySqlMysqlArgs']]] = None,
            mysql_user_config: Optional[pulumi.Input[pulumi.InputType['MySqlMysqlUserConfigArgs']]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            project_vpc_id: Optional[pulumi.Input[str]] = None,
            service_host: Optional[pulumi.Input[str]] = None,
            service_integrations: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['MySqlServiceIntegrationArgs']]]]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            service_password: Optional[pulumi.Input[str]] = None,
            service_port: Optional[pulumi.Input[float]] = None,
            service_type: Optional[pulumi.Input[str]] = None,
            service_uri: Optional[pulumi.Input[str]] = None,
            service_username: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            termination_protection: Optional[pulumi.Input[bool]] = None) -> 'MySql':
        """
        Get an existing MySql resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cloud_name: Cloud the service runs in
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['MySqlComponentArgs']]]] components: Service component information objects
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input[pulumi.InputType['MySqlMysqlArgs']] mysql: MySQL specific server provided values
        :param pulumi.Input[pulumi.InputType['MySqlMysqlUserConfigArgs']] mysql_user_config: MySQL specific user configurable settings
        :param pulumi.Input[str] plan: Subscription plan
        :param pulumi.Input[str] project: Target project
        :param pulumi.Input[str] project_vpc_id: Identifier of the VPC the service should be in, if any
        :param pulumi.Input[str] service_host: Service hostname
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['MySqlServiceIntegrationArgs']]]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: Service name
        :param pulumi.Input[str] service_password: Password used for connecting to the service, if applicable
        :param pulumi.Input[float] service_port: Service port
        :param pulumi.Input[str] service_type: Aiven internal service type code
        :param pulumi.Input[str] service_uri: URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        :param pulumi.Input[str] service_username: Username used for connecting to the service, if applicable
        :param pulumi.Input[str] state: Service state
        :param pulumi.Input[bool] termination_protection: Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["cloud_name"] = cloud_name
        __props__["components"] = components
        __props__["maintenance_window_dow"] = maintenance_window_dow
        __props__["maintenance_window_time"] = maintenance_window_time
        __props__["mysql"] = mysql
        __props__["mysql_user_config"] = mysql_user_config
        __props__["plan"] = plan
        __props__["project"] = project
        __props__["project_vpc_id"] = project_vpc_id
        __props__["service_host"] = service_host
        __props__["service_integrations"] = service_integrations
        __props__["service_name"] = service_name
        __props__["service_password"] = service_password
        __props__["service_port"] = service_port
        __props__["service_type"] = service_type
        __props__["service_uri"] = service_uri
        __props__["service_username"] = service_username
        __props__["state"] = state
        __props__["termination_protection"] = termination_protection
        return MySql(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> pulumi.Output[Optional[str]]:
        """
        Cloud the service runs in
        """
        return pulumi.get(self, "cloud_name")

    @property
    @pulumi.getter
    def components(self) -> pulumi.Output[List['outputs.MySqlComponent']]:
        """
        Service component information objects
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> pulumi.Output[Optional[str]]:
        """
        Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> pulumi.Output[Optional[str]]:
        """
        Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @property
    @pulumi.getter
    def mysql(self) -> pulumi.Output['outputs.MySqlMysql']:
        """
        MySQL specific server provided values
        """
        return pulumi.get(self, "mysql")

    @property
    @pulumi.getter(name="mysqlUserConfig")
    def mysql_user_config(self) -> pulumi.Output[Optional['outputs.MySqlMysqlUserConfig']]:
        """
        MySQL specific user configurable settings
        """
        return pulumi.get(self, "mysql_user_config")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional[str]]:
        """
        Subscription plan
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Target project
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier of the VPC the service should be in, if any
        """
        return pulumi.get(self, "project_vpc_id")

    @property
    @pulumi.getter(name="serviceHost")
    def service_host(self) -> pulumi.Output[str]:
        """
        Service hostname
        """
        return pulumi.get(self, "service_host")

    @property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> pulumi.Output[Optional[List['outputs.MySqlServiceIntegration']]]:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> pulumi.Output[str]:
        """
        Password used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_password")

    @property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> pulumi.Output[float]:
        """
        Service port
        """
        return pulumi.get(self, "service_port")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[str]:
        """
        Aiven internal service type code
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> pulumi.Output[str]:
        """
        URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        """
        return pulumi.get(self, "service_uri")

    @property
    @pulumi.getter(name="serviceUsername")
    def service_username(self) -> pulumi.Output[str]:
        """
        Username used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_username")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Service state
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        return pulumi.get(self, "termination_protection")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

