# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['Project']


class Project(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 billing_address: Optional[pulumi.Input[str]] = None,
                 billing_emails: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 ca_cert: Optional[pulumi.Input[str]] = None,
                 card_id: Optional[pulumi.Input[str]] = None,
                 copy_from_project: Optional[pulumi.Input[str]] = None,
                 country_code: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 technical_emails: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a Project resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account ID
        :param pulumi.Input[str] billing_address: Billing name and address of the project
        :param pulumi.Input[List[pulumi.Input[str]]] billing_emails: Billing contact emails of the project
        :param pulumi.Input[str] ca_cert: Project root CA. This is used by some services like Kafka to sign service certificate
        :param pulumi.Input[str] card_id: Credit card ID
        :param pulumi.Input[str] copy_from_project: Copy properties from another project. Only has effect when a new project is created.
        :param pulumi.Input[str] country_code: Billing country code of the project
        :param pulumi.Input[str] project: Project name
        :param pulumi.Input[List[pulumi.Input[str]]] technical_emails: Technical contact emails of the project
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['account_id'] = account_id
            __props__['billing_address'] = billing_address
            __props__['billing_emails'] = billing_emails
            __props__['ca_cert'] = ca_cert
            __props__['card_id'] = card_id
            __props__['copy_from_project'] = copy_from_project
            __props__['country_code'] = country_code
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['technical_emails'] = technical_emails
        super(Project, __self__).__init__(
            'aiven:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            billing_address: Optional[pulumi.Input[str]] = None,
            billing_emails: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            ca_cert: Optional[pulumi.Input[str]] = None,
            card_id: Optional[pulumi.Input[str]] = None,
            copy_from_project: Optional[pulumi.Input[str]] = None,
            country_code: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            technical_emails: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account ID
        :param pulumi.Input[str] billing_address: Billing name and address of the project
        :param pulumi.Input[List[pulumi.Input[str]]] billing_emails: Billing contact emails of the project
        :param pulumi.Input[str] ca_cert: Project root CA. This is used by some services like Kafka to sign service certificate
        :param pulumi.Input[str] card_id: Credit card ID
        :param pulumi.Input[str] copy_from_project: Copy properties from another project. Only has effect when a new project is created.
        :param pulumi.Input[str] country_code: Billing country code of the project
        :param pulumi.Input[str] project: Project name
        :param pulumi.Input[List[pulumi.Input[str]]] technical_emails: Technical contact emails of the project
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["account_id"] = account_id
        __props__["billing_address"] = billing_address
        __props__["billing_emails"] = billing_emails
        __props__["ca_cert"] = ca_cert
        __props__["card_id"] = card_id
        __props__["copy_from_project"] = copy_from_project
        __props__["country_code"] = country_code
        __props__["project"] = project
        __props__["technical_emails"] = technical_emails
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[str]]:
        """
        Account ID
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="billingAddress")
    def billing_address(self) -> pulumi.Output[Optional[str]]:
        """
        Billing name and address of the project
        """
        return pulumi.get(self, "billing_address")

    @property
    @pulumi.getter(name="billingEmails")
    def billing_emails(self) -> pulumi.Output[Optional[List[str]]]:
        """
        Billing contact emails of the project
        """
        return pulumi.get(self, "billing_emails")

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> pulumi.Output[str]:
        """
        Project root CA. This is used by some services like Kafka to sign service certificate
        """
        return pulumi.get(self, "ca_cert")

    @property
    @pulumi.getter(name="cardId")
    def card_id(self) -> pulumi.Output[Optional[str]]:
        """
        Credit card ID
        """
        return pulumi.get(self, "card_id")

    @property
    @pulumi.getter(name="copyFromProject")
    def copy_from_project(self) -> pulumi.Output[Optional[str]]:
        """
        Copy properties from another project. Only has effect when a new project is created.
        """
        return pulumi.get(self, "copy_from_project")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Output[Optional[str]]:
        """
        Billing country code of the project
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Project name
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="technicalEmails")
    def technical_emails(self) -> pulumi.Output[Optional[List[str]]]:
        """
        Technical contact emails of the project
        """
        return pulumi.get(self, "technical_emails")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

