# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['VpcPeeringConnection']


class VpcPeeringConnection(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 peer_azure_app_id: Optional[pulumi.Input[str]] = None,
                 peer_azure_tenant_id: Optional[pulumi.Input[str]] = None,
                 peer_cloud_account: Optional[pulumi.Input[str]] = None,
                 peer_region: Optional[pulumi.Input[str]] = None,
                 peer_resource_group: Optional[pulumi.Input[str]] = None,
                 peer_vpc: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a VpcPeeringConnection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] peer_azure_app_id: Azure app registration id in UUID4 form that is allowed to create a peering to the peer vnet
        :param pulumi.Input[str] peer_azure_tenant_id: Azure tenant id in UUID4 form
        :param pulumi.Input[str] peer_cloud_account: AWS account ID or GCP project ID of the peered VPC
        :param pulumi.Input[str] peer_region: AWS region of the peered VPC (if not in the same region as Aiven VPC)
        :param pulumi.Input[str] peer_resource_group: Azure resource group name of the peered VPC
        :param pulumi.Input[str] peer_vpc: AWS VPC ID or GCP VPC network name of the peered VPC
        :param pulumi.Input[str] vpc_id: The VPC the peering connection belongs to
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['peer_azure_app_id'] = peer_azure_app_id
            __props__['peer_azure_tenant_id'] = peer_azure_tenant_id
            if peer_cloud_account is None:
                raise TypeError("Missing required property 'peer_cloud_account'")
            __props__['peer_cloud_account'] = peer_cloud_account
            __props__['peer_region'] = peer_region
            __props__['peer_resource_group'] = peer_resource_group
            if peer_vpc is None:
                raise TypeError("Missing required property 'peer_vpc'")
            __props__['peer_vpc'] = peer_vpc
            if vpc_id is None:
                raise TypeError("Missing required property 'vpc_id'")
            __props__['vpc_id'] = vpc_id
            __props__['peering_connection_id'] = None
            __props__['state'] = None
            __props__['state_info'] = None
        super(VpcPeeringConnection, __self__).__init__(
            'aiven:index/vpcPeeringConnection:VpcPeeringConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            peer_azure_app_id: Optional[pulumi.Input[str]] = None,
            peer_azure_tenant_id: Optional[pulumi.Input[str]] = None,
            peer_cloud_account: Optional[pulumi.Input[str]] = None,
            peer_region: Optional[pulumi.Input[str]] = None,
            peer_resource_group: Optional[pulumi.Input[str]] = None,
            peer_vpc: Optional[pulumi.Input[str]] = None,
            peering_connection_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            state_info: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'VpcPeeringConnection':
        """
        Get an existing VpcPeeringConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] peer_azure_app_id: Azure app registration id in UUID4 form that is allowed to create a peering to the peer vnet
        :param pulumi.Input[str] peer_azure_tenant_id: Azure tenant id in UUID4 form
        :param pulumi.Input[str] peer_cloud_account: AWS account ID or GCP project ID of the peered VPC
        :param pulumi.Input[str] peer_region: AWS region of the peered VPC (if not in the same region as Aiven VPC)
        :param pulumi.Input[str] peer_resource_group: Azure resource group name of the peered VPC
        :param pulumi.Input[str] peer_vpc: AWS VPC ID or GCP VPC network name of the peered VPC
        :param pulumi.Input[str] peering_connection_id: Cloud provider identifier for the peering connection if available
        :param pulumi.Input[str] state: State of the peering connection
        :param pulumi.Input[Mapping[str, Any]] state_info: State-specific help or error information
        :param pulumi.Input[str] vpc_id: The VPC the peering connection belongs to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["peer_azure_app_id"] = peer_azure_app_id
        __props__["peer_azure_tenant_id"] = peer_azure_tenant_id
        __props__["peer_cloud_account"] = peer_cloud_account
        __props__["peer_region"] = peer_region
        __props__["peer_resource_group"] = peer_resource_group
        __props__["peer_vpc"] = peer_vpc
        __props__["peering_connection_id"] = peering_connection_id
        __props__["state"] = state
        __props__["state_info"] = state_info
        __props__["vpc_id"] = vpc_id
        return VpcPeeringConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="peerAzureAppId")
    def peer_azure_app_id(self) -> pulumi.Output[Optional[str]]:
        """
        Azure app registration id in UUID4 form that is allowed to create a peering to the peer vnet
        """
        return pulumi.get(self, "peer_azure_app_id")

    @property
    @pulumi.getter(name="peerAzureTenantId")
    def peer_azure_tenant_id(self) -> pulumi.Output[Optional[str]]:
        """
        Azure tenant id in UUID4 form
        """
        return pulumi.get(self, "peer_azure_tenant_id")

    @property
    @pulumi.getter(name="peerCloudAccount")
    def peer_cloud_account(self) -> pulumi.Output[str]:
        """
        AWS account ID or GCP project ID of the peered VPC
        """
        return pulumi.get(self, "peer_cloud_account")

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> pulumi.Output[Optional[str]]:
        """
        AWS region of the peered VPC (if not in the same region as Aiven VPC)
        """
        return pulumi.get(self, "peer_region")

    @property
    @pulumi.getter(name="peerResourceGroup")
    def peer_resource_group(self) -> pulumi.Output[Optional[str]]:
        """
        Azure resource group name of the peered VPC
        """
        return pulumi.get(self, "peer_resource_group")

    @property
    @pulumi.getter(name="peerVpc")
    def peer_vpc(self) -> pulumi.Output[str]:
        """
        AWS VPC ID or GCP VPC network name of the peered VPC
        """
        return pulumi.get(self, "peer_vpc")

    @property
    @pulumi.getter(name="peeringConnectionId")
    def peering_connection_id(self) -> pulumi.Output[str]:
        """
        Cloud provider identifier for the peering connection if available
        """
        return pulumi.get(self, "peering_connection_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the peering connection
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInfo")
    def state_info(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        State-specific help or error information
        """
        return pulumi.get(self, "state_info")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The VPC the peering connection belongs to
        """
        return pulumi.get(self, "vpc_id")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

