"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionProcessor = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an AWS Lambda function to transform records.
 */
class LambdaFunctionProcessor {
    constructor(lambdaFunction, props = {}) {
        this.lambdaFunction = lambdaFunction;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_kinesisfirehose_alpha_DataProcessorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaFunctionProcessor);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_kinesisfirehose_alpha_DataProcessorBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.lambdaFunction.grantInvoke(options.role);
        return {
            processorType: 'Lambda',
            processorIdentifier: {
                parameterName: 'LambdaArn',
                parameterValue: this.lambdaFunction.functionArn,
            },
        };
    }
}
exports.LambdaFunctionProcessor = LambdaFunctionProcessor;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionProcessor[_a] = { fqn: "@aws-cdk/aws-kinesisfirehose-alpha.LambdaFunctionProcessor", version: "2.123.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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