# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigEntryServiceDefaultsArgs', 'ConfigEntryServiceDefaults']

@pulumi.input_type
class ConfigEntryServiceDefaultsArgs:
    def __init__(__self__, *,
                 exposes: pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsExposeArgs']]],
                 protocol: pulumi.Input[_builtins.str],
                 balance_inbound_connections: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsDestinationArgs']]]] = None,
                 envoy_extensions: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsEnvoyExtensionArgs']]]] = None,
                 external_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 local_connect_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 local_request_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 max_inbound_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 mesh_gateways: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsMeshGatewayArgs']]]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 mutual_tls_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 transparent_proxies: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsTransparentProxyArgs']]]] = None,
                 upstream_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsUpstreamConfigArgs']]]] = None):
        """
        The set of arguments for constructing a ConfigEntryServiceDefaults resource.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsExposeArgs']]] exposes: Specifies default configurations for exposing HTTP paths through Envoy.
        :param pulumi.Input[_builtins.str] protocol: Specifies the default protocol for the service.
        :param pulumi.Input[_builtins.str] balance_inbound_connections: Specifies the strategy for allocating inbound connections to the service across Envoy proxy threads.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsDestinationArgs']]] destinations: Configures the destination for service traffic through terminating gateways.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsEnvoyExtensionArgs']]] envoy_extensions: List of extensions to modify Envoy proxy configuration.
        :param pulumi.Input[_builtins.str] external_sni: Specifies the TLS server name indication (SNI) when federating with an external system.
        :param pulumi.Input[_builtins.int] local_connect_timeout_ms: Specifies the number of milliseconds allowed for establishing connections to the local application instance before timing out.
        :param pulumi.Input[_builtins.int] local_request_timeout_ms: Specifies the timeout for HTTP requests to the local application instance.
        :param pulumi.Input[_builtins.int] max_inbound_connections: Specifies the maximum number of concurrent inbound connections to each service instance.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsMeshGatewayArgs']]] mesh_gateways: Specifies the default mesh gateway mode field for the service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: Specifies a set of custom key-value pairs to add to the Consul KV store.
        :param pulumi.Input[_builtins.str] mode: Specifies a mode for how the service directs inbound and outbound traffic.
        :param pulumi.Input[_builtins.str] mutual_tls_mode: Controls whether mutual TLS is required for incoming connections to this service. This setting is only supported for services with transparent proxy enabled.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the service you are setting the defaults for.
        :param pulumi.Input[_builtins.str] namespace: Specifies the Consul namespace that the configuration entry applies to.
        :param pulumi.Input[_builtins.str] partition: Specifies the name of the name of the Consul admin partition that the configuration entry applies to. Refer to Admin Partitions for additional information.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsTransparentProxyArgs']]] transparent_proxies: Controls configurations specific to proxies in transparent mode. Refer to Transparent Proxy Mode for additional information.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsUpstreamConfigArgs']]] upstream_configs: Controls default upstream connection settings and custom overrides for individual upstream services.
        """
        pulumi.set(__self__, "exposes", exposes)
        pulumi.set(__self__, "protocol", protocol)
        if balance_inbound_connections is not None:
            pulumi.set(__self__, "balance_inbound_connections", balance_inbound_connections)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if envoy_extensions is not None:
            pulumi.set(__self__, "envoy_extensions", envoy_extensions)
        if external_sni is not None:
            pulumi.set(__self__, "external_sni", external_sni)
        if local_connect_timeout_ms is not None:
            pulumi.set(__self__, "local_connect_timeout_ms", local_connect_timeout_ms)
        if local_request_timeout_ms is not None:
            pulumi.set(__self__, "local_request_timeout_ms", local_request_timeout_ms)
        if max_inbound_connections is not None:
            pulumi.set(__self__, "max_inbound_connections", max_inbound_connections)
        if mesh_gateways is not None:
            pulumi.set(__self__, "mesh_gateways", mesh_gateways)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if mutual_tls_mode is not None:
            pulumi.set(__self__, "mutual_tls_mode", mutual_tls_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if transparent_proxies is not None:
            pulumi.set(__self__, "transparent_proxies", transparent_proxies)
        if upstream_configs is not None:
            pulumi.set(__self__, "upstream_configs", upstream_configs)

    @_builtins.property
    @pulumi.getter
    def exposes(self) -> pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsExposeArgs']]]:
        """
        Specifies default configurations for exposing HTTP paths through Envoy.
        """
        return pulumi.get(self, "exposes")

    @exposes.setter
    def exposes(self, value: pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsExposeArgs']]]):
        pulumi.set(self, "exposes", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the default protocol for the service.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="balanceInboundConnections")
    def balance_inbound_connections(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the strategy for allocating inbound connections to the service across Envoy proxy threads.
        """
        return pulumi.get(self, "balance_inbound_connections")

    @balance_inbound_connections.setter
    def balance_inbound_connections(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "balance_inbound_connections", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsDestinationArgs']]]]:
        """
        Configures the destination for service traffic through terminating gateways.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter(name="envoyExtensions")
    def envoy_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsEnvoyExtensionArgs']]]]:
        """
        List of extensions to modify Envoy proxy configuration.
        """
        return pulumi.get(self, "envoy_extensions")

    @envoy_extensions.setter
    def envoy_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsEnvoyExtensionArgs']]]]):
        pulumi.set(self, "envoy_extensions", value)

    @_builtins.property
    @pulumi.getter(name="externalSni")
    def external_sni(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the TLS server name indication (SNI) when federating with an external system.
        """
        return pulumi.get(self, "external_sni")

    @external_sni.setter
    def external_sni(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_sni", value)

    @_builtins.property
    @pulumi.getter(name="localConnectTimeoutMs")
    def local_connect_timeout_ms(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of milliseconds allowed for establishing connections to the local application instance before timing out.
        """
        return pulumi.get(self, "local_connect_timeout_ms")

    @local_connect_timeout_ms.setter
    def local_connect_timeout_ms(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "local_connect_timeout_ms", value)

    @_builtins.property
    @pulumi.getter(name="localRequestTimeoutMs")
    def local_request_timeout_ms(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the timeout for HTTP requests to the local application instance.
        """
        return pulumi.get(self, "local_request_timeout_ms")

    @local_request_timeout_ms.setter
    def local_request_timeout_ms(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "local_request_timeout_ms", value)

    @_builtins.property
    @pulumi.getter(name="maxInboundConnections")
    def max_inbound_connections(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of concurrent inbound connections to each service instance.
        """
        return pulumi.get(self, "max_inbound_connections")

    @max_inbound_connections.setter
    def max_inbound_connections(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_inbound_connections", value)

    @_builtins.property
    @pulumi.getter(name="meshGateways")
    def mesh_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsMeshGatewayArgs']]]]:
        """
        Specifies the default mesh gateway mode field for the service.
        """
        return pulumi.get(self, "mesh_gateways")

    @mesh_gateways.setter
    def mesh_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsMeshGatewayArgs']]]]):
        pulumi.set(self, "mesh_gateways", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a set of custom key-value pairs to add to the Consul KV store.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a mode for how the service directs inbound and outbound traffic.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="mutualTlsMode")
    def mutual_tls_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls whether mutual TLS is required for incoming connections to this service. This setting is only supported for services with transparent proxy enabled.
        """
        return pulumi.get(self, "mutual_tls_mode")

    @mutual_tls_mode.setter
    def mutual_tls_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mutual_tls_mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the service you are setting the defaults for.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Consul namespace that the configuration entry applies to.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the name of the Consul admin partition that the configuration entry applies to. Refer to Admin Partitions for additional information.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter(name="transparentProxies")
    def transparent_proxies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsTransparentProxyArgs']]]]:
        """
        Controls configurations specific to proxies in transparent mode. Refer to Transparent Proxy Mode for additional information.
        """
        return pulumi.get(self, "transparent_proxies")

    @transparent_proxies.setter
    def transparent_proxies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsTransparentProxyArgs']]]]):
        pulumi.set(self, "transparent_proxies", value)

    @_builtins.property
    @pulumi.getter(name="upstreamConfigs")
    def upstream_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsUpstreamConfigArgs']]]]:
        """
        Controls default upstream connection settings and custom overrides for individual upstream services.
        """
        return pulumi.get(self, "upstream_configs")

    @upstream_configs.setter
    def upstream_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsUpstreamConfigArgs']]]]):
        pulumi.set(self, "upstream_configs", value)


@pulumi.input_type
class _ConfigEntryServiceDefaultsState:
    def __init__(__self__, *,
                 balance_inbound_connections: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsDestinationArgs']]]] = None,
                 envoy_extensions: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsEnvoyExtensionArgs']]]] = None,
                 exposes: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsExposeArgs']]]] = None,
                 external_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 local_connect_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 local_request_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 max_inbound_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 mesh_gateways: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsMeshGatewayArgs']]]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 mutual_tls_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 transparent_proxies: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsTransparentProxyArgs']]]] = None,
                 upstream_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsUpstreamConfigArgs']]]] = None):
        """
        Input properties used for looking up and filtering ConfigEntryServiceDefaults resources.
        :param pulumi.Input[_builtins.str] balance_inbound_connections: Specifies the strategy for allocating inbound connections to the service across Envoy proxy threads.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsDestinationArgs']]] destinations: Configures the destination for service traffic through terminating gateways.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsEnvoyExtensionArgs']]] envoy_extensions: List of extensions to modify Envoy proxy configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsExposeArgs']]] exposes: Specifies default configurations for exposing HTTP paths through Envoy.
        :param pulumi.Input[_builtins.str] external_sni: Specifies the TLS server name indication (SNI) when federating with an external system.
        :param pulumi.Input[_builtins.int] local_connect_timeout_ms: Specifies the number of milliseconds allowed for establishing connections to the local application instance before timing out.
        :param pulumi.Input[_builtins.int] local_request_timeout_ms: Specifies the timeout for HTTP requests to the local application instance.
        :param pulumi.Input[_builtins.int] max_inbound_connections: Specifies the maximum number of concurrent inbound connections to each service instance.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsMeshGatewayArgs']]] mesh_gateways: Specifies the default mesh gateway mode field for the service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: Specifies a set of custom key-value pairs to add to the Consul KV store.
        :param pulumi.Input[_builtins.str] mode: Specifies a mode for how the service directs inbound and outbound traffic.
        :param pulumi.Input[_builtins.str] mutual_tls_mode: Controls whether mutual TLS is required for incoming connections to this service. This setting is only supported for services with transparent proxy enabled.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the service you are setting the defaults for.
        :param pulumi.Input[_builtins.str] namespace: Specifies the Consul namespace that the configuration entry applies to.
        :param pulumi.Input[_builtins.str] partition: Specifies the name of the name of the Consul admin partition that the configuration entry applies to. Refer to Admin Partitions for additional information.
        :param pulumi.Input[_builtins.str] protocol: Specifies the default protocol for the service.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsTransparentProxyArgs']]] transparent_proxies: Controls configurations specific to proxies in transparent mode. Refer to Transparent Proxy Mode for additional information.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsUpstreamConfigArgs']]] upstream_configs: Controls default upstream connection settings and custom overrides for individual upstream services.
        """
        if balance_inbound_connections is not None:
            pulumi.set(__self__, "balance_inbound_connections", balance_inbound_connections)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if envoy_extensions is not None:
            pulumi.set(__self__, "envoy_extensions", envoy_extensions)
        if exposes is not None:
            pulumi.set(__self__, "exposes", exposes)
        if external_sni is not None:
            pulumi.set(__self__, "external_sni", external_sni)
        if local_connect_timeout_ms is not None:
            pulumi.set(__self__, "local_connect_timeout_ms", local_connect_timeout_ms)
        if local_request_timeout_ms is not None:
            pulumi.set(__self__, "local_request_timeout_ms", local_request_timeout_ms)
        if max_inbound_connections is not None:
            pulumi.set(__self__, "max_inbound_connections", max_inbound_connections)
        if mesh_gateways is not None:
            pulumi.set(__self__, "mesh_gateways", mesh_gateways)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if mutual_tls_mode is not None:
            pulumi.set(__self__, "mutual_tls_mode", mutual_tls_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if transparent_proxies is not None:
            pulumi.set(__self__, "transparent_proxies", transparent_proxies)
        if upstream_configs is not None:
            pulumi.set(__self__, "upstream_configs", upstream_configs)

    @_builtins.property
    @pulumi.getter(name="balanceInboundConnections")
    def balance_inbound_connections(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the strategy for allocating inbound connections to the service across Envoy proxy threads.
        """
        return pulumi.get(self, "balance_inbound_connections")

    @balance_inbound_connections.setter
    def balance_inbound_connections(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "balance_inbound_connections", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsDestinationArgs']]]]:
        """
        Configures the destination for service traffic through terminating gateways.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter(name="envoyExtensions")
    def envoy_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsEnvoyExtensionArgs']]]]:
        """
        List of extensions to modify Envoy proxy configuration.
        """
        return pulumi.get(self, "envoy_extensions")

    @envoy_extensions.setter
    def envoy_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsEnvoyExtensionArgs']]]]):
        pulumi.set(self, "envoy_extensions", value)

    @_builtins.property
    @pulumi.getter
    def exposes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsExposeArgs']]]]:
        """
        Specifies default configurations for exposing HTTP paths through Envoy.
        """
        return pulumi.get(self, "exposes")

    @exposes.setter
    def exposes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsExposeArgs']]]]):
        pulumi.set(self, "exposes", value)

    @_builtins.property
    @pulumi.getter(name="externalSni")
    def external_sni(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the TLS server name indication (SNI) when federating with an external system.
        """
        return pulumi.get(self, "external_sni")

    @external_sni.setter
    def external_sni(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_sni", value)

    @_builtins.property
    @pulumi.getter(name="localConnectTimeoutMs")
    def local_connect_timeout_ms(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of milliseconds allowed for establishing connections to the local application instance before timing out.
        """
        return pulumi.get(self, "local_connect_timeout_ms")

    @local_connect_timeout_ms.setter
    def local_connect_timeout_ms(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "local_connect_timeout_ms", value)

    @_builtins.property
    @pulumi.getter(name="localRequestTimeoutMs")
    def local_request_timeout_ms(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the timeout for HTTP requests to the local application instance.
        """
        return pulumi.get(self, "local_request_timeout_ms")

    @local_request_timeout_ms.setter
    def local_request_timeout_ms(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "local_request_timeout_ms", value)

    @_builtins.property
    @pulumi.getter(name="maxInboundConnections")
    def max_inbound_connections(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of concurrent inbound connections to each service instance.
        """
        return pulumi.get(self, "max_inbound_connections")

    @max_inbound_connections.setter
    def max_inbound_connections(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_inbound_connections", value)

    @_builtins.property
    @pulumi.getter(name="meshGateways")
    def mesh_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsMeshGatewayArgs']]]]:
        """
        Specifies the default mesh gateway mode field for the service.
        """
        return pulumi.get(self, "mesh_gateways")

    @mesh_gateways.setter
    def mesh_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsMeshGatewayArgs']]]]):
        pulumi.set(self, "mesh_gateways", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a set of custom key-value pairs to add to the Consul KV store.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a mode for how the service directs inbound and outbound traffic.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="mutualTlsMode")
    def mutual_tls_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls whether mutual TLS is required for incoming connections to this service. This setting is only supported for services with transparent proxy enabled.
        """
        return pulumi.get(self, "mutual_tls_mode")

    @mutual_tls_mode.setter
    def mutual_tls_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mutual_tls_mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the service you are setting the defaults for.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Consul namespace that the configuration entry applies to.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the name of the Consul admin partition that the configuration entry applies to. Refer to Admin Partitions for additional information.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default protocol for the service.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="transparentProxies")
    def transparent_proxies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsTransparentProxyArgs']]]]:
        """
        Controls configurations specific to proxies in transparent mode. Refer to Transparent Proxy Mode for additional information.
        """
        return pulumi.get(self, "transparent_proxies")

    @transparent_proxies.setter
    def transparent_proxies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsTransparentProxyArgs']]]]):
        pulumi.set(self, "transparent_proxies", value)

    @_builtins.property
    @pulumi.getter(name="upstreamConfigs")
    def upstream_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsUpstreamConfigArgs']]]]:
        """
        Controls default upstream connection settings and custom overrides for individual upstream services.
        """
        return pulumi.get(self, "upstream_configs")

    @upstream_configs.setter
    def upstream_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceDefaultsUpstreamConfigArgs']]]]):
        pulumi.set(self, "upstream_configs", value)


@pulumi.type_token("consul:index/configEntryServiceDefaults:ConfigEntryServiceDefaults")
class ConfigEntryServiceDefaults(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 balance_inbound_connections: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsDestinationArgs', 'ConfigEntryServiceDefaultsDestinationArgsDict']]]]] = None,
                 envoy_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsEnvoyExtensionArgs', 'ConfigEntryServiceDefaultsEnvoyExtensionArgsDict']]]]] = None,
                 exposes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsExposeArgs', 'ConfigEntryServiceDefaultsExposeArgsDict']]]]] = None,
                 external_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 local_connect_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 local_request_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 max_inbound_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 mesh_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsMeshGatewayArgs', 'ConfigEntryServiceDefaultsMeshGatewayArgsDict']]]]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 mutual_tls_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 transparent_proxies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsTransparentProxyArgs', 'ConfigEntryServiceDefaultsTransparentProxyArgsDict']]]]] = None,
                 upstream_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsUpstreamConfigArgs', 'ConfigEntryServiceDefaultsUpstreamConfigArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] balance_inbound_connections: Specifies the strategy for allocating inbound connections to the service across Envoy proxy threads.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsDestinationArgs', 'ConfigEntryServiceDefaultsDestinationArgsDict']]]] destinations: Configures the destination for service traffic through terminating gateways.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsEnvoyExtensionArgs', 'ConfigEntryServiceDefaultsEnvoyExtensionArgsDict']]]] envoy_extensions: List of extensions to modify Envoy proxy configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsExposeArgs', 'ConfigEntryServiceDefaultsExposeArgsDict']]]] exposes: Specifies default configurations for exposing HTTP paths through Envoy.
        :param pulumi.Input[_builtins.str] external_sni: Specifies the TLS server name indication (SNI) when federating with an external system.
        :param pulumi.Input[_builtins.int] local_connect_timeout_ms: Specifies the number of milliseconds allowed for establishing connections to the local application instance before timing out.
        :param pulumi.Input[_builtins.int] local_request_timeout_ms: Specifies the timeout for HTTP requests to the local application instance.
        :param pulumi.Input[_builtins.int] max_inbound_connections: Specifies the maximum number of concurrent inbound connections to each service instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsMeshGatewayArgs', 'ConfigEntryServiceDefaultsMeshGatewayArgsDict']]]] mesh_gateways: Specifies the default mesh gateway mode field for the service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: Specifies a set of custom key-value pairs to add to the Consul KV store.
        :param pulumi.Input[_builtins.str] mode: Specifies a mode for how the service directs inbound and outbound traffic.
        :param pulumi.Input[_builtins.str] mutual_tls_mode: Controls whether mutual TLS is required for incoming connections to this service. This setting is only supported for services with transparent proxy enabled.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the service you are setting the defaults for.
        :param pulumi.Input[_builtins.str] namespace: Specifies the Consul namespace that the configuration entry applies to.
        :param pulumi.Input[_builtins.str] partition: Specifies the name of the name of the Consul admin partition that the configuration entry applies to. Refer to Admin Partitions for additional information.
        :param pulumi.Input[_builtins.str] protocol: Specifies the default protocol for the service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsTransparentProxyArgs', 'ConfigEntryServiceDefaultsTransparentProxyArgsDict']]]] transparent_proxies: Controls configurations specific to proxies in transparent mode. Refer to Transparent Proxy Mode for additional information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsUpstreamConfigArgs', 'ConfigEntryServiceDefaultsUpstreamConfigArgsDict']]]] upstream_configs: Controls default upstream connection settings and custom overrides for individual upstream services.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigEntryServiceDefaultsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param ConfigEntryServiceDefaultsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigEntryServiceDefaultsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 balance_inbound_connections: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsDestinationArgs', 'ConfigEntryServiceDefaultsDestinationArgsDict']]]]] = None,
                 envoy_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsEnvoyExtensionArgs', 'ConfigEntryServiceDefaultsEnvoyExtensionArgsDict']]]]] = None,
                 exposes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsExposeArgs', 'ConfigEntryServiceDefaultsExposeArgsDict']]]]] = None,
                 external_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 local_connect_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 local_request_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
                 max_inbound_connections: Optional[pulumi.Input[_builtins.int]] = None,
                 mesh_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsMeshGatewayArgs', 'ConfigEntryServiceDefaultsMeshGatewayArgsDict']]]]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 mutual_tls_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 transparent_proxies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsTransparentProxyArgs', 'ConfigEntryServiceDefaultsTransparentProxyArgsDict']]]]] = None,
                 upstream_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsUpstreamConfigArgs', 'ConfigEntryServiceDefaultsUpstreamConfigArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigEntryServiceDefaultsArgs.__new__(ConfigEntryServiceDefaultsArgs)

            __props__.__dict__["balance_inbound_connections"] = balance_inbound_connections
            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["envoy_extensions"] = envoy_extensions
            if exposes is None and not opts.urn:
                raise TypeError("Missing required property 'exposes'")
            __props__.__dict__["exposes"] = exposes
            __props__.__dict__["external_sni"] = external_sni
            __props__.__dict__["local_connect_timeout_ms"] = local_connect_timeout_ms
            __props__.__dict__["local_request_timeout_ms"] = local_request_timeout_ms
            __props__.__dict__["max_inbound_connections"] = max_inbound_connections
            __props__.__dict__["mesh_gateways"] = mesh_gateways
            __props__.__dict__["meta"] = meta
            __props__.__dict__["mode"] = mode
            __props__.__dict__["mutual_tls_mode"] = mutual_tls_mode
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["partition"] = partition
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["transparent_proxies"] = transparent_proxies
            __props__.__dict__["upstream_configs"] = upstream_configs
        super(ConfigEntryServiceDefaults, __self__).__init__(
            'consul:index/configEntryServiceDefaults:ConfigEntryServiceDefaults',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            balance_inbound_connections: Optional[pulumi.Input[_builtins.str]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsDestinationArgs', 'ConfigEntryServiceDefaultsDestinationArgsDict']]]]] = None,
            envoy_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsEnvoyExtensionArgs', 'ConfigEntryServiceDefaultsEnvoyExtensionArgsDict']]]]] = None,
            exposes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsExposeArgs', 'ConfigEntryServiceDefaultsExposeArgsDict']]]]] = None,
            external_sni: Optional[pulumi.Input[_builtins.str]] = None,
            local_connect_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
            local_request_timeout_ms: Optional[pulumi.Input[_builtins.int]] = None,
            max_inbound_connections: Optional[pulumi.Input[_builtins.int]] = None,
            mesh_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsMeshGatewayArgs', 'ConfigEntryServiceDefaultsMeshGatewayArgsDict']]]]] = None,
            meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            mutual_tls_mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            partition: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            transparent_proxies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsTransparentProxyArgs', 'ConfigEntryServiceDefaultsTransparentProxyArgsDict']]]]] = None,
            upstream_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsUpstreamConfigArgs', 'ConfigEntryServiceDefaultsUpstreamConfigArgsDict']]]]] = None) -> 'ConfigEntryServiceDefaults':
        """
        Get an existing ConfigEntryServiceDefaults resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] balance_inbound_connections: Specifies the strategy for allocating inbound connections to the service across Envoy proxy threads.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsDestinationArgs', 'ConfigEntryServiceDefaultsDestinationArgsDict']]]] destinations: Configures the destination for service traffic through terminating gateways.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsEnvoyExtensionArgs', 'ConfigEntryServiceDefaultsEnvoyExtensionArgsDict']]]] envoy_extensions: List of extensions to modify Envoy proxy configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsExposeArgs', 'ConfigEntryServiceDefaultsExposeArgsDict']]]] exposes: Specifies default configurations for exposing HTTP paths through Envoy.
        :param pulumi.Input[_builtins.str] external_sni: Specifies the TLS server name indication (SNI) when federating with an external system.
        :param pulumi.Input[_builtins.int] local_connect_timeout_ms: Specifies the number of milliseconds allowed for establishing connections to the local application instance before timing out.
        :param pulumi.Input[_builtins.int] local_request_timeout_ms: Specifies the timeout for HTTP requests to the local application instance.
        :param pulumi.Input[_builtins.int] max_inbound_connections: Specifies the maximum number of concurrent inbound connections to each service instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsMeshGatewayArgs', 'ConfigEntryServiceDefaultsMeshGatewayArgsDict']]]] mesh_gateways: Specifies the default mesh gateway mode field for the service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: Specifies a set of custom key-value pairs to add to the Consul KV store.
        :param pulumi.Input[_builtins.str] mode: Specifies a mode for how the service directs inbound and outbound traffic.
        :param pulumi.Input[_builtins.str] mutual_tls_mode: Controls whether mutual TLS is required for incoming connections to this service. This setting is only supported for services with transparent proxy enabled.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the service you are setting the defaults for.
        :param pulumi.Input[_builtins.str] namespace: Specifies the Consul namespace that the configuration entry applies to.
        :param pulumi.Input[_builtins.str] partition: Specifies the name of the name of the Consul admin partition that the configuration entry applies to. Refer to Admin Partitions for additional information.
        :param pulumi.Input[_builtins.str] protocol: Specifies the default protocol for the service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsTransparentProxyArgs', 'ConfigEntryServiceDefaultsTransparentProxyArgsDict']]]] transparent_proxies: Controls configurations specific to proxies in transparent mode. Refer to Transparent Proxy Mode for additional information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigEntryServiceDefaultsUpstreamConfigArgs', 'ConfigEntryServiceDefaultsUpstreamConfigArgsDict']]]] upstream_configs: Controls default upstream connection settings and custom overrides for individual upstream services.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigEntryServiceDefaultsState.__new__(_ConfigEntryServiceDefaultsState)

        __props__.__dict__["balance_inbound_connections"] = balance_inbound_connections
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["envoy_extensions"] = envoy_extensions
        __props__.__dict__["exposes"] = exposes
        __props__.__dict__["external_sni"] = external_sni
        __props__.__dict__["local_connect_timeout_ms"] = local_connect_timeout_ms
        __props__.__dict__["local_request_timeout_ms"] = local_request_timeout_ms
        __props__.__dict__["max_inbound_connections"] = max_inbound_connections
        __props__.__dict__["mesh_gateways"] = mesh_gateways
        __props__.__dict__["meta"] = meta
        __props__.__dict__["mode"] = mode
        __props__.__dict__["mutual_tls_mode"] = mutual_tls_mode
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["partition"] = partition
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["transparent_proxies"] = transparent_proxies
        __props__.__dict__["upstream_configs"] = upstream_configs
        return ConfigEntryServiceDefaults(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="balanceInboundConnections")
    def balance_inbound_connections(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the strategy for allocating inbound connections to the service across Envoy proxy threads.
        """
        return pulumi.get(self, "balance_inbound_connections")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigEntryServiceDefaultsDestination']]]:
        """
        Configures the destination for service traffic through terminating gateways.
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter(name="envoyExtensions")
    def envoy_extensions(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigEntryServiceDefaultsEnvoyExtension']]]:
        """
        List of extensions to modify Envoy proxy configuration.
        """
        return pulumi.get(self, "envoy_extensions")

    @_builtins.property
    @pulumi.getter
    def exposes(self) -> pulumi.Output[Sequence['outputs.ConfigEntryServiceDefaultsExpose']]:
        """
        Specifies default configurations for exposing HTTP paths through Envoy.
        """
        return pulumi.get(self, "exposes")

    @_builtins.property
    @pulumi.getter(name="externalSni")
    def external_sni(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the TLS server name indication (SNI) when federating with an external system.
        """
        return pulumi.get(self, "external_sni")

    @_builtins.property
    @pulumi.getter(name="localConnectTimeoutMs")
    def local_connect_timeout_ms(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the number of milliseconds allowed for establishing connections to the local application instance before timing out.
        """
        return pulumi.get(self, "local_connect_timeout_ms")

    @_builtins.property
    @pulumi.getter(name="localRequestTimeoutMs")
    def local_request_timeout_ms(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the timeout for HTTP requests to the local application instance.
        """
        return pulumi.get(self, "local_request_timeout_ms")

    @_builtins.property
    @pulumi.getter(name="maxInboundConnections")
    def max_inbound_connections(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the maximum number of concurrent inbound connections to each service instance.
        """
        return pulumi.get(self, "max_inbound_connections")

    @_builtins.property
    @pulumi.getter(name="meshGateways")
    def mesh_gateways(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigEntryServiceDefaultsMeshGateway']]]:
        """
        Specifies the default mesh gateway mode field for the service.
        """
        return pulumi.get(self, "mesh_gateways")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies a set of custom key-value pairs to add to the Consul KV store.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a mode for how the service directs inbound and outbound traffic.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="mutualTlsMode")
    def mutual_tls_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Controls whether mutual TLS is required for incoming connections to this service. This setting is only supported for services with transparent proxy enabled.
        """
        return pulumi.get(self, "mutual_tls_mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the service you are setting the defaults for.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Consul namespace that the configuration entry applies to.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the name of the Consul admin partition that the configuration entry applies to. Refer to Admin Partitions for additional information.
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the default protocol for the service.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="transparentProxies")
    def transparent_proxies(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigEntryServiceDefaultsTransparentProxy']]]:
        """
        Controls configurations specific to proxies in transparent mode. Refer to Transparent Proxy Mode for additional information.
        """
        return pulumi.get(self, "transparent_proxies")

    @_builtins.property
    @pulumi.getter(name="upstreamConfigs")
    def upstream_configs(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigEntryServiceDefaultsUpstreamConfig']]]:
        """
        Controls default upstream connection settings and custom overrides for individual upstream services.
        """
        return pulumi.get(self, "upstream_configs")

