# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PreparedQueryArgs', 'PreparedQuery']

@pulumi.input_type
class PreparedQueryArgs:
    def __init__(__self__, *,
                 service: pulumi.Input[_builtins.str],
                 connect: Optional[pulumi.Input[_builtins.bool]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 dns: Optional[pulumi.Input['PreparedQueryDnsArgs']] = None,
                 failover: Optional[pulumi.Input['PreparedQueryFailoverArgs']] = None,
                 ignore_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 near: Optional[pulumi.Input[_builtins.str]] = None,
                 node_meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 only_passing: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 session: Optional[pulumi.Input[_builtins.str]] = None,
                 stored_token: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template: Optional[pulumi.Input['PreparedQueryTemplateArgs']] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PreparedQuery resource.
        :param pulumi.Input[_builtins.str] service: The name of the service to query
        :param pulumi.Input[_builtins.bool] connect: When `true` the prepared query will return connect proxy services for a queried service.  Conditions such as `tags` in the prepared query will be matched against the proxy service. Defaults to false.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input['PreparedQueryDnsArgs'] dns: Settings for controlling the DNS response details.
        :param pulumi.Input['PreparedQueryFailoverArgs'] failover: Options for controlling behavior when no healthy nodes are available in the local DC.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_check_ids: Specifies a list of check IDs that should be ignored when filtering unhealthy instances. This is mostly useful in an emergency or as a temporary measure when a health check is found to be unreliable. Being able to ignore it in centrally-defined queries can be simpler than de-registering the check as an interim solution until the check can be fixed.
        :param pulumi.Input[_builtins.str] name: The name of the prepared query. Used to identify the prepared query during requests. Can be specified as an empty string to configure the query as a catch-all.
        :param pulumi.Input[_builtins.str] near: Allows specifying the name of a node to sort results near using Consul's distance sorting and network coordinates. The magic `_agent` value can be used to always sort nearest the node servicing the request.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_meta: Specifies a list of user-defined key/value pairs that will be used for filtering the query results to nodes with the given metadata values present.
        :param pulumi.Input[_builtins.bool] only_passing: When `true`, the prepared query will only return nodes with passing health checks in the result.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] service_meta: Specifies a list of user-defined key/value pairs that will be used for filtering the query results to services with the given metadata values present.
        :param pulumi.Input[_builtins.str] session: The name of the Consul session to tie this query's lifetime to.  This is an advanced parameter that should not be used without a complete understanding of Consul sessions and the implications of their use (it is recommended to leave this blank in nearly all cases).  If this parameter is omitted the query will not expire.
        :param pulumi.Input[_builtins.str] stored_token: The ACL token to store with the prepared query. This token will be used by default whenever the query is executed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The list of required and/or disallowed tags.  If a tag is in this list it must be present.  If the tag is preceded with a "!" then it is disallowed.
        :param pulumi.Input['PreparedQueryTemplateArgs'] template: Query templating options. This is used to make a single prepared query respond to many different requests
        :param pulumi.Input[_builtins.str] token: The ACL token to use when saving the prepared query. This overrides the token that the agent provides by default.
        """
        pulumi.set(__self__, "service", service)
        if connect is not None:
            pulumi.set(__self__, "connect", connect)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if failover is not None:
            pulumi.set(__self__, "failover", failover)
        if ignore_check_ids is not None:
            pulumi.set(__self__, "ignore_check_ids", ignore_check_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if near is not None:
            pulumi.set(__self__, "near", near)
        if node_meta is not None:
            pulumi.set(__self__, "node_meta", node_meta)
        if only_passing is not None:
            pulumi.set(__self__, "only_passing", only_passing)
        if service_meta is not None:
            pulumi.set(__self__, "service_meta", service_meta)
        if session is not None:
            pulumi.set(__self__, "session", session)
        if stored_token is not None:
            pulumi.set(__self__, "stored_token", stored_token)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if token is not None:
            warnings.warn("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""", DeprecationWarning)
            pulumi.log.warn("""token is deprecated: The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")
        if token is not None:
            pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the service to query
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def connect(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `true` the prepared query will return connect proxy services for a queried service.  Conditions such as `tags` in the prepared query will be matched against the proxy service. Defaults to false.
        """
        return pulumi.get(self, "connect")

    @connect.setter
    def connect(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "connect", value)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datacenter", value)

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input['PreparedQueryDnsArgs']]:
        """
        Settings for controlling the DNS response details.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input['PreparedQueryDnsArgs']]):
        pulumi.set(self, "dns", value)

    @_builtins.property
    @pulumi.getter
    def failover(self) -> Optional[pulumi.Input['PreparedQueryFailoverArgs']]:
        """
        Options for controlling behavior when no healthy nodes are available in the local DC.
        """
        return pulumi.get(self, "failover")

    @failover.setter
    def failover(self, value: Optional[pulumi.Input['PreparedQueryFailoverArgs']]):
        pulumi.set(self, "failover", value)

    @_builtins.property
    @pulumi.getter(name="ignoreCheckIds")
    def ignore_check_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of check IDs that should be ignored when filtering unhealthy instances. This is mostly useful in an emergency or as a temporary measure when a health check is found to be unreliable. Being able to ignore it in centrally-defined queries can be simpler than de-registering the check as an interim solution until the check can be fixed.
        """
        return pulumi.get(self, "ignore_check_ids")

    @ignore_check_ids.setter
    def ignore_check_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ignore_check_ids", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the prepared query. Used to identify the prepared query during requests. Can be specified as an empty string to configure the query as a catch-all.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def near(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allows specifying the name of a node to sort results near using Consul's distance sorting and network coordinates. The magic `_agent` value can be used to always sort nearest the node servicing the request.
        """
        return pulumi.get(self, "near")

    @near.setter
    def near(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "near", value)

    @_builtins.property
    @pulumi.getter(name="nodeMeta")
    def node_meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of user-defined key/value pairs that will be used for filtering the query results to nodes with the given metadata values present.
        """
        return pulumi.get(self, "node_meta")

    @node_meta.setter
    def node_meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_meta", value)

    @_builtins.property
    @pulumi.getter(name="onlyPassing")
    def only_passing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `true`, the prepared query will only return nodes with passing health checks in the result.
        """
        return pulumi.get(self, "only_passing")

    @only_passing.setter
    def only_passing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "only_passing", value)

    @_builtins.property
    @pulumi.getter(name="serviceMeta")
    def service_meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of user-defined key/value pairs that will be used for filtering the query results to services with the given metadata values present.
        """
        return pulumi.get(self, "service_meta")

    @service_meta.setter
    def service_meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service_meta", value)

    @_builtins.property
    @pulumi.getter
    def session(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Consul session to tie this query's lifetime to.  This is an advanced parameter that should not be used without a complete understanding of Consul sessions and the implications of their use (it is recommended to leave this blank in nearly all cases).  If this parameter is omitted the query will not expire.
        """
        return pulumi.get(self, "session")

    @session.setter
    def session(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session", value)

    @_builtins.property
    @pulumi.getter(name="storedToken")
    def stored_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL token to store with the prepared query. This token will be used by default whenever the query is executed.
        """
        return pulumi.get(self, "stored_token")

    @stored_token.setter
    def stored_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stored_token", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of required and/or disallowed tags.  If a tag is in this list it must be present.  If the tag is preceded with a "!" then it is disallowed.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['PreparedQueryTemplateArgs']]:
        """
        Query templating options. This is used to make a single prepared query respond to many different requests
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['PreparedQueryTemplateArgs']]):
        pulumi.set(self, "template", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL token to use when saving the prepared query. This overrides the token that the agent provides by default.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class _PreparedQueryState:
    def __init__(__self__, *,
                 connect: Optional[pulumi.Input[_builtins.bool]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 dns: Optional[pulumi.Input['PreparedQueryDnsArgs']] = None,
                 failover: Optional[pulumi.Input['PreparedQueryFailoverArgs']] = None,
                 ignore_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 near: Optional[pulumi.Input[_builtins.str]] = None,
                 node_meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 only_passing: Optional[pulumi.Input[_builtins.bool]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 service_meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 session: Optional[pulumi.Input[_builtins.str]] = None,
                 stored_token: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template: Optional[pulumi.Input['PreparedQueryTemplateArgs']] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PreparedQuery resources.
        :param pulumi.Input[_builtins.bool] connect: When `true` the prepared query will return connect proxy services for a queried service.  Conditions such as `tags` in the prepared query will be matched against the proxy service. Defaults to false.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input['PreparedQueryDnsArgs'] dns: Settings for controlling the DNS response details.
        :param pulumi.Input['PreparedQueryFailoverArgs'] failover: Options for controlling behavior when no healthy nodes are available in the local DC.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_check_ids: Specifies a list of check IDs that should be ignored when filtering unhealthy instances. This is mostly useful in an emergency or as a temporary measure when a health check is found to be unreliable. Being able to ignore it in centrally-defined queries can be simpler than de-registering the check as an interim solution until the check can be fixed.
        :param pulumi.Input[_builtins.str] name: The name of the prepared query. Used to identify the prepared query during requests. Can be specified as an empty string to configure the query as a catch-all.
        :param pulumi.Input[_builtins.str] near: Allows specifying the name of a node to sort results near using Consul's distance sorting and network coordinates. The magic `_agent` value can be used to always sort nearest the node servicing the request.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_meta: Specifies a list of user-defined key/value pairs that will be used for filtering the query results to nodes with the given metadata values present.
        :param pulumi.Input[_builtins.bool] only_passing: When `true`, the prepared query will only return nodes with passing health checks in the result.
        :param pulumi.Input[_builtins.str] service: The name of the service to query
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] service_meta: Specifies a list of user-defined key/value pairs that will be used for filtering the query results to services with the given metadata values present.
        :param pulumi.Input[_builtins.str] session: The name of the Consul session to tie this query's lifetime to.  This is an advanced parameter that should not be used without a complete understanding of Consul sessions and the implications of their use (it is recommended to leave this blank in nearly all cases).  If this parameter is omitted the query will not expire.
        :param pulumi.Input[_builtins.str] stored_token: The ACL token to store with the prepared query. This token will be used by default whenever the query is executed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The list of required and/or disallowed tags.  If a tag is in this list it must be present.  If the tag is preceded with a "!" then it is disallowed.
        :param pulumi.Input['PreparedQueryTemplateArgs'] template: Query templating options. This is used to make a single prepared query respond to many different requests
        :param pulumi.Input[_builtins.str] token: The ACL token to use when saving the prepared query. This overrides the token that the agent provides by default.
        """
        if connect is not None:
            pulumi.set(__self__, "connect", connect)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if failover is not None:
            pulumi.set(__self__, "failover", failover)
        if ignore_check_ids is not None:
            pulumi.set(__self__, "ignore_check_ids", ignore_check_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if near is not None:
            pulumi.set(__self__, "near", near)
        if node_meta is not None:
            pulumi.set(__self__, "node_meta", node_meta)
        if only_passing is not None:
            pulumi.set(__self__, "only_passing", only_passing)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_meta is not None:
            pulumi.set(__self__, "service_meta", service_meta)
        if session is not None:
            pulumi.set(__self__, "session", session)
        if stored_token is not None:
            pulumi.set(__self__, "stored_token", stored_token)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if token is not None:
            warnings.warn("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""", DeprecationWarning)
            pulumi.log.warn("""token is deprecated: The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")
        if token is not None:
            pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter
    def connect(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `true` the prepared query will return connect proxy services for a queried service.  Conditions such as `tags` in the prepared query will be matched against the proxy service. Defaults to false.
        """
        return pulumi.get(self, "connect")

    @connect.setter
    def connect(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "connect", value)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datacenter", value)

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input['PreparedQueryDnsArgs']]:
        """
        Settings for controlling the DNS response details.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input['PreparedQueryDnsArgs']]):
        pulumi.set(self, "dns", value)

    @_builtins.property
    @pulumi.getter
    def failover(self) -> Optional[pulumi.Input['PreparedQueryFailoverArgs']]:
        """
        Options for controlling behavior when no healthy nodes are available in the local DC.
        """
        return pulumi.get(self, "failover")

    @failover.setter
    def failover(self, value: Optional[pulumi.Input['PreparedQueryFailoverArgs']]):
        pulumi.set(self, "failover", value)

    @_builtins.property
    @pulumi.getter(name="ignoreCheckIds")
    def ignore_check_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of check IDs that should be ignored when filtering unhealthy instances. This is mostly useful in an emergency or as a temporary measure when a health check is found to be unreliable. Being able to ignore it in centrally-defined queries can be simpler than de-registering the check as an interim solution until the check can be fixed.
        """
        return pulumi.get(self, "ignore_check_ids")

    @ignore_check_ids.setter
    def ignore_check_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ignore_check_ids", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the prepared query. Used to identify the prepared query during requests. Can be specified as an empty string to configure the query as a catch-all.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def near(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allows specifying the name of a node to sort results near using Consul's distance sorting and network coordinates. The magic `_agent` value can be used to always sort nearest the node servicing the request.
        """
        return pulumi.get(self, "near")

    @near.setter
    def near(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "near", value)

    @_builtins.property
    @pulumi.getter(name="nodeMeta")
    def node_meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of user-defined key/value pairs that will be used for filtering the query results to nodes with the given metadata values present.
        """
        return pulumi.get(self, "node_meta")

    @node_meta.setter
    def node_meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_meta", value)

    @_builtins.property
    @pulumi.getter(name="onlyPassing")
    def only_passing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `true`, the prepared query will only return nodes with passing health checks in the result.
        """
        return pulumi.get(self, "only_passing")

    @only_passing.setter
    def only_passing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "only_passing", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service to query
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter(name="serviceMeta")
    def service_meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of user-defined key/value pairs that will be used for filtering the query results to services with the given metadata values present.
        """
        return pulumi.get(self, "service_meta")

    @service_meta.setter
    def service_meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service_meta", value)

    @_builtins.property
    @pulumi.getter
    def session(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Consul session to tie this query's lifetime to.  This is an advanced parameter that should not be used without a complete understanding of Consul sessions and the implications of their use (it is recommended to leave this blank in nearly all cases).  If this parameter is omitted the query will not expire.
        """
        return pulumi.get(self, "session")

    @session.setter
    def session(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session", value)

    @_builtins.property
    @pulumi.getter(name="storedToken")
    def stored_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL token to store with the prepared query. This token will be used by default whenever the query is executed.
        """
        return pulumi.get(self, "stored_token")

    @stored_token.setter
    def stored_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stored_token", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of required and/or disallowed tags.  If a tag is in this list it must be present.  If the tag is preceded with a "!" then it is disallowed.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['PreparedQueryTemplateArgs']]:
        """
        Query templating options. This is used to make a single prepared query respond to many different requests
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['PreparedQueryTemplateArgs']]):
        pulumi.set(self, "template", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL token to use when saving the prepared query. This overrides the token that the agent provides by default.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)


@pulumi.type_token("consul:index/preparedQuery:PreparedQuery")
class PreparedQuery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connect: Optional[pulumi.Input[_builtins.bool]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 dns: Optional[pulumi.Input[Union['PreparedQueryDnsArgs', 'PreparedQueryDnsArgsDict']]] = None,
                 failover: Optional[pulumi.Input[Union['PreparedQueryFailoverArgs', 'PreparedQueryFailoverArgsDict']]] = None,
                 ignore_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 near: Optional[pulumi.Input[_builtins.str]] = None,
                 node_meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 only_passing: Optional[pulumi.Input[_builtins.bool]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 service_meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 session: Optional[pulumi.Input[_builtins.str]] = None,
                 stored_token: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template: Optional[pulumi.Input[Union['PreparedQueryTemplateArgs', 'PreparedQueryTemplateArgsDict']]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        # Creates a prepared query myquery.query.consul that finds the nearest
        # healthy myapp.service.consul instance that has the active tag and not
        # the standby tag.
        myapp_query = consul.PreparedQuery("myapp-query",
            name="myquery",
            datacenter="us-central1",
            token="abcd",
            stored_token="wxyz",
            only_passing=True,
            near="_agent",
            service="myapp",
            tags=[
                "active",
                "!standby",
            ],
            failover={
                "nearest_n": 3,
                "datacenters": [
                    "us-west1",
                    "us-east-2",
                    "asia-east1",
                ],
            },
            dns={
                "ttl": "30s",
            })
        # Creates a Prepared Query Template that matches *-near-self.query.consul
        # and finds the nearest service that matches the glob character (e.g.
        # foo-near-self.query.consul will find the nearest healthy foo.service.consul).
        service_near_self = consul.PreparedQuery("service-near-self",
            datacenter="nyc1",
            token="abcd",
            stored_token="wxyz",
            name="",
            only_passing=True,
            connect=True,
            near="_agent",
            template={
                "type": "name_prefix_match",
                "regexp": "^(.*)-near-self$",
            },
            service="${match(1)}",
            failover={
                "nearest_n": 3,
                "datacenters": [
                    "dc2",
                    "dc3",
                    "dc4",
                ],
            },
            dns={
                "ttl": "5m",
            })
        ```

        ## Import

        ```sh
        $ pulumi import consul:index/preparedQuery:PreparedQuery my_service 71ecfb82-717a-4258-b4b6-2fb75144d856
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] connect: When `true` the prepared query will return connect proxy services for a queried service.  Conditions such as `tags` in the prepared query will be matched against the proxy service. Defaults to false.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[Union['PreparedQueryDnsArgs', 'PreparedQueryDnsArgsDict']] dns: Settings for controlling the DNS response details.
        :param pulumi.Input[Union['PreparedQueryFailoverArgs', 'PreparedQueryFailoverArgsDict']] failover: Options for controlling behavior when no healthy nodes are available in the local DC.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_check_ids: Specifies a list of check IDs that should be ignored when filtering unhealthy instances. This is mostly useful in an emergency or as a temporary measure when a health check is found to be unreliable. Being able to ignore it in centrally-defined queries can be simpler than de-registering the check as an interim solution until the check can be fixed.
        :param pulumi.Input[_builtins.str] name: The name of the prepared query. Used to identify the prepared query during requests. Can be specified as an empty string to configure the query as a catch-all.
        :param pulumi.Input[_builtins.str] near: Allows specifying the name of a node to sort results near using Consul's distance sorting and network coordinates. The magic `_agent` value can be used to always sort nearest the node servicing the request.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_meta: Specifies a list of user-defined key/value pairs that will be used for filtering the query results to nodes with the given metadata values present.
        :param pulumi.Input[_builtins.bool] only_passing: When `true`, the prepared query will only return nodes with passing health checks in the result.
        :param pulumi.Input[_builtins.str] service: The name of the service to query
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] service_meta: Specifies a list of user-defined key/value pairs that will be used for filtering the query results to services with the given metadata values present.
        :param pulumi.Input[_builtins.str] session: The name of the Consul session to tie this query's lifetime to.  This is an advanced parameter that should not be used without a complete understanding of Consul sessions and the implications of their use (it is recommended to leave this blank in nearly all cases).  If this parameter is omitted the query will not expire.
        :param pulumi.Input[_builtins.str] stored_token: The ACL token to store with the prepared query. This token will be used by default whenever the query is executed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The list of required and/or disallowed tags.  If a tag is in this list it must be present.  If the tag is preceded with a "!" then it is disallowed.
        :param pulumi.Input[Union['PreparedQueryTemplateArgs', 'PreparedQueryTemplateArgsDict']] template: Query templating options. This is used to make a single prepared query respond to many different requests
        :param pulumi.Input[_builtins.str] token: The ACL token to use when saving the prepared query. This overrides the token that the agent provides by default.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PreparedQueryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        # Creates a prepared query myquery.query.consul that finds the nearest
        # healthy myapp.service.consul instance that has the active tag and not
        # the standby tag.
        myapp_query = consul.PreparedQuery("myapp-query",
            name="myquery",
            datacenter="us-central1",
            token="abcd",
            stored_token="wxyz",
            only_passing=True,
            near="_agent",
            service="myapp",
            tags=[
                "active",
                "!standby",
            ],
            failover={
                "nearest_n": 3,
                "datacenters": [
                    "us-west1",
                    "us-east-2",
                    "asia-east1",
                ],
            },
            dns={
                "ttl": "30s",
            })
        # Creates a Prepared Query Template that matches *-near-self.query.consul
        # and finds the nearest service that matches the glob character (e.g.
        # foo-near-self.query.consul will find the nearest healthy foo.service.consul).
        service_near_self = consul.PreparedQuery("service-near-self",
            datacenter="nyc1",
            token="abcd",
            stored_token="wxyz",
            name="",
            only_passing=True,
            connect=True,
            near="_agent",
            template={
                "type": "name_prefix_match",
                "regexp": "^(.*)-near-self$",
            },
            service="${match(1)}",
            failover={
                "nearest_n": 3,
                "datacenters": [
                    "dc2",
                    "dc3",
                    "dc4",
                ],
            },
            dns={
                "ttl": "5m",
            })
        ```

        ## Import

        ```sh
        $ pulumi import consul:index/preparedQuery:PreparedQuery my_service 71ecfb82-717a-4258-b4b6-2fb75144d856
        ```

        :param str resource_name: The name of the resource.
        :param PreparedQueryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PreparedQueryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connect: Optional[pulumi.Input[_builtins.bool]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 dns: Optional[pulumi.Input[Union['PreparedQueryDnsArgs', 'PreparedQueryDnsArgsDict']]] = None,
                 failover: Optional[pulumi.Input[Union['PreparedQueryFailoverArgs', 'PreparedQueryFailoverArgsDict']]] = None,
                 ignore_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 near: Optional[pulumi.Input[_builtins.str]] = None,
                 node_meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 only_passing: Optional[pulumi.Input[_builtins.bool]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 service_meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 session: Optional[pulumi.Input[_builtins.str]] = None,
                 stored_token: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template: Optional[pulumi.Input[Union['PreparedQueryTemplateArgs', 'PreparedQueryTemplateArgsDict']]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PreparedQueryArgs.__new__(PreparedQueryArgs)

            __props__.__dict__["connect"] = connect
            __props__.__dict__["datacenter"] = datacenter
            __props__.__dict__["dns"] = dns
            __props__.__dict__["failover"] = failover
            __props__.__dict__["ignore_check_ids"] = ignore_check_ids
            __props__.__dict__["name"] = name
            __props__.__dict__["near"] = near
            __props__.__dict__["node_meta"] = node_meta
            __props__.__dict__["only_passing"] = only_passing
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["service_meta"] = service_meta
            __props__.__dict__["session"] = session
            __props__.__dict__["stored_token"] = stored_token
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template"] = template
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(PreparedQuery, __self__).__init__(
            'consul:index/preparedQuery:PreparedQuery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connect: Optional[pulumi.Input[_builtins.bool]] = None,
            datacenter: Optional[pulumi.Input[_builtins.str]] = None,
            dns: Optional[pulumi.Input[Union['PreparedQueryDnsArgs', 'PreparedQueryDnsArgsDict']]] = None,
            failover: Optional[pulumi.Input[Union['PreparedQueryFailoverArgs', 'PreparedQueryFailoverArgsDict']]] = None,
            ignore_check_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            near: Optional[pulumi.Input[_builtins.str]] = None,
            node_meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            only_passing: Optional[pulumi.Input[_builtins.bool]] = None,
            service: Optional[pulumi.Input[_builtins.str]] = None,
            service_meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            session: Optional[pulumi.Input[_builtins.str]] = None,
            stored_token: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            template: Optional[pulumi.Input[Union['PreparedQueryTemplateArgs', 'PreparedQueryTemplateArgsDict']]] = None,
            token: Optional[pulumi.Input[_builtins.str]] = None) -> 'PreparedQuery':
        """
        Get an existing PreparedQuery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] connect: When `true` the prepared query will return connect proxy services for a queried service.  Conditions such as `tags` in the prepared query will be matched against the proxy service. Defaults to false.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[Union['PreparedQueryDnsArgs', 'PreparedQueryDnsArgsDict']] dns: Settings for controlling the DNS response details.
        :param pulumi.Input[Union['PreparedQueryFailoverArgs', 'PreparedQueryFailoverArgsDict']] failover: Options for controlling behavior when no healthy nodes are available in the local DC.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ignore_check_ids: Specifies a list of check IDs that should be ignored when filtering unhealthy instances. This is mostly useful in an emergency or as a temporary measure when a health check is found to be unreliable. Being able to ignore it in centrally-defined queries can be simpler than de-registering the check as an interim solution until the check can be fixed.
        :param pulumi.Input[_builtins.str] name: The name of the prepared query. Used to identify the prepared query during requests. Can be specified as an empty string to configure the query as a catch-all.
        :param pulumi.Input[_builtins.str] near: Allows specifying the name of a node to sort results near using Consul's distance sorting and network coordinates. The magic `_agent` value can be used to always sort nearest the node servicing the request.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_meta: Specifies a list of user-defined key/value pairs that will be used for filtering the query results to nodes with the given metadata values present.
        :param pulumi.Input[_builtins.bool] only_passing: When `true`, the prepared query will only return nodes with passing health checks in the result.
        :param pulumi.Input[_builtins.str] service: The name of the service to query
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] service_meta: Specifies a list of user-defined key/value pairs that will be used for filtering the query results to services with the given metadata values present.
        :param pulumi.Input[_builtins.str] session: The name of the Consul session to tie this query's lifetime to.  This is an advanced parameter that should not be used without a complete understanding of Consul sessions and the implications of their use (it is recommended to leave this blank in nearly all cases).  If this parameter is omitted the query will not expire.
        :param pulumi.Input[_builtins.str] stored_token: The ACL token to store with the prepared query. This token will be used by default whenever the query is executed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The list of required and/or disallowed tags.  If a tag is in this list it must be present.  If the tag is preceded with a "!" then it is disallowed.
        :param pulumi.Input[Union['PreparedQueryTemplateArgs', 'PreparedQueryTemplateArgsDict']] template: Query templating options. This is used to make a single prepared query respond to many different requests
        :param pulumi.Input[_builtins.str] token: The ACL token to use when saving the prepared query. This overrides the token that the agent provides by default.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PreparedQueryState.__new__(_PreparedQueryState)

        __props__.__dict__["connect"] = connect
        __props__.__dict__["datacenter"] = datacenter
        __props__.__dict__["dns"] = dns
        __props__.__dict__["failover"] = failover
        __props__.__dict__["ignore_check_ids"] = ignore_check_ids
        __props__.__dict__["name"] = name
        __props__.__dict__["near"] = near
        __props__.__dict__["node_meta"] = node_meta
        __props__.__dict__["only_passing"] = only_passing
        __props__.__dict__["service"] = service
        __props__.__dict__["service_meta"] = service_meta
        __props__.__dict__["session"] = session
        __props__.__dict__["stored_token"] = stored_token
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template"] = template
        __props__.__dict__["token"] = token
        return PreparedQuery(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def connect(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When `true` the prepared query will return connect proxy services for a queried service.  Conditions such as `tags` in the prepared query will be matched against the proxy service. Defaults to false.
        """
        return pulumi.get(self, "connect")

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The datacenter to use. This overrides the agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @_builtins.property
    @pulumi.getter
    def dns(self) -> pulumi.Output[Optional['outputs.PreparedQueryDns']]:
        """
        Settings for controlling the DNS response details.
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter
    def failover(self) -> pulumi.Output[Optional['outputs.PreparedQueryFailover']]:
        """
        Options for controlling behavior when no healthy nodes are available in the local DC.
        """
        return pulumi.get(self, "failover")

    @_builtins.property
    @pulumi.getter(name="ignoreCheckIds")
    def ignore_check_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of check IDs that should be ignored when filtering unhealthy instances. This is mostly useful in an emergency or as a temporary measure when a health check is found to be unreliable. Being able to ignore it in centrally-defined queries can be simpler than de-registering the check as an interim solution until the check can be fixed.
        """
        return pulumi.get(self, "ignore_check_ids")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the prepared query. Used to identify the prepared query during requests. Can be specified as an empty string to configure the query as a catch-all.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def near(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Allows specifying the name of a node to sort results near using Consul's distance sorting and network coordinates. The magic `_agent` value can be used to always sort nearest the node servicing the request.
        """
        return pulumi.get(self, "near")

    @_builtins.property
    @pulumi.getter(name="nodeMeta")
    def node_meta(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies a list of user-defined key/value pairs that will be used for filtering the query results to nodes with the given metadata values present.
        """
        return pulumi.get(self, "node_meta")

    @_builtins.property
    @pulumi.getter(name="onlyPassing")
    def only_passing(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When `true`, the prepared query will only return nodes with passing health checks in the result.
        """
        return pulumi.get(self, "only_passing")

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service to query
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter(name="serviceMeta")
    def service_meta(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies a list of user-defined key/value pairs that will be used for filtering the query results to services with the given metadata values present.
        """
        return pulumi.get(self, "service_meta")

    @_builtins.property
    @pulumi.getter
    def session(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Consul session to tie this query's lifetime to.  This is an advanced parameter that should not be used without a complete understanding of Consul sessions and the implications of their use (it is recommended to leave this blank in nearly all cases).  If this parameter is omitted the query will not expire.
        """
        return pulumi.get(self, "session")

    @_builtins.property
    @pulumi.getter(name="storedToken")
    def stored_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ACL token to store with the prepared query. This token will be used by default whenever the query is executed.
        """
        return pulumi.get(self, "stored_token")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of required and/or disallowed tags.  If a tag is in this list it must be present.  If the tag is preceded with a "!" then it is disallowed.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional['outputs.PreparedQueryTemplate']]:
        """
        Query templating options. This is used to make a single prepared query respond to many different requests
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")
    def token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ACL token to use when saving the prepared query. This overrides the token that the agent provides by default.
        """
        return pulumi.get(self, "token")

