from typing import TYPE_CHECKING

if TYPE_CHECKING:
    # filter
    from .filter.code_autogen_filter import CodeAutoGeneratedFilter
    from .filter.code_doc_quality_filter import CodeDocumentQualityFilter
    from .filter.code_encoded_data_filter import CodeEncodedDataFilter
    from .filter.code_file_type_content_filter import CodeFileTypeContentFilter
    from .filter.code_length_filter import CodeLengthSampleFilter
    from .filter.code_quality_score_filter import CodeQualityScoreFilter
    from .filter.code_score_filter import CodeGenericScoreFilter
    from .filter.code_text_composition_filter import CodeTextCompositionFilter
    
    # generate
    from .generate.code_code_to_instruction_generator import CodeCodeToInstructionGenerator
    from .generate.code_instruction_to_code_generator import CodeInstructionToCodeGenerator
    
    # eval
    from .eval.code_auto_generated_sample_evaluator import CodeAutoGeneratedSampleEvaluator
    from .eval.code_document_quality_sample_evaluator import CodeDocumentQualitySampleEvaluator
    from .eval.code_encoded_data_sample_evaluator import CodeEncodedDataSampleEvaluator
    from .eval.code_length_sample_evaluator import CodeLengthSampleEvaluator
    from .eval.code_quality_sample_evaluator import CodeQualitySampleEvaluator
    from .eval.code_sandbox_sample_evaluator import CodeSandboxSampleEvaluator
    from .eval.code_text_composition_sample_evaluator import CodeTextCompositionSampleEvaluator
    from .eval.python_executor import (
        ImageRuntime,
        DateRuntime,
        CustomDict,
        ColorObjectRuntime,
        PythonExecutor
    )

else:
    import sys
    from dataflow.utils.registry import LazyLoader, generate_import_structure_from_type_checking

    cur_path = "dataflow/operators/code/"

    _import_structure = generate_import_structure_from_type_checking(__file__, cur_path)
    sys.modules[__name__] = LazyLoader(__name__, "dataflow/operators/code/", _import_structure)
