# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AddressMapArgs', 'AddressMap']

@pulumi.input_type
class AddressMapArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 default_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 memberships: Optional[pulumi.Input[Sequence[pulumi.Input['AddressMapMembershipArgs']]]] = None):
        """
        The set of arguments for constructing a AddressMap resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier of a Cloudflare account.
        :param pulumi.Input[_builtins.str] default_sni: If you have legacy TLS clients which do not send the TLS server name indicator, then you can specify one default SNI on the map. If Cloudflare receives a TLS handshake from a client without an SNI, it will respond with the default SNI on those IPs. The default SNI can be any valid zone or subdomain owned by the account.
        :param pulumi.Input[_builtins.str] description: An optional description field which may be used to describe the types of IPs or zones on the map.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Address Map is enabled or not. Cloudflare's DNS will not respond with IP addresses on an Address Map until the map is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['AddressMapMembershipArgs']]] memberships: Zones and Accounts which will be assigned IPs on this Address Map. A zone membership will take priority over an account membership.
        """
        pulumi.set(__self__, "account_id", account_id)
        if default_sni is not None:
            pulumi.set(__self__, "default_sni", default_sni)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if memberships is not None:
            pulumi.set(__self__, "memberships", memberships)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of a Cloudflare account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultSni")
    def default_sni(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you have legacy TLS clients which do not send the TLS server name indicator, then you can specify one default SNI on the map. If Cloudflare receives a TLS handshake from a client without an SNI, it will respond with the default SNI on those IPs. The default SNI can be any valid zone or subdomain owned by the account.
        """
        return pulumi.get(self, "default_sni")

    @default_sni.setter
    def default_sni(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_sni", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description field which may be used to describe the types of IPs or zones on the map.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Address Map is enabled or not. Cloudflare's DNS will not respond with IP addresses on an Address Map until the map is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ips", value)

    @_builtins.property
    @pulumi.getter
    def memberships(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AddressMapMembershipArgs']]]]:
        """
        Zones and Accounts which will be assigned IPs on this Address Map. A zone membership will take priority over an account membership.
        """
        return pulumi.get(self, "memberships")

    @memberships.setter
    def memberships(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AddressMapMembershipArgs']]]]):
        pulumi.set(self, "memberships", value)


@pulumi.input_type
class _AddressMapState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 can_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 can_modify_ips: Optional[pulumi.Input[_builtins.bool]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 default_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 memberships: Optional[pulumi.Input[Sequence[pulumi.Input['AddressMapMembershipArgs']]]] = None,
                 modified_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AddressMap resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier of a Cloudflare account.
        :param pulumi.Input[_builtins.bool] can_delete: If set to false, then the Address Map cannot be deleted via API. This is true for Cloudflare-managed maps.
        :param pulumi.Input[_builtins.bool] can_modify_ips: If set to false, then the IPs on the Address Map cannot be modified via the API. This is true for Cloudflare-managed maps.
        :param pulumi.Input[_builtins.str] default_sni: If you have legacy TLS clients which do not send the TLS server name indicator, then you can specify one default SNI on the map. If Cloudflare receives a TLS handshake from a client without an SNI, it will respond with the default SNI on those IPs. The default SNI can be any valid zone or subdomain owned by the account.
        :param pulumi.Input[_builtins.str] description: An optional description field which may be used to describe the types of IPs or zones on the map.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Address Map is enabled or not. Cloudflare's DNS will not respond with IP addresses on an Address Map until the map is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['AddressMapMembershipArgs']]] memberships: Zones and Accounts which will be assigned IPs on this Address Map. A zone membership will take priority over an account membership.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if can_delete is not None:
            pulumi.set(__self__, "can_delete", can_delete)
        if can_modify_ips is not None:
            pulumi.set(__self__, "can_modify_ips", can_modify_ips)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if default_sni is not None:
            pulumi.set(__self__, "default_sni", default_sni)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if memberships is not None:
            pulumi.set(__self__, "memberships", memberships)
        if modified_at is not None:
            pulumi.set(__self__, "modified_at", modified_at)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of a Cloudflare account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="canDelete")
    def can_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to false, then the Address Map cannot be deleted via API. This is true for Cloudflare-managed maps.
        """
        return pulumi.get(self, "can_delete")

    @can_delete.setter
    def can_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "can_delete", value)

    @_builtins.property
    @pulumi.getter(name="canModifyIps")
    def can_modify_ips(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to false, then the IPs on the Address Map cannot be modified via the API. This is true for Cloudflare-managed maps.
        """
        return pulumi.get(self, "can_modify_ips")

    @can_modify_ips.setter
    def can_modify_ips(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "can_modify_ips", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="defaultSni")
    def default_sni(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you have legacy TLS clients which do not send the TLS server name indicator, then you can specify one default SNI on the map. If Cloudflare receives a TLS handshake from a client without an SNI, it will respond with the default SNI on those IPs. The default SNI can be any valid zone or subdomain owned by the account.
        """
        return pulumi.get(self, "default_sni")

    @default_sni.setter
    def default_sni(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_sni", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description field which may be used to describe the types of IPs or zones on the map.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Address Map is enabled or not. Cloudflare's DNS will not respond with IP addresses on an Address Map until the map is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ips", value)

    @_builtins.property
    @pulumi.getter
    def memberships(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AddressMapMembershipArgs']]]]:
        """
        Zones and Accounts which will be assigned IPs on this Address Map. A zone membership will take priority over an account membership.
        """
        return pulumi.get(self, "memberships")

    @memberships.setter
    def memberships(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AddressMapMembershipArgs']]]]):
        pulumi.set(self, "memberships", value)

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "modified_at")

    @modified_at.setter
    def modified_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_at", value)


@pulumi.type_token("cloudflare:index/addressMap:AddressMap")
class AddressMap(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 memberships: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddressMapMembershipArgs', 'AddressMapMembershipArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_address_map = cloudflare.AddressMap("example_address_map",
            account_id="258def64c72dae45f3e4c8516e2111f2",
            description="My Ecommerce zones",
            enabled=True,
            ips=["192.0.2.1"],
            memberships=[{
                "identifier": "023e105f4ecef8ad9ca31a8372d0c353",
                "kind": "zone",
            }])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/addressMap:AddressMap example '<account_id>/<address_map_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier of a Cloudflare account.
        :param pulumi.Input[_builtins.str] default_sni: If you have legacy TLS clients which do not send the TLS server name indicator, then you can specify one default SNI on the map. If Cloudflare receives a TLS handshake from a client without an SNI, it will respond with the default SNI on those IPs. The default SNI can be any valid zone or subdomain owned by the account.
        :param pulumi.Input[_builtins.str] description: An optional description field which may be used to describe the types of IPs or zones on the map.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Address Map is enabled or not. Cloudflare's DNS will not respond with IP addresses on an Address Map until the map is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AddressMapMembershipArgs', 'AddressMapMembershipArgsDict']]]] memberships: Zones and Accounts which will be assigned IPs on this Address Map. A zone membership will take priority over an account membership.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddressMapArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_address_map = cloudflare.AddressMap("example_address_map",
            account_id="258def64c72dae45f3e4c8516e2111f2",
            description="My Ecommerce zones",
            enabled=True,
            ips=["192.0.2.1"],
            memberships=[{
                "identifier": "023e105f4ecef8ad9ca31a8372d0c353",
                "kind": "zone",
            }])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/addressMap:AddressMap example '<account_id>/<address_map_id>'
        ```

        :param str resource_name: The name of the resource.
        :param AddressMapArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddressMapArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_sni: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 memberships: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddressMapMembershipArgs', 'AddressMapMembershipArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddressMapArgs.__new__(AddressMapArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["default_sni"] = default_sni
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ips"] = ips
            __props__.__dict__["memberships"] = memberships
            __props__.__dict__["can_delete"] = None
            __props__.__dict__["can_modify_ips"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["modified_at"] = None
        super(AddressMap, __self__).__init__(
            'cloudflare:index/addressMap:AddressMap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            can_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            can_modify_ips: Optional[pulumi.Input[_builtins.bool]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            default_sni: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            memberships: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddressMapMembershipArgs', 'AddressMapMembershipArgsDict']]]]] = None,
            modified_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'AddressMap':
        """
        Get an existing AddressMap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier of a Cloudflare account.
        :param pulumi.Input[_builtins.bool] can_delete: If set to false, then the Address Map cannot be deleted via API. This is true for Cloudflare-managed maps.
        :param pulumi.Input[_builtins.bool] can_modify_ips: If set to false, then the IPs on the Address Map cannot be modified via the API. This is true for Cloudflare-managed maps.
        :param pulumi.Input[_builtins.str] default_sni: If you have legacy TLS clients which do not send the TLS server name indicator, then you can specify one default SNI on the map. If Cloudflare receives a TLS handshake from a client without an SNI, it will respond with the default SNI on those IPs. The default SNI can be any valid zone or subdomain owned by the account.
        :param pulumi.Input[_builtins.str] description: An optional description field which may be used to describe the types of IPs or zones on the map.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Address Map is enabled or not. Cloudflare's DNS will not respond with IP addresses on an Address Map until the map is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AddressMapMembershipArgs', 'AddressMapMembershipArgsDict']]]] memberships: Zones and Accounts which will be assigned IPs on this Address Map. A zone membership will take priority over an account membership.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddressMapState.__new__(_AddressMapState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["can_delete"] = can_delete
        __props__.__dict__["can_modify_ips"] = can_modify_ips
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["default_sni"] = default_sni
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["ips"] = ips
        __props__.__dict__["memberships"] = memberships
        __props__.__dict__["modified_at"] = modified_at
        return AddressMap(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of a Cloudflare account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="canDelete")
    def can_delete(self) -> pulumi.Output[_builtins.bool]:
        """
        If set to false, then the Address Map cannot be deleted via API. This is true for Cloudflare-managed maps.
        """
        return pulumi.get(self, "can_delete")

    @_builtins.property
    @pulumi.getter(name="canModifyIps")
    def can_modify_ips(self) -> pulumi.Output[_builtins.bool]:
        """
        If set to false, then the IPs on the Address Map cannot be modified via the API. This is true for Cloudflare-managed maps.
        """
        return pulumi.get(self, "can_modify_ips")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="defaultSni")
    def default_sni(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If you have legacy TLS clients which do not send the TLS server name indicator, then you can specify one default SNI on the map. If Cloudflare receives a TLS handshake from a client without an SNI, it will respond with the default SNI on those IPs. The default SNI can be any valid zone or subdomain owned by the account.
        """
        return pulumi.get(self, "default_sni")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description field which may be used to describe the types of IPs or zones on the map.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the Address Map is enabled or not. Cloudflare's DNS will not respond with IP addresses on an Address Map until the map is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter
    def memberships(self) -> pulumi.Output[Optional[Sequence['outputs.AddressMapMembership']]]:
        """
        Zones and Accounts which will be assigned IPs on this Address Map. A zone membership will take priority over an account membership.
        """
        return pulumi.get(self, "memberships")

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "modified_at")

