# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiShieldArgs', 'ApiShield']

@pulumi.input_type
class ApiShieldArgs:
    def __init__(__self__, *,
                 auth_id_characteristics: pulumi.Input[Sequence[pulumi.Input['ApiShieldAuthIdCharacteristicArgs']]],
                 zone_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ApiShield resource.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        pulumi.set(__self__, "auth_id_characteristics", auth_id_characteristics)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="authIdCharacteristics")
    def auth_id_characteristics(self) -> pulumi.Input[Sequence[pulumi.Input['ApiShieldAuthIdCharacteristicArgs']]]:
        return pulumi.get(self, "auth_id_characteristics")

    @auth_id_characteristics.setter
    def auth_id_characteristics(self, value: pulumi.Input[Sequence[pulumi.Input['ApiShieldAuthIdCharacteristicArgs']]]):
        pulumi.set(self, "auth_id_characteristics", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ApiShieldState:
    def __init__(__self__, *,
                 auth_id_characteristics: Optional[pulumi.Input[Sequence[pulumi.Input['ApiShieldAuthIdCharacteristicArgs']]]] = None,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input['ApiShieldErrorArgs']]]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input['ApiShieldMessageArgs']]]] = None,
                 success: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiShield resources.
        :param pulumi.Input[_builtins.bool] success: Whether the API call was successful.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if auth_id_characteristics is not None:
            pulumi.set(__self__, "auth_id_characteristics", auth_id_characteristics)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if messages is not None:
            pulumi.set(__self__, "messages", messages)
        if success is not None:
            pulumi.set(__self__, "success", success)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="authIdCharacteristics")
    def auth_id_characteristics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiShieldAuthIdCharacteristicArgs']]]]:
        return pulumi.get(self, "auth_id_characteristics")

    @auth_id_characteristics.setter
    def auth_id_characteristics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiShieldAuthIdCharacteristicArgs']]]]):
        pulumi.set(self, "auth_id_characteristics", value)

    @_builtins.property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiShieldErrorArgs']]]]:
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiShieldErrorArgs']]]]):
        pulumi.set(self, "errors", value)

    @_builtins.property
    @pulumi.getter
    def messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiShieldMessageArgs']]]]:
        return pulumi.get(self, "messages")

    @messages.setter
    def messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiShieldMessageArgs']]]]):
        pulumi.set(self, "messages", value)

    @_builtins.property
    @pulumi.getter
    def success(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the API call was successful.
        """
        return pulumi.get(self, "success")

    @success.setter
    def success(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "success", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/apiShield:ApiShield")
class ApiShield(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_id_characteristics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiShieldAuthIdCharacteristicArgs', 'ApiShieldAuthIdCharacteristicArgsDict']]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_api_shield = cloudflare.ApiShield("example_api_shield",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            auth_id_characteristics=[{
                "name": "authorization",
                "type": "header",
            }])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/apiShield:ApiShield example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiShieldArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_api_shield = cloudflare.ApiShield("example_api_shield",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            auth_id_characteristics=[{
                "name": "authorization",
                "type": "header",
            }])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/apiShield:ApiShield example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ApiShieldArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiShieldArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_id_characteristics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiShieldAuthIdCharacteristicArgs', 'ApiShieldAuthIdCharacteristicArgsDict']]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiShieldArgs.__new__(ApiShieldArgs)

            if auth_id_characteristics is None and not opts.urn:
                raise TypeError("Missing required property 'auth_id_characteristics'")
            __props__.__dict__["auth_id_characteristics"] = auth_id_characteristics
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["errors"] = None
            __props__.__dict__["messages"] = None
            __props__.__dict__["success"] = None
        super(ApiShield, __self__).__init__(
            'cloudflare:index/apiShield:ApiShield',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_id_characteristics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiShieldAuthIdCharacteristicArgs', 'ApiShieldAuthIdCharacteristicArgsDict']]]]] = None,
            errors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiShieldErrorArgs', 'ApiShieldErrorArgsDict']]]]] = None,
            messages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiShieldMessageArgs', 'ApiShieldMessageArgsDict']]]]] = None,
            success: Optional[pulumi.Input[_builtins.bool]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApiShield':
        """
        Get an existing ApiShield resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] success: Whether the API call was successful.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiShieldState.__new__(_ApiShieldState)

        __props__.__dict__["auth_id_characteristics"] = auth_id_characteristics
        __props__.__dict__["errors"] = errors
        __props__.__dict__["messages"] = messages
        __props__.__dict__["success"] = success
        __props__.__dict__["zone_id"] = zone_id
        return ApiShield(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authIdCharacteristics")
    def auth_id_characteristics(self) -> pulumi.Output[Sequence['outputs.ApiShieldAuthIdCharacteristic']]:
        return pulumi.get(self, "auth_id_characteristics")

    @_builtins.property
    @pulumi.getter
    def errors(self) -> pulumi.Output[Sequence['outputs.ApiShieldError']]:
        return pulumi.get(self, "errors")

    @_builtins.property
    @pulumi.getter
    def messages(self) -> pulumi.Output[Sequence['outputs.ApiShieldMessage']]:
        return pulumi.get(self, "messages")

    @_builtins.property
    @pulumi.getter
    def success(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the API call was successful.
        """
        return pulumi.get(self, "success")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

