# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DnsFirewallArgs', 'DnsFirewall']

@pulumi.input_type
class DnsFirewallArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 upstream_ips: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 attack_mitigation: Optional[pulumi.Input['DnsFirewallAttackMitigationArgs']] = None,
                 deprecate_any_requests: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecs_fallback: Optional[pulumi.Input[_builtins.bool]] = None,
                 maximum_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 minimum_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 negative_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 ratelimit: Optional[pulumi.Input[_builtins.float]] = None,
                 retries: Optional[pulumi.Input[_builtins.float]] = None):
        """
        The set of arguments for constructing a DnsFirewall resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] name: DNS Firewall cluster name
        :param pulumi.Input['DnsFirewallAttackMitigationArgs'] attack_mitigation: Attack mitigation settings
        :param pulumi.Input[_builtins.bool] deprecate_any_requests: Whether to refuse to answer queries for the ANY type
        :param pulumi.Input[_builtins.bool] ecs_fallback: Whether to forward client IP (resolver) subnet if no EDNS Client Subnet is sent
        :param pulumi.Input[_builtins.float] maximum_cache_ttl: By default, Cloudflare attempts to cache responses for as long as
               indicated by the TTL received from upstream nameservers. This setting
               sets an upper bound on this duration. For caching purposes, higher TTLs
               will be decreased to the maximum value defined by this setting.
        :param pulumi.Input[_builtins.float] minimum_cache_ttl: By default, Cloudflare attempts to cache responses for as long as
               indicated by the TTL received from upstream nameservers. This setting
               sets a lower bound on this duration. For caching purposes, lower TTLs
               will be increased to the minimum value defined by this setting.
               
               This setting does not affect the TTL value in the DNS response
               Cloudflare returns to clients. Cloudflare will always forward the TTL
               value received from upstream nameservers.
               
               Note that, even with this setting, there is no guarantee that a
               response will be cached for at least the specified duration. Cached
               responses may be removed earlier for capacity or other operational
               reasons.
        :param pulumi.Input[_builtins.float] negative_cache_ttl: This setting controls how long DNS Firewall should cache negative
               responses (e.g., NXDOMAIN) from the upstream servers.
               
               This setting does not affect the TTL value in the DNS response
               Cloudflare returns to clients. Cloudflare will always forward the TTL
               value received from upstream nameservers.
        :param pulumi.Input[_builtins.float] ratelimit: Ratelimit in queries per second per datacenter (applies to DNS queries sent to the upstream nameservers configured on the cluster)
        :param pulumi.Input[_builtins.float] retries: Number of retries for fetching DNS responses from upstream nameservers (not counting the initial attempt)
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "upstream_ips", upstream_ips)
        if attack_mitigation is not None:
            pulumi.set(__self__, "attack_mitigation", attack_mitigation)
        if deprecate_any_requests is not None:
            pulumi.set(__self__, "deprecate_any_requests", deprecate_any_requests)
        if ecs_fallback is not None:
            pulumi.set(__self__, "ecs_fallback", ecs_fallback)
        if maximum_cache_ttl is not None:
            pulumi.set(__self__, "maximum_cache_ttl", maximum_cache_ttl)
        if minimum_cache_ttl is not None:
            pulumi.set(__self__, "minimum_cache_ttl", minimum_cache_ttl)
        if negative_cache_ttl is not None:
            pulumi.set(__self__, "negative_cache_ttl", negative_cache_ttl)
        if ratelimit is not None:
            pulumi.set(__self__, "ratelimit", ratelimit)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        DNS Firewall cluster name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="upstreamIps")
    def upstream_ips(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        return pulumi.get(self, "upstream_ips")

    @upstream_ips.setter
    def upstream_ips(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "upstream_ips", value)

    @_builtins.property
    @pulumi.getter(name="attackMitigation")
    def attack_mitigation(self) -> Optional[pulumi.Input['DnsFirewallAttackMitigationArgs']]:
        """
        Attack mitigation settings
        """
        return pulumi.get(self, "attack_mitigation")

    @attack_mitigation.setter
    def attack_mitigation(self, value: Optional[pulumi.Input['DnsFirewallAttackMitigationArgs']]):
        pulumi.set(self, "attack_mitigation", value)

    @_builtins.property
    @pulumi.getter(name="deprecateAnyRequests")
    def deprecate_any_requests(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to refuse to answer queries for the ANY type
        """
        return pulumi.get(self, "deprecate_any_requests")

    @deprecate_any_requests.setter
    def deprecate_any_requests(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deprecate_any_requests", value)

    @_builtins.property
    @pulumi.getter(name="ecsFallback")
    def ecs_fallback(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to forward client IP (resolver) subnet if no EDNS Client Subnet is sent
        """
        return pulumi.get(self, "ecs_fallback")

    @ecs_fallback.setter
    def ecs_fallback(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ecs_fallback", value)

    @_builtins.property
    @pulumi.getter(name="maximumCacheTtl")
    def maximum_cache_ttl(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        By default, Cloudflare attempts to cache responses for as long as
        indicated by the TTL received from upstream nameservers. This setting
        sets an upper bound on this duration. For caching purposes, higher TTLs
        will be decreased to the maximum value defined by this setting.
        """
        return pulumi.get(self, "maximum_cache_ttl")

    @maximum_cache_ttl.setter
    def maximum_cache_ttl(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "maximum_cache_ttl", value)

    @_builtins.property
    @pulumi.getter(name="minimumCacheTtl")
    def minimum_cache_ttl(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        By default, Cloudflare attempts to cache responses for as long as
        indicated by the TTL received from upstream nameservers. This setting
        sets a lower bound on this duration. For caching purposes, lower TTLs
        will be increased to the minimum value defined by this setting.

        This setting does not affect the TTL value in the DNS response
        Cloudflare returns to clients. Cloudflare will always forward the TTL
        value received from upstream nameservers.

        Note that, even with this setting, there is no guarantee that a
        response will be cached for at least the specified duration. Cached
        responses may be removed earlier for capacity or other operational
        reasons.
        """
        return pulumi.get(self, "minimum_cache_ttl")

    @minimum_cache_ttl.setter
    def minimum_cache_ttl(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "minimum_cache_ttl", value)

    @_builtins.property
    @pulumi.getter(name="negativeCacheTtl")
    def negative_cache_ttl(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        This setting controls how long DNS Firewall should cache negative
        responses (e.g., NXDOMAIN) from the upstream servers.

        This setting does not affect the TTL value in the DNS response
        Cloudflare returns to clients. Cloudflare will always forward the TTL
        value received from upstream nameservers.
        """
        return pulumi.get(self, "negative_cache_ttl")

    @negative_cache_ttl.setter
    def negative_cache_ttl(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "negative_cache_ttl", value)

    @_builtins.property
    @pulumi.getter
    def ratelimit(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Ratelimit in queries per second per datacenter (applies to DNS queries sent to the upstream nameservers configured on the cluster)
        """
        return pulumi.get(self, "ratelimit")

    @ratelimit.setter
    def ratelimit(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ratelimit", value)

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Number of retries for fetching DNS responses from upstream nameservers (not counting the initial attempt)
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "retries", value)


@pulumi.input_type
class _DnsFirewallState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 attack_mitigation: Optional[pulumi.Input['DnsFirewallAttackMitigationArgs']] = None,
                 deprecate_any_requests: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_firewall_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ecs_fallback: Optional[pulumi.Input[_builtins.bool]] = None,
                 maximum_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 minimum_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negative_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 ratelimit: Optional[pulumi.Input[_builtins.float]] = None,
                 retries: Optional[pulumi.Input[_builtins.float]] = None,
                 upstream_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DnsFirewall resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input['DnsFirewallAttackMitigationArgs'] attack_mitigation: Attack mitigation settings
        :param pulumi.Input[_builtins.bool] deprecate_any_requests: Whether to refuse to answer queries for the ANY type
        :param pulumi.Input[_builtins.bool] ecs_fallback: Whether to forward client IP (resolver) subnet if no EDNS Client Subnet is sent
        :param pulumi.Input[_builtins.float] maximum_cache_ttl: By default, Cloudflare attempts to cache responses for as long as
               indicated by the TTL received from upstream nameservers. This setting
               sets an upper bound on this duration. For caching purposes, higher TTLs
               will be decreased to the maximum value defined by this setting.
        :param pulumi.Input[_builtins.float] minimum_cache_ttl: By default, Cloudflare attempts to cache responses for as long as
               indicated by the TTL received from upstream nameservers. This setting
               sets a lower bound on this duration. For caching purposes, lower TTLs
               will be increased to the minimum value defined by this setting.
               
               This setting does not affect the TTL value in the DNS response
               Cloudflare returns to clients. Cloudflare will always forward the TTL
               value received from upstream nameservers.
               
               Note that, even with this setting, there is no guarantee that a
               response will be cached for at least the specified duration. Cached
               responses may be removed earlier for capacity or other operational
               reasons.
        :param pulumi.Input[_builtins.str] modified_on: Last modification of DNS Firewall cluster
        :param pulumi.Input[_builtins.str] name: DNS Firewall cluster name
        :param pulumi.Input[_builtins.float] negative_cache_ttl: This setting controls how long DNS Firewall should cache negative
               responses (e.g., NXDOMAIN) from the upstream servers.
               
               This setting does not affect the TTL value in the DNS response
               Cloudflare returns to clients. Cloudflare will always forward the TTL
               value received from upstream nameservers.
        :param pulumi.Input[_builtins.float] ratelimit: Ratelimit in queries per second per datacenter (applies to DNS queries sent to the upstream nameservers configured on the cluster)
        :param pulumi.Input[_builtins.float] retries: Number of retries for fetching DNS responses from upstream nameservers (not counting the initial attempt)
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if attack_mitigation is not None:
            pulumi.set(__self__, "attack_mitigation", attack_mitigation)
        if deprecate_any_requests is not None:
            pulumi.set(__self__, "deprecate_any_requests", deprecate_any_requests)
        if dns_firewall_ips is not None:
            pulumi.set(__self__, "dns_firewall_ips", dns_firewall_ips)
        if ecs_fallback is not None:
            pulumi.set(__self__, "ecs_fallback", ecs_fallback)
        if maximum_cache_ttl is not None:
            pulumi.set(__self__, "maximum_cache_ttl", maximum_cache_ttl)
        if minimum_cache_ttl is not None:
            pulumi.set(__self__, "minimum_cache_ttl", minimum_cache_ttl)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negative_cache_ttl is not None:
            pulumi.set(__self__, "negative_cache_ttl", negative_cache_ttl)
        if ratelimit is not None:
            pulumi.set(__self__, "ratelimit", ratelimit)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if upstream_ips is not None:
            pulumi.set(__self__, "upstream_ips", upstream_ips)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="attackMitigation")
    def attack_mitigation(self) -> Optional[pulumi.Input['DnsFirewallAttackMitigationArgs']]:
        """
        Attack mitigation settings
        """
        return pulumi.get(self, "attack_mitigation")

    @attack_mitigation.setter
    def attack_mitigation(self, value: Optional[pulumi.Input['DnsFirewallAttackMitigationArgs']]):
        pulumi.set(self, "attack_mitigation", value)

    @_builtins.property
    @pulumi.getter(name="deprecateAnyRequests")
    def deprecate_any_requests(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to refuse to answer queries for the ANY type
        """
        return pulumi.get(self, "deprecate_any_requests")

    @deprecate_any_requests.setter
    def deprecate_any_requests(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deprecate_any_requests", value)

    @_builtins.property
    @pulumi.getter(name="dnsFirewallIps")
    def dns_firewall_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "dns_firewall_ips")

    @dns_firewall_ips.setter
    def dns_firewall_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_firewall_ips", value)

    @_builtins.property
    @pulumi.getter(name="ecsFallback")
    def ecs_fallback(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to forward client IP (resolver) subnet if no EDNS Client Subnet is sent
        """
        return pulumi.get(self, "ecs_fallback")

    @ecs_fallback.setter
    def ecs_fallback(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ecs_fallback", value)

    @_builtins.property
    @pulumi.getter(name="maximumCacheTtl")
    def maximum_cache_ttl(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        By default, Cloudflare attempts to cache responses for as long as
        indicated by the TTL received from upstream nameservers. This setting
        sets an upper bound on this duration. For caching purposes, higher TTLs
        will be decreased to the maximum value defined by this setting.
        """
        return pulumi.get(self, "maximum_cache_ttl")

    @maximum_cache_ttl.setter
    def maximum_cache_ttl(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "maximum_cache_ttl", value)

    @_builtins.property
    @pulumi.getter(name="minimumCacheTtl")
    def minimum_cache_ttl(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        By default, Cloudflare attempts to cache responses for as long as
        indicated by the TTL received from upstream nameservers. This setting
        sets a lower bound on this duration. For caching purposes, lower TTLs
        will be increased to the minimum value defined by this setting.

        This setting does not affect the TTL value in the DNS response
        Cloudflare returns to clients. Cloudflare will always forward the TTL
        value received from upstream nameservers.

        Note that, even with this setting, there is no guarantee that a
        response will be cached for at least the specified duration. Cached
        responses may be removed earlier for capacity or other operational
        reasons.
        """
        return pulumi.get(self, "minimum_cache_ttl")

    @minimum_cache_ttl.setter
    def minimum_cache_ttl(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "minimum_cache_ttl", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last modification of DNS Firewall cluster
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS Firewall cluster name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="negativeCacheTtl")
    def negative_cache_ttl(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        This setting controls how long DNS Firewall should cache negative
        responses (e.g., NXDOMAIN) from the upstream servers.

        This setting does not affect the TTL value in the DNS response
        Cloudflare returns to clients. Cloudflare will always forward the TTL
        value received from upstream nameservers.
        """
        return pulumi.get(self, "negative_cache_ttl")

    @negative_cache_ttl.setter
    def negative_cache_ttl(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "negative_cache_ttl", value)

    @_builtins.property
    @pulumi.getter
    def ratelimit(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Ratelimit in queries per second per datacenter (applies to DNS queries sent to the upstream nameservers configured on the cluster)
        """
        return pulumi.get(self, "ratelimit")

    @ratelimit.setter
    def ratelimit(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ratelimit", value)

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Number of retries for fetching DNS responses from upstream nameservers (not counting the initial attempt)
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "retries", value)

    @_builtins.property
    @pulumi.getter(name="upstreamIps")
    def upstream_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "upstream_ips")

    @upstream_ips.setter
    def upstream_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "upstream_ips", value)


@pulumi.type_token("cloudflare:index/dnsFirewall:DnsFirewall")
class DnsFirewall(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 attack_mitigation: Optional[pulumi.Input[Union['DnsFirewallAttackMitigationArgs', 'DnsFirewallAttackMitigationArgsDict']]] = None,
                 deprecate_any_requests: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecs_fallback: Optional[pulumi.Input[_builtins.bool]] = None,
                 maximum_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 minimum_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negative_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 ratelimit: Optional[pulumi.Input[_builtins.float]] = None,
                 retries: Optional[pulumi.Input[_builtins.float]] = None,
                 upstream_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/dnsFirewall:DnsFirewall example '<account_id>/<dns_firewall_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[Union['DnsFirewallAttackMitigationArgs', 'DnsFirewallAttackMitigationArgsDict']] attack_mitigation: Attack mitigation settings
        :param pulumi.Input[_builtins.bool] deprecate_any_requests: Whether to refuse to answer queries for the ANY type
        :param pulumi.Input[_builtins.bool] ecs_fallback: Whether to forward client IP (resolver) subnet if no EDNS Client Subnet is sent
        :param pulumi.Input[_builtins.float] maximum_cache_ttl: By default, Cloudflare attempts to cache responses for as long as
               indicated by the TTL received from upstream nameservers. This setting
               sets an upper bound on this duration. For caching purposes, higher TTLs
               will be decreased to the maximum value defined by this setting.
        :param pulumi.Input[_builtins.float] minimum_cache_ttl: By default, Cloudflare attempts to cache responses for as long as
               indicated by the TTL received from upstream nameservers. This setting
               sets a lower bound on this duration. For caching purposes, lower TTLs
               will be increased to the minimum value defined by this setting.
               
               This setting does not affect the TTL value in the DNS response
               Cloudflare returns to clients. Cloudflare will always forward the TTL
               value received from upstream nameservers.
               
               Note that, even with this setting, there is no guarantee that a
               response will be cached for at least the specified duration. Cached
               responses may be removed earlier for capacity or other operational
               reasons.
        :param pulumi.Input[_builtins.str] name: DNS Firewall cluster name
        :param pulumi.Input[_builtins.float] negative_cache_ttl: This setting controls how long DNS Firewall should cache negative
               responses (e.g., NXDOMAIN) from the upstream servers.
               
               This setting does not affect the TTL value in the DNS response
               Cloudflare returns to clients. Cloudflare will always forward the TTL
               value received from upstream nameservers.
        :param pulumi.Input[_builtins.float] ratelimit: Ratelimit in queries per second per datacenter (applies to DNS queries sent to the upstream nameservers configured on the cluster)
        :param pulumi.Input[_builtins.float] retries: Number of retries for fetching DNS responses from upstream nameservers (not counting the initial attempt)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsFirewallArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/dnsFirewall:DnsFirewall example '<account_id>/<dns_firewall_id>'
        ```

        :param str resource_name: The name of the resource.
        :param DnsFirewallArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsFirewallArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 attack_mitigation: Optional[pulumi.Input[Union['DnsFirewallAttackMitigationArgs', 'DnsFirewallAttackMitigationArgsDict']]] = None,
                 deprecate_any_requests: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecs_fallback: Optional[pulumi.Input[_builtins.bool]] = None,
                 maximum_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 minimum_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negative_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
                 ratelimit: Optional[pulumi.Input[_builtins.float]] = None,
                 retries: Optional[pulumi.Input[_builtins.float]] = None,
                 upstream_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsFirewallArgs.__new__(DnsFirewallArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["attack_mitigation"] = attack_mitigation
            __props__.__dict__["deprecate_any_requests"] = deprecate_any_requests
            __props__.__dict__["ecs_fallback"] = ecs_fallback
            __props__.__dict__["maximum_cache_ttl"] = maximum_cache_ttl
            __props__.__dict__["minimum_cache_ttl"] = minimum_cache_ttl
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["negative_cache_ttl"] = negative_cache_ttl
            __props__.__dict__["ratelimit"] = ratelimit
            __props__.__dict__["retries"] = retries
            if upstream_ips is None and not opts.urn:
                raise TypeError("Missing required property 'upstream_ips'")
            __props__.__dict__["upstream_ips"] = upstream_ips
            __props__.__dict__["dns_firewall_ips"] = None
            __props__.__dict__["modified_on"] = None
        super(DnsFirewall, __self__).__init__(
            'cloudflare:index/dnsFirewall:DnsFirewall',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            attack_mitigation: Optional[pulumi.Input[Union['DnsFirewallAttackMitigationArgs', 'DnsFirewallAttackMitigationArgsDict']]] = None,
            deprecate_any_requests: Optional[pulumi.Input[_builtins.bool]] = None,
            dns_firewall_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ecs_fallback: Optional[pulumi.Input[_builtins.bool]] = None,
            maximum_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
            minimum_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            negative_cache_ttl: Optional[pulumi.Input[_builtins.float]] = None,
            ratelimit: Optional[pulumi.Input[_builtins.float]] = None,
            retries: Optional[pulumi.Input[_builtins.float]] = None,
            upstream_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'DnsFirewall':
        """
        Get an existing DnsFirewall resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[Union['DnsFirewallAttackMitigationArgs', 'DnsFirewallAttackMitigationArgsDict']] attack_mitigation: Attack mitigation settings
        :param pulumi.Input[_builtins.bool] deprecate_any_requests: Whether to refuse to answer queries for the ANY type
        :param pulumi.Input[_builtins.bool] ecs_fallback: Whether to forward client IP (resolver) subnet if no EDNS Client Subnet is sent
        :param pulumi.Input[_builtins.float] maximum_cache_ttl: By default, Cloudflare attempts to cache responses for as long as
               indicated by the TTL received from upstream nameservers. This setting
               sets an upper bound on this duration. For caching purposes, higher TTLs
               will be decreased to the maximum value defined by this setting.
        :param pulumi.Input[_builtins.float] minimum_cache_ttl: By default, Cloudflare attempts to cache responses for as long as
               indicated by the TTL received from upstream nameservers. This setting
               sets a lower bound on this duration. For caching purposes, lower TTLs
               will be increased to the minimum value defined by this setting.
               
               This setting does not affect the TTL value in the DNS response
               Cloudflare returns to clients. Cloudflare will always forward the TTL
               value received from upstream nameservers.
               
               Note that, even with this setting, there is no guarantee that a
               response will be cached for at least the specified duration. Cached
               responses may be removed earlier for capacity or other operational
               reasons.
        :param pulumi.Input[_builtins.str] modified_on: Last modification of DNS Firewall cluster
        :param pulumi.Input[_builtins.str] name: DNS Firewall cluster name
        :param pulumi.Input[_builtins.float] negative_cache_ttl: This setting controls how long DNS Firewall should cache negative
               responses (e.g., NXDOMAIN) from the upstream servers.
               
               This setting does not affect the TTL value in the DNS response
               Cloudflare returns to clients. Cloudflare will always forward the TTL
               value received from upstream nameservers.
        :param pulumi.Input[_builtins.float] ratelimit: Ratelimit in queries per second per datacenter (applies to DNS queries sent to the upstream nameservers configured on the cluster)
        :param pulumi.Input[_builtins.float] retries: Number of retries for fetching DNS responses from upstream nameservers (not counting the initial attempt)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsFirewallState.__new__(_DnsFirewallState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["attack_mitigation"] = attack_mitigation
        __props__.__dict__["deprecate_any_requests"] = deprecate_any_requests
        __props__.__dict__["dns_firewall_ips"] = dns_firewall_ips
        __props__.__dict__["ecs_fallback"] = ecs_fallback
        __props__.__dict__["maximum_cache_ttl"] = maximum_cache_ttl
        __props__.__dict__["minimum_cache_ttl"] = minimum_cache_ttl
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["negative_cache_ttl"] = negative_cache_ttl
        __props__.__dict__["ratelimit"] = ratelimit
        __props__.__dict__["retries"] = retries
        __props__.__dict__["upstream_ips"] = upstream_ips
        return DnsFirewall(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="attackMitigation")
    def attack_mitigation(self) -> pulumi.Output['outputs.DnsFirewallAttackMitigation']:
        """
        Attack mitigation settings
        """
        return pulumi.get(self, "attack_mitigation")

    @_builtins.property
    @pulumi.getter(name="deprecateAnyRequests")
    def deprecate_any_requests(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to refuse to answer queries for the ANY type
        """
        return pulumi.get(self, "deprecate_any_requests")

    @_builtins.property
    @pulumi.getter(name="dnsFirewallIps")
    def dns_firewall_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "dns_firewall_ips")

    @_builtins.property
    @pulumi.getter(name="ecsFallback")
    def ecs_fallback(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to forward client IP (resolver) subnet if no EDNS Client Subnet is sent
        """
        return pulumi.get(self, "ecs_fallback")

    @_builtins.property
    @pulumi.getter(name="maximumCacheTtl")
    def maximum_cache_ttl(self) -> pulumi.Output[_builtins.float]:
        """
        By default, Cloudflare attempts to cache responses for as long as
        indicated by the TTL received from upstream nameservers. This setting
        sets an upper bound on this duration. For caching purposes, higher TTLs
        will be decreased to the maximum value defined by this setting.
        """
        return pulumi.get(self, "maximum_cache_ttl")

    @_builtins.property
    @pulumi.getter(name="minimumCacheTtl")
    def minimum_cache_ttl(self) -> pulumi.Output[_builtins.float]:
        """
        By default, Cloudflare attempts to cache responses for as long as
        indicated by the TTL received from upstream nameservers. This setting
        sets a lower bound on this duration. For caching purposes, lower TTLs
        will be increased to the minimum value defined by this setting.

        This setting does not affect the TTL value in the DNS response
        Cloudflare returns to clients. Cloudflare will always forward the TTL
        value received from upstream nameservers.

        Note that, even with this setting, there is no guarantee that a
        response will be cached for at least the specified duration. Cached
        responses may be removed earlier for capacity or other operational
        reasons.
        """
        return pulumi.get(self, "minimum_cache_ttl")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        Last modification of DNS Firewall cluster
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        DNS Firewall cluster name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="negativeCacheTtl")
    def negative_cache_ttl(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        This setting controls how long DNS Firewall should cache negative
        responses (e.g., NXDOMAIN) from the upstream servers.

        This setting does not affect the TTL value in the DNS response
        Cloudflare returns to clients. Cloudflare will always forward the TTL
        value received from upstream nameservers.
        """
        return pulumi.get(self, "negative_cache_ttl")

    @_builtins.property
    @pulumi.getter
    def ratelimit(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Ratelimit in queries per second per datacenter (applies to DNS queries sent to the upstream nameservers configured on the cluster)
        """
        return pulumi.get(self, "ratelimit")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> pulumi.Output[_builtins.float]:
        """
        Number of retries for fetching DNS responses from upstream nameservers (not counting the initial attempt)
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter(name="upstreamIps")
    def upstream_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "upstream_ips")

