# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EmailRoutingSettingsArgs', 'EmailRoutingSettings']

@pulumi.input_type
class EmailRoutingSettingsArgs:
    def __init__(__self__, *,
                 zone_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a EmailRoutingSettings resource.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _EmailRoutingSettingsState:
    def __init__(__self__, *,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 modified: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_wizard: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EmailRoutingSettings resources.
        :param pulumi.Input[_builtins.str] created: The date and time the settings have been created.
        :param pulumi.Input[_builtins.bool] enabled: State of the zone settings for Email Routing.
        :param pulumi.Input[_builtins.str] modified: The date and time the settings have been modified.
        :param pulumi.Input[_builtins.str] name: Domain of your zone.
        :param pulumi.Input[_builtins.bool] skip_wizard: Flag to check if the user skipped the configuration wizard.
        :param pulumi.Input[_builtins.str] status: Show the state of your account, and the type or configuration error.
               Available values: "ready", "unconfigured", "misconfigured", "misconfigured/locked", "unlocked".
        :param pulumi.Input[_builtins.str] tag: Email Routing settings tag. (Deprecated, replaced by Email Routing settings identifier)
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if modified is not None:
            pulumi.set(__self__, "modified", modified)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if skip_wizard is not None:
            pulumi.set(__self__, "skip_wizard", skip_wizard)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""tag is deprecated: This attribute is deprecated.""")
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the settings have been created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        State of the zone settings for Email Routing.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the settings have been modified.
        """
        return pulumi.get(self, "modified")

    @modified.setter
    def modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain of your zone.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="skipWizard")
    def skip_wizard(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to check if the user skipped the configuration wizard.
        """
        return pulumi.get(self, "skip_wizard")

    @skip_wizard.setter
    def skip_wizard(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_wizard", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Show the state of your account, and the type or configuration error.
        Available values: "ready", "unconfigured", "misconfigured", "misconfigured/locked", "unlocked".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email Routing settings tag. (Deprecated, replaced by Email Routing settings identifier)
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/emailRoutingSettings:EmailRoutingSettings")
class EmailRoutingSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_email_routing_settings = cloudflare.EmailRoutingSettings("example_email_routing_settings", zone_id="023e105f4ecef8ad9ca31a8372d0c353")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/emailRoutingSettings:EmailRoutingSettings example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EmailRoutingSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_email_routing_settings = cloudflare.EmailRoutingSettings("example_email_routing_settings", zone_id="023e105f4ecef8ad9ca31a8372d0c353")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/emailRoutingSettings:EmailRoutingSettings example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param EmailRoutingSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EmailRoutingSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EmailRoutingSettingsArgs.__new__(EmailRoutingSettingsArgs)

            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created"] = None
            __props__.__dict__["enabled"] = None
            __props__.__dict__["modified"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["skip_wizard"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tag"] = None
        super(EmailRoutingSettings, __self__).__init__(
            'cloudflare:index/emailRoutingSettings:EmailRoutingSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            modified: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            skip_wizard: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tag: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EmailRoutingSettings':
        """
        Get an existing EmailRoutingSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created: The date and time the settings have been created.
        :param pulumi.Input[_builtins.bool] enabled: State of the zone settings for Email Routing.
        :param pulumi.Input[_builtins.str] modified: The date and time the settings have been modified.
        :param pulumi.Input[_builtins.str] name: Domain of your zone.
        :param pulumi.Input[_builtins.bool] skip_wizard: Flag to check if the user skipped the configuration wizard.
        :param pulumi.Input[_builtins.str] status: Show the state of your account, and the type or configuration error.
               Available values: "ready", "unconfigured", "misconfigured", "misconfigured/locked", "unlocked".
        :param pulumi.Input[_builtins.str] tag: Email Routing settings tag. (Deprecated, replaced by Email Routing settings identifier)
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EmailRoutingSettingsState.__new__(_EmailRoutingSettingsState)

        __props__.__dict__["created"] = created
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["modified"] = modified
        __props__.__dict__["name"] = name
        __props__.__dict__["skip_wizard"] = skip_wizard
        __props__.__dict__["status"] = status
        __props__.__dict__["tag"] = tag
        __props__.__dict__["zone_id"] = zone_id
        return EmailRoutingSettings(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the settings have been created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        State of the zone settings for Email Routing.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def modified(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the settings have been modified.
        """
        return pulumi.get(self, "modified")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Domain of your zone.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="skipWizard")
    def skip_wizard(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag to check if the user skipped the configuration wizard.
        """
        return pulumi.get(self, "skip_wizard")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Show the state of your account, and the type or configuration error.
        Available values: "ready", "unconfigured", "misconfigured", "misconfigured/locked", "unlocked".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def tag(self) -> pulumi.Output[_builtins.str]:
        """
        Email Routing settings tag. (Deprecated, replaced by Email Routing settings identifier)
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

