# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallRuleArgs', 'FirewallRule']

@pulumi.input_type
class FirewallRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['FirewallRuleActionArgs'],
                 filter: pulumi.Input['FirewallRuleFilterArgs'],
                 zone_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a FirewallRule resource.
        :param pulumi.Input['FirewallRuleActionArgs'] action: The action to perform when the threshold of matched traffic within the configured period is exceeded.
        :param pulumi.Input[_builtins.str] zone_id: Defines an identifier.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input['FirewallRuleActionArgs']:
        """
        The action to perform when the threshold of matched traffic within the configured period is exceeded.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['FirewallRuleActionArgs']):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Input['FirewallRuleFilterArgs']:
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input['FirewallRuleFilterArgs']):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _FirewallRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['FirewallRuleActionArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input['FirewallRuleFilterArgs']] = None,
                 paused: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.float]] = None,
                 products: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ref: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FirewallRule resources.
        :param pulumi.Input['FirewallRuleActionArgs'] action: The action to perform when the threshold of matched traffic within the configured period is exceeded.
        :param pulumi.Input[_builtins.str] description: An informative summary of the firewall rule.
        :param pulumi.Input[_builtins.bool] paused: When true, indicates that the firewall rule is currently paused.
        :param pulumi.Input[_builtins.float] priority: The priority of the rule. Optional value used to define the processing order. A lower number indicates a higher priority. If not provided, rules with a defined priority will be processed before rules without a priority.
        :param pulumi.Input[_builtins.str] ref: A short reference tag. Allows you to select related firewall rules.
        :param pulumi.Input[_builtins.str] zone_id: Defines an identifier.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if products is not None:
            pulumi.set(__self__, "products", products)
        if ref is not None:
            pulumi.set(__self__, "ref", ref)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['FirewallRuleActionArgs']]:
        """
        The action to perform when the threshold of matched traffic within the configured period is exceeded.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['FirewallRuleActionArgs']]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An informative summary of the firewall rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['FirewallRuleFilterArgs']]:
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['FirewallRuleFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When true, indicates that the firewall rule is currently paused.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "paused", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The priority of the rule. Optional value used to define the processing order. A lower number indicates a higher priority. If not provided, rules with a defined priority will be processed before rules without a priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def products(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "products")

    @products.setter
    def products(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "products", value)

    @_builtins.property
    @pulumi.getter
    def ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A short reference tag. Allows you to select related firewall rules.
        """
        return pulumi.get(self, "ref")

    @ref.setter
    def ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ref", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/firewallRule:FirewallRule")
class FirewallRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['FirewallRuleActionArgs', 'FirewallRuleActionArgsDict']]] = None,
                 filter: Optional[pulumi.Input[Union['FirewallRuleFilterArgs', 'FirewallRuleFilterArgsDict']]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > `FirewallRule` is in a deprecation phase until June 15th, 2025.
          During this time period, this resource is still
          fully supported but you are strongly advised  to move to the
          `Ruleset` resource. Full details can be found in the
          developer documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_firewall_rule = cloudflare.FirewallRule("example_firewall_rule",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            action={
                "mode": "challenge",
                "response": {
                    "body": "<error>This request has been rate-limited.</error>",
                    "content_type": "text/xml",
                },
                "timeout": 86400,
            },
            filter={
                "description": "Restrict access from these browsers on this address range.",
                "expression": "(http.request.uri.path ~ \\".*wp-login.php\\" or http.request.uri.path ~ \\".*xmlrpc.php\\") and ip.addr ne 172.16.22.155",
                "paused": False,
                "ref": "FIL-100",
            })
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/firewallRule:FirewallRule example '<zone_id>/<rule_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FirewallRuleActionArgs', 'FirewallRuleActionArgsDict']] action: The action to perform when the threshold of matched traffic within the configured period is exceeded.
        :param pulumi.Input[_builtins.str] zone_id: Defines an identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > `FirewallRule` is in a deprecation phase until June 15th, 2025.
          During this time period, this resource is still
          fully supported but you are strongly advised  to move to the
          `Ruleset` resource. Full details can be found in the
          developer documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_firewall_rule = cloudflare.FirewallRule("example_firewall_rule",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            action={
                "mode": "challenge",
                "response": {
                    "body": "<error>This request has been rate-limited.</error>",
                    "content_type": "text/xml",
                },
                "timeout": 86400,
            },
            filter={
                "description": "Restrict access from these browsers on this address range.",
                "expression": "(http.request.uri.path ~ \\".*wp-login.php\\" or http.request.uri.path ~ \\".*xmlrpc.php\\") and ip.addr ne 172.16.22.155",
                "paused": False,
                "ref": "FIL-100",
            })
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/firewallRule:FirewallRule example '<zone_id>/<rule_id>'
        ```

        :param str resource_name: The name of the resource.
        :param FirewallRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['FirewallRuleActionArgs', 'FirewallRuleActionArgsDict']]] = None,
                 filter: Optional[pulumi.Input[Union['FirewallRuleFilterArgs', 'FirewallRuleFilterArgsDict']]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallRuleArgs.__new__(FirewallRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if filter is None and not opts.urn:
                raise TypeError("Missing required property 'filter'")
            __props__.__dict__["filter"] = filter
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["description"] = None
            __props__.__dict__["paused"] = None
            __props__.__dict__["priority"] = None
            __props__.__dict__["products"] = None
            __props__.__dict__["ref"] = None
        super(FirewallRule, __self__).__init__(
            'cloudflare:index/firewallRule:FirewallRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[Union['FirewallRuleActionArgs', 'FirewallRuleActionArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            filter: Optional[pulumi.Input[Union['FirewallRuleFilterArgs', 'FirewallRuleFilterArgsDict']]] = None,
            paused: Optional[pulumi.Input[_builtins.bool]] = None,
            priority: Optional[pulumi.Input[_builtins.float]] = None,
            products: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ref: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'FirewallRule':
        """
        Get an existing FirewallRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FirewallRuleActionArgs', 'FirewallRuleActionArgsDict']] action: The action to perform when the threshold of matched traffic within the configured period is exceeded.
        :param pulumi.Input[_builtins.str] description: An informative summary of the firewall rule.
        :param pulumi.Input[_builtins.bool] paused: When true, indicates that the firewall rule is currently paused.
        :param pulumi.Input[_builtins.float] priority: The priority of the rule. Optional value used to define the processing order. A lower number indicates a higher priority. If not provided, rules with a defined priority will be processed before rules without a priority.
        :param pulumi.Input[_builtins.str] ref: A short reference tag. Allows you to select related firewall rules.
        :param pulumi.Input[_builtins.str] zone_id: Defines an identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallRuleState.__new__(_FirewallRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["description"] = description
        __props__.__dict__["filter"] = filter
        __props__.__dict__["paused"] = paused
        __props__.__dict__["priority"] = priority
        __props__.__dict__["products"] = products
        __props__.__dict__["ref"] = ref
        __props__.__dict__["zone_id"] = zone_id
        return FirewallRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output['outputs.FirewallRuleAction']:
        """
        The action to perform when the threshold of matched traffic within the configured period is exceeded.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        An informative summary of the firewall rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output['outputs.FirewallRuleFilter']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def paused(self) -> pulumi.Output[_builtins.bool]:
        """
        When true, indicates that the firewall rule is currently paused.
        """
        return pulumi.get(self, "paused")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.float]:
        """
        The priority of the rule. Optional value used to define the processing order. A lower number indicates a higher priority. If not provided, rules with a defined priority will be processed before rules without a priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def products(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "products")

    @_builtins.property
    @pulumi.getter
    def ref(self) -> pulumi.Output[_builtins.str]:
        """
        A short reference tag. Allows you to select related firewall rules.
        """
        return pulumi.get(self, "ref")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")

