# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAccountApiTokenPermissionGroupsListResult',
    'AwaitableGetAccountApiTokenPermissionGroupsListResult',
    'get_account_api_token_permission_groups_list',
    'get_account_api_token_permission_groups_list_output',
]

@pulumi.output_type
class GetAccountApiTokenPermissionGroupsListResult:
    """
    A collection of values returned by getAccountApiTokenPermissionGroupsList.
    """
    def __init__(__self__, account_id=None, id=None, max_items=None, name=None, results=None, scope=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Filter by the name of the permission group.
        The value must be URL-encoded.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetAccountApiTokenPermissionGroupsListResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        Filter by the scope of the permission group.
        The value must be URL-encoded.
        """
        return pulumi.get(self, "scope")


class AwaitableGetAccountApiTokenPermissionGroupsListResult(GetAccountApiTokenPermissionGroupsListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountApiTokenPermissionGroupsListResult(
            account_id=self.account_id,
            id=self.id,
            max_items=self.max_items,
            name=self.name,
            results=self.results,
            scope=self.scope)


def get_account_api_token_permission_groups_list(account_id: Optional[_builtins.str] = None,
                                                 max_items: Optional[_builtins.int] = None,
                                                 name: Optional[_builtins.str] = None,
                                                 scope: Optional[_builtins.str] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountApiTokenPermissionGroupsListResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_api_token_permission_groups_list = cloudflare.get_account_api_token_permission_groups_list(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        name="Account%20Settings%20Write",
        scope="com.cloudflare.api.account.zone")
    ```


    :param _builtins.str account_id: Account identifier tag.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str name: Filter by the name of the permission group.
           The value must be URL-encoded.
    :param _builtins.str scope: Filter by the scope of the permission group.
           The value must be URL-encoded.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['maxItems'] = max_items
    __args__['name'] = name
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccountApiTokenPermissionGroupsList:getAccountApiTokenPermissionGroupsList', __args__, opts=opts, typ=GetAccountApiTokenPermissionGroupsListResult).value

    return AwaitableGetAccountApiTokenPermissionGroupsListResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        name=pulumi.get(__ret__, 'name'),
        results=pulumi.get(__ret__, 'results'),
        scope=pulumi.get(__ret__, 'scope'))
def get_account_api_token_permission_groups_list_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                        max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                        name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        scope: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountApiTokenPermissionGroupsListResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_api_token_permission_groups_list = cloudflare.get_account_api_token_permission_groups_list(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        name="Account%20Settings%20Write",
        scope="com.cloudflare.api.account.zone")
    ```


    :param _builtins.str account_id: Account identifier tag.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str name: Filter by the name of the permission group.
           The value must be URL-encoded.
    :param _builtins.str scope: Filter by the scope of the permission group.
           The value must be URL-encoded.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['maxItems'] = max_items
    __args__['name'] = name
    __args__['scope'] = scope
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAccountApiTokenPermissionGroupsList:getAccountApiTokenPermissionGroupsList', __args__, opts=opts, typ=GetAccountApiTokenPermissionGroupsListResult)
    return __ret__.apply(lambda __response__: GetAccountApiTokenPermissionGroupsListResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        name=pulumi.get(__response__, 'name'),
        results=pulumi.get(__response__, 'results'),
        scope=pulumi.get(__response__, 'scope')))
