# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAccountDnsSettingsInternalViewsResult',
    'AwaitableGetAccountDnsSettingsInternalViewsResult',
    'get_account_dns_settings_internal_views',
    'get_account_dns_settings_internal_views_output',
]

@pulumi.output_type
class GetAccountDnsSettingsInternalViewsResult:
    """
    A collection of values returned by getAccountDnsSettingsInternalViews.
    """
    def __init__(__self__, account_id=None, direction=None, id=None, match=None, max_items=None, name=None, order=None, results=None, zone_id=None, zone_name=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if match and not isinstance(match, str):
            raise TypeError("Expected argument 'match' to be a str")
        pulumi.set(__self__, "match", match)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if name and not isinstance(name, dict):
            raise TypeError("Expected argument 'name' to be a dict")
        pulumi.set(__self__, "name", name)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)
        if zone_name and not isinstance(zone_name, str):
            raise TypeError("Expected argument 'zone_name' to be a str")
        pulumi.set(__self__, "zone_name", zone_name)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        Direction to order DNS views in.
        Available values: "asc", "desc".
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def match(self) -> _builtins.str:
        """
        Whether to match all search requirements or at least one (any). If set to `all`, acts like a logical AND between filters. If set to `any`, acts like a logical OR instead.
        Available values: "any", "all".
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional['outputs.GetAccountDnsSettingsInternalViewsNameResult']:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.str]:
        """
        Field to order DNS views by.
        Available values: "name", "created*on", "modified*on".
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetAccountDnsSettingsInternalViewsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        A zone ID that exists in the zones list for the view.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> Optional[_builtins.str]:
        """
        A zone name that exists in the zones list for the view.
        """
        return pulumi.get(self, "zone_name")


class AwaitableGetAccountDnsSettingsInternalViewsResult(GetAccountDnsSettingsInternalViewsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountDnsSettingsInternalViewsResult(
            account_id=self.account_id,
            direction=self.direction,
            id=self.id,
            match=self.match,
            max_items=self.max_items,
            name=self.name,
            order=self.order,
            results=self.results,
            zone_id=self.zone_id,
            zone_name=self.zone_name)


def get_account_dns_settings_internal_views(account_id: Optional[_builtins.str] = None,
                                            direction: Optional[_builtins.str] = None,
                                            match: Optional[_builtins.str] = None,
                                            max_items: Optional[_builtins.int] = None,
                                            name: Optional[Union['GetAccountDnsSettingsInternalViewsNameArgs', 'GetAccountDnsSettingsInternalViewsNameArgsDict']] = None,
                                            order: Optional[_builtins.str] = None,
                                            zone_id: Optional[_builtins.str] = None,
                                            zone_name: Optional[_builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountDnsSettingsInternalViewsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_dns_settings_internal_views = cloudflare.get_account_dns_settings_internal_views(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        name={
            "contains": "view",
            "endswith": "ew",
            "exact": "my view",
            "startswith": "my",
        },
        order="name",
        zone_id="ae29bea30e2e427ba9cd8d78b628177b",
        zone_name="www.example.com")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str direction: Direction to order DNS views in.
           Available values: "asc", "desc".
    :param _builtins.str match: Whether to match all search requirements or at least one (any). If set to `all`, acts like a logical AND between filters. If set to `any`, acts like a logical OR instead.
           Available values: "any", "all".
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str order: Field to order DNS views by.
           Available values: "name", "created*on", "modified*on".
    :param _builtins.str zone_id: A zone ID that exists in the zones list for the view.
    :param _builtins.str zone_name: A zone name that exists in the zones list for the view.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['direction'] = direction
    __args__['match'] = match
    __args__['maxItems'] = max_items
    __args__['name'] = name
    __args__['order'] = order
    __args__['zoneId'] = zone_id
    __args__['zoneName'] = zone_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccountDnsSettingsInternalViews:getAccountDnsSettingsInternalViews', __args__, opts=opts, typ=GetAccountDnsSettingsInternalViewsResult).value

    return AwaitableGetAccountDnsSettingsInternalViewsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        direction=pulumi.get(__ret__, 'direction'),
        id=pulumi.get(__ret__, 'id'),
        match=pulumi.get(__ret__, 'match'),
        max_items=pulumi.get(__ret__, 'max_items'),
        name=pulumi.get(__ret__, 'name'),
        order=pulumi.get(__ret__, 'order'),
        results=pulumi.get(__ret__, 'results'),
        zone_id=pulumi.get(__ret__, 'zone_id'),
        zone_name=pulumi.get(__ret__, 'zone_name'))
def get_account_dns_settings_internal_views_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                   direction: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   match: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                   name: Optional[pulumi.Input[Optional[Union['GetAccountDnsSettingsInternalViewsNameArgs', 'GetAccountDnsSettingsInternalViewsNameArgsDict']]]] = None,
                                                   order: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   zone_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountDnsSettingsInternalViewsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_dns_settings_internal_views = cloudflare.get_account_dns_settings_internal_views(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        name={
            "contains": "view",
            "endswith": "ew",
            "exact": "my view",
            "startswith": "my",
        },
        order="name",
        zone_id="ae29bea30e2e427ba9cd8d78b628177b",
        zone_name="www.example.com")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str direction: Direction to order DNS views in.
           Available values: "asc", "desc".
    :param _builtins.str match: Whether to match all search requirements or at least one (any). If set to `all`, acts like a logical AND between filters. If set to `any`, acts like a logical OR instead.
           Available values: "any", "all".
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str order: Field to order DNS views by.
           Available values: "name", "created*on", "modified*on".
    :param _builtins.str zone_id: A zone ID that exists in the zones list for the view.
    :param _builtins.str zone_name: A zone name that exists in the zones list for the view.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['direction'] = direction
    __args__['match'] = match
    __args__['maxItems'] = max_items
    __args__['name'] = name
    __args__['order'] = order
    __args__['zoneId'] = zone_id
    __args__['zoneName'] = zone_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAccountDnsSettingsInternalViews:getAccountDnsSettingsInternalViews', __args__, opts=opts, typ=GetAccountDnsSettingsInternalViewsResult)
    return __ret__.apply(lambda __response__: GetAccountDnsSettingsInternalViewsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        direction=pulumi.get(__response__, 'direction'),
        id=pulumi.get(__response__, 'id'),
        match=pulumi.get(__response__, 'match'),
        max_items=pulumi.get(__response__, 'max_items'),
        name=pulumi.get(__response__, 'name'),
        order=pulumi.get(__response__, 'order'),
        results=pulumi.get(__response__, 'results'),
        zone_id=pulumi.get(__response__, 'zone_id'),
        zone_name=pulumi.get(__response__, 'zone_name')))
