# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAccountMemberResult',
    'AwaitableGetAccountMemberResult',
    'get_account_member',
    'get_account_member_output',
]

@pulumi.output_type
class GetAccountMemberResult:
    """
    A collection of values returned by getAccountMember.
    """
    def __init__(__self__, account_id=None, email=None, filter=None, id=None, member_id=None, policies=None, roles=None, status=None, user=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if member_id and not isinstance(member_id, str):
            raise TypeError("Expected argument 'member_id' to be a str")
        pulumi.set(__self__, "member_id", member_id)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if user and not isinstance(user, dict):
            raise TypeError("Expected argument 'user' to be a dict")
        pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The contact email address of the user.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetAccountMemberFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Membership identifier tag.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="memberId")
    def member_id(self) -> Optional[_builtins.str]:
        """
        Membership identifier tag.
        """
        return pulumi.get(self, "member_id")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetAccountMemberPolicyResult']:
        """
        Access policy for the membership
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.GetAccountMemberRoleResult']:
        """
        Roles assigned to this Member.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        A member's status in the account.
        Available values: "accepted", "pending".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def user(self) -> 'outputs.GetAccountMemberUserResult':
        """
        Details of the user associated to the membership.
        """
        return pulumi.get(self, "user")


class AwaitableGetAccountMemberResult(GetAccountMemberResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountMemberResult(
            account_id=self.account_id,
            email=self.email,
            filter=self.filter,
            id=self.id,
            member_id=self.member_id,
            policies=self.policies,
            roles=self.roles,
            status=self.status,
            user=self.user)


def get_account_member(account_id: Optional[_builtins.str] = None,
                       filter: Optional[Union['GetAccountMemberFilterArgs', 'GetAccountMemberFilterArgsDict']] = None,
                       member_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountMemberResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_member = cloudflare.get_account_member(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        member_id="4536bcfad5faccb111b47003c79917fa")
    ```


    :param _builtins.str account_id: Account identifier tag.
    :param _builtins.str member_id: Membership identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['memberId'] = member_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccountMember:getAccountMember', __args__, opts=opts, typ=GetAccountMemberResult).value

    return AwaitableGetAccountMemberResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        email=pulumi.get(__ret__, 'email'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        member_id=pulumi.get(__ret__, 'member_id'),
        policies=pulumi.get(__ret__, 'policies'),
        roles=pulumi.get(__ret__, 'roles'),
        status=pulumi.get(__ret__, 'status'),
        user=pulumi.get(__ret__, 'user'))
def get_account_member_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                              filter: Optional[pulumi.Input[Optional[Union['GetAccountMemberFilterArgs', 'GetAccountMemberFilterArgsDict']]]] = None,
                              member_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountMemberResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_member = cloudflare.get_account_member(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        member_id="4536bcfad5faccb111b47003c79917fa")
    ```


    :param _builtins.str account_id: Account identifier tag.
    :param _builtins.str member_id: Membership identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['memberId'] = member_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAccountMember:getAccountMember', __args__, opts=opts, typ=GetAccountMemberResult)
    return __ret__.apply(lambda __response__: GetAccountMemberResult(
        account_id=pulumi.get(__response__, 'account_id'),
        email=pulumi.get(__response__, 'email'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        member_id=pulumi.get(__response__, 'member_id'),
        policies=pulumi.get(__response__, 'policies'),
        roles=pulumi.get(__response__, 'roles'),
        status=pulumi.get(__response__, 'status'),
        user=pulumi.get(__response__, 'user')))
