# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAccountMembersResult',
    'AwaitableGetAccountMembersResult',
    'get_account_members',
    'get_account_members_output',
]

@pulumi.output_type
class GetAccountMembersResult:
    """
    A collection of values returned by getAccountMembers.
    """
    def __init__(__self__, account_id=None, direction=None, id=None, max_items=None, order=None, results=None, status=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[_builtins.str]:
        """
        Direction to order results.
        Available values: "asc", "desc".
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.str]:
        """
        Field to order results by.
        Available values: "user.first*name", "user.last*name", "user.email", "status".
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetAccountMembersResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        A member's status in the account.
        Available values: "accepted", "pending", "rejected".
        """
        return pulumi.get(self, "status")


class AwaitableGetAccountMembersResult(GetAccountMembersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountMembersResult(
            account_id=self.account_id,
            direction=self.direction,
            id=self.id,
            max_items=self.max_items,
            order=self.order,
            results=self.results,
            status=self.status)


def get_account_members(account_id: Optional[_builtins.str] = None,
                        direction: Optional[_builtins.str] = None,
                        max_items: Optional[_builtins.int] = None,
                        order: Optional[_builtins.str] = None,
                        status: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountMembersResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_members = cloudflare.get_account_members(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        direction="desc",
        order="status",
        status="accepted")
    ```


    :param _builtins.str account_id: Account identifier tag.
    :param _builtins.str direction: Direction to order results.
           Available values: "asc", "desc".
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str order: Field to order results by.
           Available values: "user.first*name", "user.last*name", "user.email", "status".
    :param _builtins.str status: A member's status in the account.
           Available values: "accepted", "pending", "rejected".
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['direction'] = direction
    __args__['maxItems'] = max_items
    __args__['order'] = order
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccountMembers:getAccountMembers', __args__, opts=opts, typ=GetAccountMembersResult).value

    return AwaitableGetAccountMembersResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        direction=pulumi.get(__ret__, 'direction'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        order=pulumi.get(__ret__, 'order'),
        results=pulumi.get(__ret__, 'results'),
        status=pulumi.get(__ret__, 'status'))
def get_account_members_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                               direction: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                               order: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountMembersResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_members = cloudflare.get_account_members(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        direction="desc",
        order="status",
        status="accepted")
    ```


    :param _builtins.str account_id: Account identifier tag.
    :param _builtins.str direction: Direction to order results.
           Available values: "asc", "desc".
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str order: Field to order results by.
           Available values: "user.first*name", "user.last*name", "user.email", "status".
    :param _builtins.str status: A member's status in the account.
           Available values: "accepted", "pending", "rejected".
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['direction'] = direction
    __args__['maxItems'] = max_items
    __args__['order'] = order
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAccountMembers:getAccountMembers', __args__, opts=opts, typ=GetAccountMembersResult)
    return __ret__.apply(lambda __response__: GetAccountMembersResult(
        account_id=pulumi.get(__response__, 'account_id'),
        direction=pulumi.get(__response__, 'direction'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        order=pulumi.get(__response__, 'order'),
        results=pulumi.get(__response__, 'results'),
        status=pulumi.get(__response__, 'status')))
