# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAccountPermissionGroupsResult',
    'AwaitableGetAccountPermissionGroupsResult',
    'get_account_permission_groups',
    'get_account_permission_groups_output',
]

@pulumi.output_type
class GetAccountPermissionGroupsResult:
    """
    A collection of values returned by getAccountPermissionGroups.
    """
    def __init__(__self__, account_id=None, id=None, label=None, max_items=None, name=None, results=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the permission group to be fetched.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        Label of the permission group to be fetched.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the permission group to be fetched.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetAccountPermissionGroupsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")


class AwaitableGetAccountPermissionGroupsResult(GetAccountPermissionGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountPermissionGroupsResult(
            account_id=self.account_id,
            id=self.id,
            label=self.label,
            max_items=self.max_items,
            name=self.name,
            results=self.results)


def get_account_permission_groups(account_id: Optional[_builtins.str] = None,
                                  id: Optional[_builtins.str] = None,
                                  label: Optional[_builtins.str] = None,
                                  max_items: Optional[_builtins.int] = None,
                                  name: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountPermissionGroupsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_permission_groups = cloudflare.get_account_permission_groups(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        id="6d7f2f5f5b1d4a0e9081fdc98d432fd1",
        label="labelOfThePermissionGroup",
        name="NameOfThePermissionGroup")
    ```


    :param _builtins.str account_id: Account identifier tag.
    :param _builtins.str id: ID of the permission group to be fetched.
    :param _builtins.str label: Label of the permission group to be fetched.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str name: Name of the permission group to be fetched.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['id'] = id
    __args__['label'] = label
    __args__['maxItems'] = max_items
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccountPermissionGroups:getAccountPermissionGroups', __args__, opts=opts, typ=GetAccountPermissionGroupsResult).value

    return AwaitableGetAccountPermissionGroupsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        label=pulumi.get(__ret__, 'label'),
        max_items=pulumi.get(__ret__, 'max_items'),
        name=pulumi.get(__ret__, 'name'),
        results=pulumi.get(__ret__, 'results'))
def get_account_permission_groups_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         label: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountPermissionGroupsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_permission_groups = cloudflare.get_account_permission_groups(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        id="6d7f2f5f5b1d4a0e9081fdc98d432fd1",
        label="labelOfThePermissionGroup",
        name="NameOfThePermissionGroup")
    ```


    :param _builtins.str account_id: Account identifier tag.
    :param _builtins.str id: ID of the permission group to be fetched.
    :param _builtins.str label: Label of the permission group to be fetched.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str name: Name of the permission group to be fetched.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['id'] = id
    __args__['label'] = label
    __args__['maxItems'] = max_items
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAccountPermissionGroups:getAccountPermissionGroups', __args__, opts=opts, typ=GetAccountPermissionGroupsResult)
    return __ret__.apply(lambda __response__: GetAccountPermissionGroupsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        label=pulumi.get(__response__, 'label'),
        max_items=pulumi.get(__response__, 'max_items'),
        name=pulumi.get(__response__, 'name'),
        results=pulumi.get(__response__, 'results')))
