# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetApiShieldSchemasResult',
    'AwaitableGetApiShieldSchemasResult',
    'get_api_shield_schemas',
    'get_api_shield_schemas_output',
]

@pulumi.output_type
class GetApiShieldSchemasResult:
    """
    A collection of values returned by getApiShieldSchemas.
    """
    def __init__(__self__, id=None, max_items=None, omit_source=None, results=None, validation_enabled=None, zone_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if omit_source and not isinstance(omit_source, bool):
            raise TypeError("Expected argument 'omit_source' to be a bool")
        pulumi.set(__self__, "omit_source", omit_source)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if validation_enabled and not isinstance(validation_enabled, bool):
            raise TypeError("Expected argument 'validation_enabled' to be a bool")
        pulumi.set(__self__, "validation_enabled", validation_enabled)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter(name="omitSource")
    def omit_source(self) -> _builtins.bool:
        """
        Omit the source-files of schemas and only retrieve their meta-data.
        """
        return pulumi.get(self, "omit_source")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetApiShieldSchemasResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter(name="validationEnabled")
    def validation_enabled(self) -> Optional[_builtins.bool]:
        """
        Flag whether schema is enabled for validation.
        """
        return pulumi.get(self, "validation_enabled")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetApiShieldSchemasResult(GetApiShieldSchemasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiShieldSchemasResult(
            id=self.id,
            max_items=self.max_items,
            omit_source=self.omit_source,
            results=self.results,
            validation_enabled=self.validation_enabled,
            zone_id=self.zone_id)


def get_api_shield_schemas(max_items: Optional[_builtins.int] = None,
                           omit_source: Optional[_builtins.bool] = None,
                           validation_enabled: Optional[_builtins.bool] = None,
                           zone_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiShieldSchemasResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_api_shield_schemas = cloudflare.get_api_shield_schemas(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        validation_enabled=True)
    ```


    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.bool omit_source: Omit the source-files of schemas and only retrieve their meta-data.
    :param _builtins.bool validation_enabled: Flag whether schema is enabled for validation.
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['maxItems'] = max_items
    __args__['omitSource'] = omit_source
    __args__['validationEnabled'] = validation_enabled
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getApiShieldSchemas:getApiShieldSchemas', __args__, opts=opts, typ=GetApiShieldSchemasResult).value

    return AwaitableGetApiShieldSchemasResult(
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        omit_source=pulumi.get(__ret__, 'omit_source'),
        results=pulumi.get(__ret__, 'results'),
        validation_enabled=pulumi.get(__ret__, 'validation_enabled'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_api_shield_schemas_output(max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                  omit_source: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                  validation_enabled: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                  zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiShieldSchemasResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_api_shield_schemas = cloudflare.get_api_shield_schemas(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        validation_enabled=True)
    ```


    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.bool omit_source: Omit the source-files of schemas and only retrieve their meta-data.
    :param _builtins.bool validation_enabled: Flag whether schema is enabled for validation.
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['maxItems'] = max_items
    __args__['omitSource'] = omit_source
    __args__['validationEnabled'] = validation_enabled
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getApiShieldSchemas:getApiShieldSchemas', __args__, opts=opts, typ=GetApiShieldSchemasResult)
    return __ret__.apply(lambda __response__: GetApiShieldSchemasResult(
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        omit_source=pulumi.get(__response__, 'omit_source'),
        results=pulumi.get(__response__, 'results'),
        validation_enabled=pulumi.get(__response__, 'validation_enabled'),
        zone_id=pulumi.get(__response__, 'zone_id')))
