# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetByoIpPrefixResult',
    'AwaitableGetByoIpPrefixResult',
    'get_byo_ip_prefix',
    'get_byo_ip_prefix_output',
]

@pulumi.output_type
class GetByoIpPrefixResult:
    """
    A collection of values returned by getByoIpPrefix.
    """
    def __init__(__self__, account_id=None, advertised=None, advertised_modified_at=None, approved=None, asn=None, cidr=None, created_at=None, description=None, id=None, loa_document_id=None, modified_at=None, on_demand_enabled=None, on_demand_locked=None, prefix_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if advertised and not isinstance(advertised, bool):
            raise TypeError("Expected argument 'advertised' to be a bool")
        pulumi.set(__self__, "advertised", advertised)
        if advertised_modified_at and not isinstance(advertised_modified_at, str):
            raise TypeError("Expected argument 'advertised_modified_at' to be a str")
        pulumi.set(__self__, "advertised_modified_at", advertised_modified_at)
        if approved and not isinstance(approved, str):
            raise TypeError("Expected argument 'approved' to be a str")
        pulumi.set(__self__, "approved", approved)
        if asn and not isinstance(asn, int):
            raise TypeError("Expected argument 'asn' to be a int")
        pulumi.set(__self__, "asn", asn)
        if cidr and not isinstance(cidr, str):
            raise TypeError("Expected argument 'cidr' to be a str")
        pulumi.set(__self__, "cidr", cidr)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if loa_document_id and not isinstance(loa_document_id, str):
            raise TypeError("Expected argument 'loa_document_id' to be a str")
        pulumi.set(__self__, "loa_document_id", loa_document_id)
        if modified_at and not isinstance(modified_at, str):
            raise TypeError("Expected argument 'modified_at' to be a str")
        pulumi.set(__self__, "modified_at", modified_at)
        if on_demand_enabled and not isinstance(on_demand_enabled, bool):
            raise TypeError("Expected argument 'on_demand_enabled' to be a bool")
        pulumi.set(__self__, "on_demand_enabled", on_demand_enabled)
        if on_demand_locked and not isinstance(on_demand_locked, bool):
            raise TypeError("Expected argument 'on_demand_locked' to be a bool")
        pulumi.set(__self__, "on_demand_locked", on_demand_locked)
        if prefix_id and not isinstance(prefix_id, str):
            raise TypeError("Expected argument 'prefix_id' to be a str")
        pulumi.set(__self__, "prefix_id", prefix_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier of a Cloudflare account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Prefer the [BGP Prefixes API](https://developers.cloudflare.com/api/resources/addressing/subresources/prefixes/subresources/bgp_prefixes/) instead, which allows for advertising multiple BGP routes within a single IP Prefix.""")
    def advertised(self) -> _builtins.bool:
        """
        Prefix advertisement status to the Internet. This field is only not 'null' if on demand is enabled.
        """
        return pulumi.get(self, "advertised")

    @_builtins.property
    @pulumi.getter(name="advertisedModifiedAt")
    @_utilities.deprecated("""Prefer the [BGP Prefixes API](https://developers.cloudflare.com/api/resources/addressing/subresources/prefixes/subresources/bgp_prefixes/) instead, which allows for advertising multiple BGP routes within a single IP Prefix.""")
    def advertised_modified_at(self) -> _builtins.str:
        """
        Last time the advertisement status was changed. This field is only not 'null' if on demand is enabled.
        """
        return pulumi.get(self, "advertised_modified_at")

    @_builtins.property
    @pulumi.getter
    def approved(self) -> _builtins.str:
        """
        Approval state of the prefix (P = pending, V = active).
        """
        return pulumi.get(self, "approved")

    @_builtins.property
    @pulumi.getter
    def asn(self) -> _builtins.int:
        """
        Autonomous System Number (ASN) the prefix will be advertised under.
        """
        return pulumi.get(self, "asn")

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        IP Prefix in Classless Inter-Domain Routing format.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the prefix.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier of an IP Prefix.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="loaDocumentId")
    def loa_document_id(self) -> _builtins.str:
        """
        Identifier for the uploaded LOA document.
        """
        return pulumi.get(self, "loa_document_id")

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> _builtins.str:
        return pulumi.get(self, "modified_at")

    @_builtins.property
    @pulumi.getter(name="onDemandEnabled")
    @_utilities.deprecated("""Prefer the [BGP Prefixes API](https://developers.cloudflare.com/api/resources/addressing/subresources/prefixes/subresources/bgp_prefixes/) instead, which allows for advertising multiple BGP routes within a single IP Prefix.""")
    def on_demand_enabled(self) -> _builtins.bool:
        """
        Whether advertisement of the prefix to the Internet may be dynamically enabled or disabled.
        """
        return pulumi.get(self, "on_demand_enabled")

    @_builtins.property
    @pulumi.getter(name="onDemandLocked")
    @_utilities.deprecated("""Prefer the [BGP Prefixes API](https://developers.cloudflare.com/api/resources/addressing/subresources/prefixes/subresources/bgp_prefixes/) instead, which allows for advertising multiple BGP routes within a single IP Prefix.""")
    def on_demand_locked(self) -> _builtins.bool:
        """
        Whether advertisement status of the prefix is locked, meaning it cannot be changed.
        """
        return pulumi.get(self, "on_demand_locked")

    @_builtins.property
    @pulumi.getter(name="prefixId")
    def prefix_id(self) -> Optional[_builtins.str]:
        """
        Identifier of an IP Prefix.
        """
        return pulumi.get(self, "prefix_id")


class AwaitableGetByoIpPrefixResult(GetByoIpPrefixResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetByoIpPrefixResult(
            account_id=self.account_id,
            advertised=self.advertised,
            advertised_modified_at=self.advertised_modified_at,
            approved=self.approved,
            asn=self.asn,
            cidr=self.cidr,
            created_at=self.created_at,
            description=self.description,
            id=self.id,
            loa_document_id=self.loa_document_id,
            modified_at=self.modified_at,
            on_demand_enabled=self.on_demand_enabled,
            on_demand_locked=self.on_demand_locked,
            prefix_id=self.prefix_id)


def get_byo_ip_prefix(account_id: Optional[_builtins.str] = None,
                      prefix_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetByoIpPrefixResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_byo_ip_prefix = cloudflare.get_byo_ip_prefix(account_id="258def64c72dae45f3e4c8516e2111f2",
        prefix_id="2af39739cc4e3b5910c918468bb89828")
    ```


    :param _builtins.str account_id: Identifier of a Cloudflare account.
    :param _builtins.str prefix_id: Identifier of an IP Prefix.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['prefixId'] = prefix_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getByoIpPrefix:getByoIpPrefix', __args__, opts=opts, typ=GetByoIpPrefixResult).value

    return AwaitableGetByoIpPrefixResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        advertised=pulumi.get(__ret__, 'advertised'),
        advertised_modified_at=pulumi.get(__ret__, 'advertised_modified_at'),
        approved=pulumi.get(__ret__, 'approved'),
        asn=pulumi.get(__ret__, 'asn'),
        cidr=pulumi.get(__ret__, 'cidr'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        loa_document_id=pulumi.get(__ret__, 'loa_document_id'),
        modified_at=pulumi.get(__ret__, 'modified_at'),
        on_demand_enabled=pulumi.get(__ret__, 'on_demand_enabled'),
        on_demand_locked=pulumi.get(__ret__, 'on_demand_locked'),
        prefix_id=pulumi.get(__ret__, 'prefix_id'))
def get_byo_ip_prefix_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                             prefix_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetByoIpPrefixResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_byo_ip_prefix = cloudflare.get_byo_ip_prefix(account_id="258def64c72dae45f3e4c8516e2111f2",
        prefix_id="2af39739cc4e3b5910c918468bb89828")
    ```


    :param _builtins.str account_id: Identifier of a Cloudflare account.
    :param _builtins.str prefix_id: Identifier of an IP Prefix.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['prefixId'] = prefix_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getByoIpPrefix:getByoIpPrefix', __args__, opts=opts, typ=GetByoIpPrefixResult)
    return __ret__.apply(lambda __response__: GetByoIpPrefixResult(
        account_id=pulumi.get(__response__, 'account_id'),
        advertised=pulumi.get(__response__, 'advertised'),
        advertised_modified_at=pulumi.get(__response__, 'advertised_modified_at'),
        approved=pulumi.get(__response__, 'approved'),
        asn=pulumi.get(__response__, 'asn'),
        cidr=pulumi.get(__response__, 'cidr'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        loa_document_id=pulumi.get(__response__, 'loa_document_id'),
        modified_at=pulumi.get(__response__, 'modified_at'),
        on_demand_enabled=pulumi.get(__response__, 'on_demand_enabled'),
        on_demand_locked=pulumi.get(__response__, 'on_demand_locked'),
        prefix_id=pulumi.get(__response__, 'prefix_id')))
