# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCustomHostnamesResult',
    'AwaitableGetCustomHostnamesResult',
    'get_custom_hostnames',
    'get_custom_hostnames_output',
]

@pulumi.output_type
class GetCustomHostnamesResult:
    """
    A collection of values returned by getCustomHostnames.
    """
    def __init__(__self__, direction=None, hostname=None, id=None, max_items=None, order=None, results=None, ssl=None, zone_id=None):
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if ssl and not isinstance(ssl, float):
            raise TypeError("Expected argument 'ssl' to be a float")
        pulumi.set(__self__, "ssl", ssl)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[_builtins.str]:
        """
        Direction to order hostnames.
        Available values: "asc", "desc".
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Fully qualified domain name to match against. This parameter cannot be used with the 'id' parameter.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Hostname ID to match against. This ID was generated and returned during the initial custom_hostname creation. This parameter cannot be used with the 'hostname' parameter.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    def order(self) -> _builtins.str:
        """
        Field to order hostnames by.
        Available values: "ssl", "ssl_status".
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetCustomHostnamesResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter
    def ssl(self) -> Optional[_builtins.float]:
        """
        Whether to filter hostnames based on if they have SSL enabled.
        Available values: 0, 1.
        """
        return pulumi.get(self, "ssl")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetCustomHostnamesResult(GetCustomHostnamesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomHostnamesResult(
            direction=self.direction,
            hostname=self.hostname,
            id=self.id,
            max_items=self.max_items,
            order=self.order,
            results=self.results,
            ssl=self.ssl,
            zone_id=self.zone_id)


def get_custom_hostnames(direction: Optional[_builtins.str] = None,
                         hostname: Optional[_builtins.str] = None,
                         id: Optional[_builtins.str] = None,
                         max_items: Optional[_builtins.int] = None,
                         order: Optional[_builtins.str] = None,
                         ssl: Optional[_builtins.float] = None,
                         zone_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomHostnamesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_custom_hostnames = cloudflare.get_custom_hostnames(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        id="0d89c70d-ad9f-4843-b99f-6cc0252067e9",
        direction="desc",
        hostname="app.example.com",
        ssl=0)
    ```


    :param _builtins.str direction: Direction to order hostnames.
           Available values: "asc", "desc".
    :param _builtins.str hostname: Fully qualified domain name to match against. This parameter cannot be used with the 'id' parameter.
    :param _builtins.str id: Hostname ID to match against. This ID was generated and returned during the initial custom_hostname creation. This parameter cannot be used with the 'hostname' parameter.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str order: Field to order hostnames by.
           Available values: "ssl", "ssl_status".
    :param _builtins.float ssl: Whether to filter hostnames based on if they have SSL enabled.
           Available values: 0, 1.
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['direction'] = direction
    __args__['hostname'] = hostname
    __args__['id'] = id
    __args__['maxItems'] = max_items
    __args__['order'] = order
    __args__['ssl'] = ssl
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getCustomHostnames:getCustomHostnames', __args__, opts=opts, typ=GetCustomHostnamesResult).value

    return AwaitableGetCustomHostnamesResult(
        direction=pulumi.get(__ret__, 'direction'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        order=pulumi.get(__ret__, 'order'),
        results=pulumi.get(__ret__, 'results'),
        ssl=pulumi.get(__ret__, 'ssl'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_custom_hostnames_output(direction: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                hostname: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                order: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                ssl: Optional[pulumi.Input[Optional[_builtins.float]]] = None,
                                zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomHostnamesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_custom_hostnames = cloudflare.get_custom_hostnames(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        id="0d89c70d-ad9f-4843-b99f-6cc0252067e9",
        direction="desc",
        hostname="app.example.com",
        ssl=0)
    ```


    :param _builtins.str direction: Direction to order hostnames.
           Available values: "asc", "desc".
    :param _builtins.str hostname: Fully qualified domain name to match against. This parameter cannot be used with the 'id' parameter.
    :param _builtins.str id: Hostname ID to match against. This ID was generated and returned during the initial custom_hostname creation. This parameter cannot be used with the 'hostname' parameter.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str order: Field to order hostnames by.
           Available values: "ssl", "ssl_status".
    :param _builtins.float ssl: Whether to filter hostnames based on if they have SSL enabled.
           Available values: 0, 1.
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['direction'] = direction
    __args__['hostname'] = hostname
    __args__['id'] = id
    __args__['maxItems'] = max_items
    __args__['order'] = order
    __args__['ssl'] = ssl
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getCustomHostnames:getCustomHostnames', __args__, opts=opts, typ=GetCustomHostnamesResult)
    return __ret__.apply(lambda __response__: GetCustomHostnamesResult(
        direction=pulumi.get(__response__, 'direction'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        order=pulumi.get(__response__, 'order'),
        results=pulumi.get(__response__, 'results'),
        ssl=pulumi.get(__response__, 'ssl'),
        zone_id=pulumi.get(__response__, 'zone_id')))
