# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetImageVariantResult',
    'AwaitableGetImageVariantResult',
    'get_image_variant',
    'get_image_variant_output',
]

@pulumi.output_type
class GetImageVariantResult:
    """
    A collection of values returned by getImageVariant.
    """
    def __init__(__self__, account_id=None, id=None, variant=None, variant_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if variant and not isinstance(variant, dict):
            raise TypeError("Expected argument 'variant' to be a dict")
        pulumi.set(__self__, "variant", variant)
        if variant_id and not isinstance(variant_id, str):
            raise TypeError("Expected argument 'variant_id' to be a str")
        pulumi.set(__self__, "variant_id", variant_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def variant(self) -> 'outputs.GetImageVariantVariantResult':
        return pulumi.get(self, "variant")

    @_builtins.property
    @pulumi.getter(name="variantId")
    def variant_id(self) -> _builtins.str:
        return pulumi.get(self, "variant_id")


class AwaitableGetImageVariantResult(GetImageVariantResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageVariantResult(
            account_id=self.account_id,
            id=self.id,
            variant=self.variant,
            variant_id=self.variant_id)


def get_image_variant(account_id: Optional[_builtins.str] = None,
                      variant_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageVariantResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_image_variant = cloudflare.get_image_variant(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        variant_id="hero")
    ```


    :param _builtins.str account_id: Account identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['variantId'] = variant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getImageVariant:getImageVariant', __args__, opts=opts, typ=GetImageVariantResult).value

    return AwaitableGetImageVariantResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        variant=pulumi.get(__ret__, 'variant'),
        variant_id=pulumi.get(__ret__, 'variant_id'))
def get_image_variant_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                             variant_id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImageVariantResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_image_variant = cloudflare.get_image_variant(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        variant_id="hero")
    ```


    :param _builtins.str account_id: Account identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['variantId'] = variant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getImageVariant:getImageVariant', __args__, opts=opts, typ=GetImageVariantResult)
    return __ret__.apply(lambda __response__: GetImageVariantResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        variant=pulumi.get(__response__, 'variant'),
        variant_id=pulumi.get(__response__, 'variant_id')))
