# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetLogpushDatasetFieldResult',
    'AwaitableGetLogpushDatasetFieldResult',
    'get_logpush_dataset_field',
    'get_logpush_dataset_field_output',
]

@pulumi.output_type
class GetLogpushDatasetFieldResult:
    """
    A collection of values returned by getLogpushDatasetField.
    """
    def __init__(__self__, account_id=None, dataset_id=None, id=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if dataset_id and not isinstance(dataset_id, str):
            raise TypeError("Expected argument 'dataset_id' to be a str")
        pulumi.set(__self__, "dataset_id", dataset_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> _builtins.str:
        """
        Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
        Available values: "access*requests", "audit*logs", "audit*logs*v2", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetLogpushDatasetFieldResult(GetLogpushDatasetFieldResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogpushDatasetFieldResult(
            account_id=self.account_id,
            dataset_id=self.dataset_id,
            id=self.id,
            zone_id=self.zone_id)


def get_logpush_dataset_field(account_id: Optional[_builtins.str] = None,
                              dataset_id: Optional[_builtins.str] = None,
                              zone_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogpushDatasetFieldResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_logpush_dataset_field = cloudflare.get_logpush_dataset_field(dataset_id="gateway_dns",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param _builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param _builtins.str dataset_id: Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
           Available values: "access*requests", "audit*logs", "audit*logs*v2", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
    :param _builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['datasetId'] = dataset_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getLogpushDatasetField:getLogpushDatasetField', __args__, opts=opts, typ=GetLogpushDatasetFieldResult).value

    return AwaitableGetLogpushDatasetFieldResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        dataset_id=pulumi.get(__ret__, 'dataset_id'),
        id=pulumi.get(__ret__, 'id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_logpush_dataset_field_output(account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     dataset_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogpushDatasetFieldResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_logpush_dataset_field = cloudflare.get_logpush_dataset_field(dataset_id="gateway_dns",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param _builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param _builtins.str dataset_id: Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
           Available values: "access*requests", "audit*logs", "audit*logs*v2", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
    :param _builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['datasetId'] = dataset_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getLogpushDatasetField:getLogpushDatasetField', __args__, opts=opts, typ=GetLogpushDatasetFieldResult)
    return __ret__.apply(lambda __response__: GetLogpushDatasetFieldResult(
        account_id=pulumi.get(__response__, 'account_id'),
        dataset_id=pulumi.get(__response__, 'dataset_id'),
        id=pulumi.get(__response__, 'id'),
        zone_id=pulumi.get(__response__, 'zone_id')))
