# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetMagicNetworkMonitoringRuleResult',
    'AwaitableGetMagicNetworkMonitoringRuleResult',
    'get_magic_network_monitoring_rule',
    'get_magic_network_monitoring_rule_output',
]

@pulumi.output_type
class GetMagicNetworkMonitoringRuleResult:
    """
    A collection of values returned by getMagicNetworkMonitoringRule.
    """
    def __init__(__self__, account_id=None, automatic_advertisement=None, bandwidth_threshold=None, duration=None, id=None, name=None, packet_threshold=None, prefix_match=None, prefixes=None, rule_id=None, type=None, zscore_sensitivity=None, zscore_target=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if automatic_advertisement and not isinstance(automatic_advertisement, bool):
            raise TypeError("Expected argument 'automatic_advertisement' to be a bool")
        pulumi.set(__self__, "automatic_advertisement", automatic_advertisement)
        if bandwidth_threshold and not isinstance(bandwidth_threshold, float):
            raise TypeError("Expected argument 'bandwidth_threshold' to be a float")
        pulumi.set(__self__, "bandwidth_threshold", bandwidth_threshold)
        if duration and not isinstance(duration, str):
            raise TypeError("Expected argument 'duration' to be a str")
        pulumi.set(__self__, "duration", duration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if packet_threshold and not isinstance(packet_threshold, float):
            raise TypeError("Expected argument 'packet_threshold' to be a float")
        pulumi.set(__self__, "packet_threshold", packet_threshold)
        if prefix_match and not isinstance(prefix_match, str):
            raise TypeError("Expected argument 'prefix_match' to be a str")
        pulumi.set(__self__, "prefix_match", prefix_match)
        if prefixes and not isinstance(prefixes, list):
            raise TypeError("Expected argument 'prefixes' to be a list")
        pulumi.set(__self__, "prefixes", prefixes)
        if rule_id and not isinstance(rule_id, str):
            raise TypeError("Expected argument 'rule_id' to be a str")
        pulumi.set(__self__, "rule_id", rule_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if zscore_sensitivity and not isinstance(zscore_sensitivity, str):
            raise TypeError("Expected argument 'zscore_sensitivity' to be a str")
        pulumi.set(__self__, "zscore_sensitivity", zscore_sensitivity)
        if zscore_target and not isinstance(zscore_target, str):
            raise TypeError("Expected argument 'zscore_target' to be a str")
        pulumi.set(__self__, "zscore_target", zscore_target)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="automaticAdvertisement")
    def automatic_advertisement(self) -> _builtins.bool:
        """
        Toggle on if you would like Cloudflare to automatically advertise the IP Prefixes within the rule via Magic Transit when the rule is triggered. Only available for users of Magic Transit.
        """
        return pulumi.get(self, "automatic_advertisement")

    @_builtins.property
    @pulumi.getter(name="bandwidthThreshold")
    def bandwidth_threshold(self) -> _builtins.float:
        """
        The number of bits per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        """
        return pulumi.get(self, "bandwidth_threshold")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        The amount of time that the rule threshold must be exceeded to send an alert notification. The final value must be equivalent to one of the following 8 values ["1m","5m","10m","15m","20m","30m","45m","60m"].
        Available values: "1m", "5m", "10m", "15m", "20m", "30m", "45m", "60m".
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the rule. Must be unique.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the rule. Must be unique. Supports characters A-Z, a-z, 0-9, underscore (_), dash (-), period (.), and tilde (~). You can’t have a space in the rule name. Max 256 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packetThreshold")
    def packet_threshold(self) -> _builtins.float:
        """
        The number of packets per second for the rule. When this value is exceeded for the set duration, an alert notification is sent. Minimum of 1 and no maximum.
        """
        return pulumi.get(self, "packet_threshold")

    @_builtins.property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> _builtins.str:
        """
        Prefix match type to be applied for a prefix auto advertisement when using an advanced_ddos rule.
        Available values: "exact", "subnet", "supernet".
        """
        return pulumi.get(self, "prefix_match")

    @_builtins.property
    @pulumi.getter
    def prefixes(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "prefixes")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[_builtins.str]:
        """
        The id of the rule. Must be unique.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        MNM rule type.
        Available values: "threshold", "zscore", "advanced_ddos".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="zscoreSensitivity")
    def zscore_sensitivity(self) -> _builtins.str:
        """
        Level of sensitivity set for zscore rules.
        Available values: "low", "medium", "high".
        """
        return pulumi.get(self, "zscore_sensitivity")

    @_builtins.property
    @pulumi.getter(name="zscoreTarget")
    def zscore_target(self) -> _builtins.str:
        """
        Target of the zscore rule analysis.
        Available values: "bits", "packets".
        """
        return pulumi.get(self, "zscore_target")


class AwaitableGetMagicNetworkMonitoringRuleResult(GetMagicNetworkMonitoringRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMagicNetworkMonitoringRuleResult(
            account_id=self.account_id,
            automatic_advertisement=self.automatic_advertisement,
            bandwidth_threshold=self.bandwidth_threshold,
            duration=self.duration,
            id=self.id,
            name=self.name,
            packet_threshold=self.packet_threshold,
            prefix_match=self.prefix_match,
            prefixes=self.prefixes,
            rule_id=self.rule_id,
            type=self.type,
            zscore_sensitivity=self.zscore_sensitivity,
            zscore_target=self.zscore_target)


def get_magic_network_monitoring_rule(account_id: Optional[_builtins.str] = None,
                                      rule_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMagicNetworkMonitoringRuleResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_magic_network_monitoring_rule = cloudflare.get_magic_network_monitoring_rule(account_id="6f91088a406011ed95aed352566e8d4c",
        rule_id="2890e6fa406311ed9b5a23f70f6fb8cf")
    ```


    :param _builtins.str rule_id: The id of the rule. Must be unique.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['ruleId'] = rule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getMagicNetworkMonitoringRule:getMagicNetworkMonitoringRule', __args__, opts=opts, typ=GetMagicNetworkMonitoringRuleResult).value

    return AwaitableGetMagicNetworkMonitoringRuleResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        automatic_advertisement=pulumi.get(__ret__, 'automatic_advertisement'),
        bandwidth_threshold=pulumi.get(__ret__, 'bandwidth_threshold'),
        duration=pulumi.get(__ret__, 'duration'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        packet_threshold=pulumi.get(__ret__, 'packet_threshold'),
        prefix_match=pulumi.get(__ret__, 'prefix_match'),
        prefixes=pulumi.get(__ret__, 'prefixes'),
        rule_id=pulumi.get(__ret__, 'rule_id'),
        type=pulumi.get(__ret__, 'type'),
        zscore_sensitivity=pulumi.get(__ret__, 'zscore_sensitivity'),
        zscore_target=pulumi.get(__ret__, 'zscore_target'))
def get_magic_network_monitoring_rule_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                             rule_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMagicNetworkMonitoringRuleResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_magic_network_monitoring_rule = cloudflare.get_magic_network_monitoring_rule(account_id="6f91088a406011ed95aed352566e8d4c",
        rule_id="2890e6fa406311ed9b5a23f70f6fb8cf")
    ```


    :param _builtins.str rule_id: The id of the rule. Must be unique.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['ruleId'] = rule_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getMagicNetworkMonitoringRule:getMagicNetworkMonitoringRule', __args__, opts=opts, typ=GetMagicNetworkMonitoringRuleResult)
    return __ret__.apply(lambda __response__: GetMagicNetworkMonitoringRuleResult(
        account_id=pulumi.get(__response__, 'account_id'),
        automatic_advertisement=pulumi.get(__response__, 'automatic_advertisement'),
        bandwidth_threshold=pulumi.get(__response__, 'bandwidth_threshold'),
        duration=pulumi.get(__response__, 'duration'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        packet_threshold=pulumi.get(__response__, 'packet_threshold'),
        prefix_match=pulumi.get(__response__, 'prefix_match'),
        prefixes=pulumi.get(__response__, 'prefixes'),
        rule_id=pulumi.get(__response__, 'rule_id'),
        type=pulumi.get(__response__, 'type'),
        zscore_sensitivity=pulumi.get(__response__, 'zscore_sensitivity'),
        zscore_target=pulumi.get(__response__, 'zscore_target')))
