# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMagicTransitSiteResult',
    'AwaitableGetMagicTransitSiteResult',
    'get_magic_transit_site',
    'get_magic_transit_site_output',
]

@pulumi.output_type
class GetMagicTransitSiteResult:
    """
    A collection of values returned by getMagicTransitSite.
    """
    def __init__(__self__, account_id=None, connector_id=None, description=None, filter=None, ha_mode=None, id=None, location=None, name=None, secondary_connector_id=None, site_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if connector_id and not isinstance(connector_id, str):
            raise TypeError("Expected argument 'connector_id' to be a str")
        pulumi.set(__self__, "connector_id", connector_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if ha_mode and not isinstance(ha_mode, bool):
            raise TypeError("Expected argument 'ha_mode' to be a bool")
        pulumi.set(__self__, "ha_mode", ha_mode)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, dict):
            raise TypeError("Expected argument 'location' to be a dict")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if secondary_connector_id and not isinstance(secondary_connector_id, str):
            raise TypeError("Expected argument 'secondary_connector_id' to be a str")
        pulumi.set(__self__, "secondary_connector_id", secondary_connector_id)
        if site_id and not isinstance(site_id, str):
            raise TypeError("Expected argument 'site_id' to be a str")
        pulumi.set(__self__, "site_id", site_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> _builtins.str:
        """
        Magic Connector identifier tag.
        """
        return pulumi.get(self, "connector_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetMagicTransitSiteFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="haMode")
    def ha_mode(self) -> _builtins.bool:
        """
        Site high availability mode. If set to true, the site can have two connectors and runs in high availability mode.
        """
        return pulumi.get(self, "ha_mode")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> 'outputs.GetMagicTransitSiteLocationResult':
        """
        Location of site in latitude and longitude.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the site.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secondaryConnectorId")
    def secondary_connector_id(self) -> _builtins.str:
        """
        Magic Connector identifier tag. Used when high availability mode is on.
        """
        return pulumi.get(self, "secondary_connector_id")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "site_id")


class AwaitableGetMagicTransitSiteResult(GetMagicTransitSiteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMagicTransitSiteResult(
            account_id=self.account_id,
            connector_id=self.connector_id,
            description=self.description,
            filter=self.filter,
            ha_mode=self.ha_mode,
            id=self.id,
            location=self.location,
            name=self.name,
            secondary_connector_id=self.secondary_connector_id,
            site_id=self.site_id)


def get_magic_transit_site(account_id: Optional[_builtins.str] = None,
                           filter: Optional[Union['GetMagicTransitSiteFilterArgs', 'GetMagicTransitSiteFilterArgsDict']] = None,
                           site_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMagicTransitSiteResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_magic_transit_site = cloudflare.get_magic_transit_site(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        site_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str account_id: Identifier
    :param _builtins.str site_id: Identifier
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['siteId'] = site_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getMagicTransitSite:getMagicTransitSite', __args__, opts=opts, typ=GetMagicTransitSiteResult).value

    return AwaitableGetMagicTransitSiteResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        connector_id=pulumi.get(__ret__, 'connector_id'),
        description=pulumi.get(__ret__, 'description'),
        filter=pulumi.get(__ret__, 'filter'),
        ha_mode=pulumi.get(__ret__, 'ha_mode'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        secondary_connector_id=pulumi.get(__ret__, 'secondary_connector_id'),
        site_id=pulumi.get(__ret__, 'site_id'))
def get_magic_transit_site_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  filter: Optional[pulumi.Input[Optional[Union['GetMagicTransitSiteFilterArgs', 'GetMagicTransitSiteFilterArgsDict']]]] = None,
                                  site_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMagicTransitSiteResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_magic_transit_site = cloudflare.get_magic_transit_site(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        site_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str account_id: Identifier
    :param _builtins.str site_id: Identifier
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['siteId'] = site_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getMagicTransitSite:getMagicTransitSite', __args__, opts=opts, typ=GetMagicTransitSiteResult)
    return __ret__.apply(lambda __response__: GetMagicTransitSiteResult(
        account_id=pulumi.get(__response__, 'account_id'),
        connector_id=pulumi.get(__response__, 'connector_id'),
        description=pulumi.get(__response__, 'description'),
        filter=pulumi.get(__response__, 'filter'),
        ha_mode=pulumi.get(__response__, 'ha_mode'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        secondary_connector_id=pulumi.get(__response__, 'secondary_connector_id'),
        site_id=pulumi.get(__response__, 'site_id')))
