# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetPageRuleResult',
    'AwaitableGetPageRuleResult',
    'get_page_rule',
    'get_page_rule_output',
]

@pulumi.output_type
class GetPageRuleResult:
    """
    A collection of values returned by getPageRule.
    """
    def __init__(__self__, created_on=None, id=None, modified_on=None, pagerule_id=None, priority=None, status=None, zone_id=None):
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if pagerule_id and not isinstance(pagerule_id, str):
            raise TypeError("Expected argument 'pagerule_id' to be a str")
        pulumi.set(__self__, "pagerule_id", pagerule_id)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> _builtins.str:
        """
        The timestamp of when the Page Rule was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> _builtins.str:
        """
        The timestamp of when the Page Rule was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter(name="pageruleId")
    def pagerule_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "pagerule_id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The priority of the rule, used to define which Page Rule is processed
        over another. A higher number indicates a higher priority. For example,
        if you have a catch-all Page Rule (rule A: `/images/*`) but want a more
        specific Page Rule to take precedence (rule B: `/images/special/*`),
        specify a higher priority for rule B so it overrides rule A.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Page Rule.
        Available values: "active", "disabled".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetPageRuleResult(GetPageRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPageRuleResult(
            created_on=self.created_on,
            id=self.id,
            modified_on=self.modified_on,
            pagerule_id=self.pagerule_id,
            priority=self.priority,
            status=self.status,
            zone_id=self.zone_id)


def get_page_rule(pagerule_id: Optional[_builtins.str] = None,
                  zone_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPageRuleResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_page_rule = cloudflare.get_page_rule(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        pagerule_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str pagerule_id: Identifier.
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['pageruleId'] = pagerule_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getPageRule:getPageRule', __args__, opts=opts, typ=GetPageRuleResult).value

    return AwaitableGetPageRuleResult(
        created_on=pulumi.get(__ret__, 'created_on'),
        id=pulumi.get(__ret__, 'id'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        pagerule_id=pulumi.get(__ret__, 'pagerule_id'),
        priority=pulumi.get(__ret__, 'priority'),
        status=pulumi.get(__ret__, 'status'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_page_rule_output(pagerule_id: Optional[pulumi.Input[_builtins.str]] = None,
                         zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPageRuleResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_page_rule = cloudflare.get_page_rule(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        pagerule_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str pagerule_id: Identifier.
    :param _builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['pageruleId'] = pagerule_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getPageRule:getPageRule', __args__, opts=opts, typ=GetPageRuleResult)
    return __ret__.apply(lambda __response__: GetPageRuleResult(
        created_on=pulumi.get(__response__, 'created_on'),
        id=pulumi.get(__response__, 'id'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        pagerule_id=pulumi.get(__response__, 'pagerule_id'),
        priority=pulumi.get(__response__, 'priority'),
        status=pulumi.get(__response__, 'status'),
        zone_id=pulumi.get(__response__, 'zone_id')))
