# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetQueueResult',
    'AwaitableGetQueueResult',
    'get_queue',
    'get_queue_output',
]

@pulumi.output_type
class GetQueueResult:
    """
    A collection of values returned by getQueue.
    """
    def __init__(__self__, account_id=None, consumers=None, consumers_total_count=None, created_on=None, id=None, modified_on=None, producers=None, producers_total_count=None, queue_id=None, queue_name=None, settings=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if consumers and not isinstance(consumers, list):
            raise TypeError("Expected argument 'consumers' to be a list")
        pulumi.set(__self__, "consumers", consumers)
        if consumers_total_count and not isinstance(consumers_total_count, float):
            raise TypeError("Expected argument 'consumers_total_count' to be a float")
        pulumi.set(__self__, "consumers_total_count", consumers_total_count)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if producers and not isinstance(producers, list):
            raise TypeError("Expected argument 'producers' to be a list")
        pulumi.set(__self__, "producers", producers)
        if producers_total_count and not isinstance(producers_total_count, float):
            raise TypeError("Expected argument 'producers_total_count' to be a float")
        pulumi.set(__self__, "producers_total_count", producers_total_count)
        if queue_id and not isinstance(queue_id, str):
            raise TypeError("Expected argument 'queue_id' to be a str")
        pulumi.set(__self__, "queue_id", queue_id)
        if queue_name and not isinstance(queue_name, str):
            raise TypeError("Expected argument 'queue_name' to be a str")
        pulumi.set(__self__, "queue_name", queue_name)
        if settings and not isinstance(settings, dict):
            raise TypeError("Expected argument 'settings' to be a dict")
        pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def consumers(self) -> Sequence['outputs.GetQueueConsumerResult']:
        return pulumi.get(self, "consumers")

    @_builtins.property
    @pulumi.getter(name="consumersTotalCount")
    def consumers_total_count(self) -> _builtins.float:
        return pulumi.get(self, "consumers_total_count")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> _builtins.str:
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> _builtins.str:
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def producers(self) -> Sequence['outputs.GetQueueProducerResult']:
        return pulumi.get(self, "producers")

    @_builtins.property
    @pulumi.getter(name="producersTotalCount")
    def producers_total_count(self) -> _builtins.float:
        return pulumi.get(self, "producers_total_count")

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> _builtins.str:
        """
        A Resource identifier.
        """
        return pulumi.get(self, "queue_id")

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> _builtins.str:
        return pulumi.get(self, "queue_name")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> 'outputs.GetQueueSettingsResult':
        return pulumi.get(self, "settings")


class AwaitableGetQueueResult(GetQueueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueueResult(
            account_id=self.account_id,
            consumers=self.consumers,
            consumers_total_count=self.consumers_total_count,
            created_on=self.created_on,
            id=self.id,
            modified_on=self.modified_on,
            producers=self.producers,
            producers_total_count=self.producers_total_count,
            queue_id=self.queue_id,
            queue_name=self.queue_name,
            settings=self.settings)


def get_queue(account_id: Optional[_builtins.str] = None,
              queue_id: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueueResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_queue = cloudflare.get_queue(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        queue_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str account_id: A Resource identifier.
    :param _builtins.str queue_id: A Resource identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['queueId'] = queue_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getQueue:getQueue', __args__, opts=opts, typ=GetQueueResult).value

    return AwaitableGetQueueResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        consumers=pulumi.get(__ret__, 'consumers'),
        consumers_total_count=pulumi.get(__ret__, 'consumers_total_count'),
        created_on=pulumi.get(__ret__, 'created_on'),
        id=pulumi.get(__ret__, 'id'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        producers=pulumi.get(__ret__, 'producers'),
        producers_total_count=pulumi.get(__ret__, 'producers_total_count'),
        queue_id=pulumi.get(__ret__, 'queue_id'),
        queue_name=pulumi.get(__ret__, 'queue_name'),
        settings=pulumi.get(__ret__, 'settings'))
def get_queue_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                     queue_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQueueResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_queue = cloudflare.get_queue(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        queue_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param _builtins.str account_id: A Resource identifier.
    :param _builtins.str queue_id: A Resource identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['queueId'] = queue_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getQueue:getQueue', __args__, opts=opts, typ=GetQueueResult)
    return __ret__.apply(lambda __response__: GetQueueResult(
        account_id=pulumi.get(__response__, 'account_id'),
        consumers=pulumi.get(__response__, 'consumers'),
        consumers_total_count=pulumi.get(__response__, 'consumers_total_count'),
        created_on=pulumi.get(__response__, 'created_on'),
        id=pulumi.get(__response__, 'id'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        producers=pulumi.get(__response__, 'producers'),
        producers_total_count=pulumi.get(__response__, 'producers_total_count'),
        queue_id=pulumi.get(__response__, 'queue_id'),
        queue_name=pulumi.get(__response__, 'queue_name'),
        settings=pulumi.get(__response__, 'settings')))
