# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRulesetResult',
    'AwaitableGetRulesetResult',
    'get_ruleset',
    'get_ruleset_output',
]

@pulumi.output_type
class GetRulesetResult:
    """
    A collection of values returned by getRuleset.
    """
    def __init__(__self__, account_id=None, description=None, id=None, kind=None, last_updated=None, name=None, phase=None, rules=None, ruleset_id=None, version=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if last_updated and not isinstance(last_updated, str):
            raise TypeError("Expected argument 'last_updated' to be a str")
        pulumi.set(__self__, "last_updated", last_updated)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if phase and not isinstance(phase, str):
            raise TypeError("Expected argument 'phase' to be a str")
        pulumi.set(__self__, "phase", phase)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if ruleset_id and not isinstance(ruleset_id, str):
            raise TypeError("Expected argument 'ruleset_id' to be a str")
        pulumi.set(__self__, "ruleset_id", ruleset_id)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        The unique ID of the account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        An informative description of the ruleset.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The unique ID of the ruleset.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The kind of the ruleset.
        Available values: "managed", "custom", "root", "zone".
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> _builtins.str:
        """
        The timestamp of when the ruleset was last modified.
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The human-readable name of the ruleset.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def phase(self) -> _builtins.str:
        """
        The phase of the ruleset.
        Available values: "ddos*l4", "ddos*l7", "http*config*settings", "http*custom*errors", "http*log*custom*fields", "http*ratelimit", "http*request*cache*settings", "http*request*dynamic*redirect", "http*request*firewall*custom", "http*request*firewall*managed", "http*request*late*transform", "http*request*origin", "http*request*redirect", "http*request*sanitize", "http*request*sbfm", "http*request*transform", "http*response*compression", "http*response*firewall*managed", "http*response*headers*transform", "magic*transit", "magic*transit*ids*managed", "magic*transit*managed", "magic*transit_ratelimit".
        """
        return pulumi.get(self, "phase")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetRulesetRuleResult']:
        """
        The list of rules in the ruleset.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="rulesetId")
    @_utilities.deprecated("""Configure id instead. This attribute will be removed in the next major version of the provider.""")
    def ruleset_id(self) -> Optional[_builtins.str]:
        """
        The unique ID of the ruleset.
        """
        return pulumi.get(self, "ruleset_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the ruleset.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        The unique ID of the zone.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetRulesetResult(GetRulesetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRulesetResult(
            account_id=self.account_id,
            description=self.description,
            id=self.id,
            kind=self.kind,
            last_updated=self.last_updated,
            name=self.name,
            phase=self.phase,
            rules=self.rules,
            ruleset_id=self.ruleset_id,
            version=self.version,
            zone_id=self.zone_id)


def get_ruleset(account_id: Optional[_builtins.str] = None,
                id: Optional[_builtins.str] = None,
                ruleset_id: Optional[_builtins.str] = None,
                zone_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRulesetResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_ruleset = cloudflare.get_ruleset(zone_id="9f1839b6152d298aca64c4e906b6d074",
        id="2f2feab2026849078ba485f918791bdc")
    ```


    :param _builtins.str account_id: The unique ID of the account.
    :param _builtins.str id: The unique ID of the ruleset.
    :param _builtins.str ruleset_id: The unique ID of the ruleset.
    :param _builtins.str zone_id: The unique ID of the zone.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['id'] = id
    __args__['rulesetId'] = ruleset_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getRuleset:getRuleset', __args__, opts=opts, typ=GetRulesetResult).value

    return AwaitableGetRulesetResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        kind=pulumi.get(__ret__, 'kind'),
        last_updated=pulumi.get(__ret__, 'last_updated'),
        name=pulumi.get(__ret__, 'name'),
        phase=pulumi.get(__ret__, 'phase'),
        rules=pulumi.get(__ret__, 'rules'),
        ruleset_id=pulumi.get(__ret__, 'ruleset_id'),
        version=pulumi.get(__ret__, 'version'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_ruleset_output(account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       ruleset_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRulesetResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_ruleset = cloudflare.get_ruleset(zone_id="9f1839b6152d298aca64c4e906b6d074",
        id="2f2feab2026849078ba485f918791bdc")
    ```


    :param _builtins.str account_id: The unique ID of the account.
    :param _builtins.str id: The unique ID of the ruleset.
    :param _builtins.str ruleset_id: The unique ID of the ruleset.
    :param _builtins.str zone_id: The unique ID of the zone.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['id'] = id
    __args__['rulesetId'] = ruleset_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getRuleset:getRuleset', __args__, opts=opts, typ=GetRulesetResult)
    return __ret__.apply(lambda __response__: GetRulesetResult(
        account_id=pulumi.get(__response__, 'account_id'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        kind=pulumi.get(__response__, 'kind'),
        last_updated=pulumi.get(__response__, 'last_updated'),
        name=pulumi.get(__response__, 'name'),
        phase=pulumi.get(__response__, 'phase'),
        rules=pulumi.get(__response__, 'rules'),
        ruleset_id=pulumi.get(__response__, 'ruleset_id'),
        version=pulumi.get(__response__, 'version'),
        zone_id=pulumi.get(__response__, 'zone_id')))
