# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, betas=None, country=None, first_name=None, has_business_zones=None, has_enterprise_zones=None, has_pro_zones=None, id=None, last_name=None, organizations=None, suspended=None, telephone=None, two_factor_authentication_enabled=None, two_factor_authentication_locked=None, zipcode=None):
        if betas and not isinstance(betas, list):
            raise TypeError("Expected argument 'betas' to be a list")
        pulumi.set(__self__, "betas", betas)
        if country and not isinstance(country, str):
            raise TypeError("Expected argument 'country' to be a str")
        pulumi.set(__self__, "country", country)
        if first_name and not isinstance(first_name, str):
            raise TypeError("Expected argument 'first_name' to be a str")
        pulumi.set(__self__, "first_name", first_name)
        if has_business_zones and not isinstance(has_business_zones, bool):
            raise TypeError("Expected argument 'has_business_zones' to be a bool")
        pulumi.set(__self__, "has_business_zones", has_business_zones)
        if has_enterprise_zones and not isinstance(has_enterprise_zones, bool):
            raise TypeError("Expected argument 'has_enterprise_zones' to be a bool")
        pulumi.set(__self__, "has_enterprise_zones", has_enterprise_zones)
        if has_pro_zones and not isinstance(has_pro_zones, bool):
            raise TypeError("Expected argument 'has_pro_zones' to be a bool")
        pulumi.set(__self__, "has_pro_zones", has_pro_zones)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_name and not isinstance(last_name, str):
            raise TypeError("Expected argument 'last_name' to be a str")
        pulumi.set(__self__, "last_name", last_name)
        if organizations and not isinstance(organizations, list):
            raise TypeError("Expected argument 'organizations' to be a list")
        pulumi.set(__self__, "organizations", organizations)
        if suspended and not isinstance(suspended, bool):
            raise TypeError("Expected argument 'suspended' to be a bool")
        pulumi.set(__self__, "suspended", suspended)
        if telephone and not isinstance(telephone, str):
            raise TypeError("Expected argument 'telephone' to be a str")
        pulumi.set(__self__, "telephone", telephone)
        if two_factor_authentication_enabled and not isinstance(two_factor_authentication_enabled, bool):
            raise TypeError("Expected argument 'two_factor_authentication_enabled' to be a bool")
        pulumi.set(__self__, "two_factor_authentication_enabled", two_factor_authentication_enabled)
        if two_factor_authentication_locked and not isinstance(two_factor_authentication_locked, bool):
            raise TypeError("Expected argument 'two_factor_authentication_locked' to be a bool")
        pulumi.set(__self__, "two_factor_authentication_locked", two_factor_authentication_locked)
        if zipcode and not isinstance(zipcode, str):
            raise TypeError("Expected argument 'zipcode' to be a str")
        pulumi.set(__self__, "zipcode", zipcode)

    @_builtins.property
    @pulumi.getter
    def betas(self) -> Sequence[_builtins.str]:
        """
        Lists the betas that the user is participating in.
        """
        return pulumi.get(self, "betas")

    @_builtins.property
    @pulumi.getter
    def country(self) -> _builtins.str:
        """
        The country in which the user lives.
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> _builtins.str:
        """
        User's first name
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter(name="hasBusinessZones")
    def has_business_zones(self) -> _builtins.bool:
        """
        Indicates whether user has any business zones
        """
        return pulumi.get(self, "has_business_zones")

    @_builtins.property
    @pulumi.getter(name="hasEnterpriseZones")
    def has_enterprise_zones(self) -> _builtins.bool:
        """
        Indicates whether user has any enterprise zones
        """
        return pulumi.get(self, "has_enterprise_zones")

    @_builtins.property
    @pulumi.getter(name="hasProZones")
    def has_pro_zones(self) -> _builtins.bool:
        """
        Indicates whether user has any pro zones
        """
        return pulumi.get(self, "has_pro_zones")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier of the user.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> _builtins.str:
        """
        User's last name
        """
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter
    def organizations(self) -> Sequence['outputs.GetUserOrganizationResult']:
        return pulumi.get(self, "organizations")

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> _builtins.bool:
        """
        Indicates whether user has been suspended
        """
        return pulumi.get(self, "suspended")

    @_builtins.property
    @pulumi.getter
    def telephone(self) -> _builtins.str:
        """
        User's telephone number
        """
        return pulumi.get(self, "telephone")

    @_builtins.property
    @pulumi.getter(name="twoFactorAuthenticationEnabled")
    def two_factor_authentication_enabled(self) -> _builtins.bool:
        """
        Indicates whether two-factor authentication is enabled for the user account. Does not apply to API authentication.
        """
        return pulumi.get(self, "two_factor_authentication_enabled")

    @_builtins.property
    @pulumi.getter(name="twoFactorAuthenticationLocked")
    def two_factor_authentication_locked(self) -> _builtins.bool:
        """
        Indicates whether two-factor authentication is required by one of the accounts that the user is a member of.
        """
        return pulumi.get(self, "two_factor_authentication_locked")

    @_builtins.property
    @pulumi.getter
    def zipcode(self) -> _builtins.str:
        """
        The zipcode or postal code where the user lives.
        """
        return pulumi.get(self, "zipcode")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            betas=self.betas,
            country=self.country,
            first_name=self.first_name,
            has_business_zones=self.has_business_zones,
            has_enterprise_zones=self.has_enterprise_zones,
            has_pro_zones=self.has_pro_zones,
            id=self.id,
            last_name=self.last_name,
            organizations=self.organizations,
            suspended=self.suspended,
            telephone=self.telephone,
            two_factor_authentication_enabled=self.two_factor_authentication_enabled,
            two_factor_authentication_locked=self.two_factor_authentication_locked,
            zipcode=self.zipcode)


def get_user(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_user = cloudflare.get_user()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        betas=pulumi.get(__ret__, 'betas'),
        country=pulumi.get(__ret__, 'country'),
        first_name=pulumi.get(__ret__, 'first_name'),
        has_business_zones=pulumi.get(__ret__, 'has_business_zones'),
        has_enterprise_zones=pulumi.get(__ret__, 'has_enterprise_zones'),
        has_pro_zones=pulumi.get(__ret__, 'has_pro_zones'),
        id=pulumi.get(__ret__, 'id'),
        last_name=pulumi.get(__ret__, 'last_name'),
        organizations=pulumi.get(__ret__, 'organizations'),
        suspended=pulumi.get(__ret__, 'suspended'),
        telephone=pulumi.get(__ret__, 'telephone'),
        two_factor_authentication_enabled=pulumi.get(__ret__, 'two_factor_authentication_enabled'),
        two_factor_authentication_locked=pulumi.get(__ret__, 'two_factor_authentication_locked'),
        zipcode=pulumi.get(__ret__, 'zipcode'))
def get_user_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_user = cloudflare.get_user()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult)
    return __ret__.apply(lambda __response__: GetUserResult(
        betas=pulumi.get(__response__, 'betas'),
        country=pulumi.get(__response__, 'country'),
        first_name=pulumi.get(__response__, 'first_name'),
        has_business_zones=pulumi.get(__response__, 'has_business_zones'),
        has_enterprise_zones=pulumi.get(__response__, 'has_enterprise_zones'),
        has_pro_zones=pulumi.get(__response__, 'has_pro_zones'),
        id=pulumi.get(__response__, 'id'),
        last_name=pulumi.get(__response__, 'last_name'),
        organizations=pulumi.get(__response__, 'organizations'),
        suspended=pulumi.get(__response__, 'suspended'),
        telephone=pulumi.get(__response__, 'telephone'),
        two_factor_authentication_enabled=pulumi.get(__response__, 'two_factor_authentication_enabled'),
        two_factor_authentication_locked=pulumi.get(__response__, 'two_factor_authentication_locked'),
        zipcode=pulumi.get(__response__, 'zipcode')))
