# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetWorkerResult',
    'AwaitableGetWorkerResult',
    'get_worker',
    'get_worker_output',
]

@pulumi.output_type
class GetWorkerResult:
    """
    A collection of values returned by getWorker.
    """
    def __init__(__self__, account_id=None, created_on=None, id=None, logpush=None, name=None, observability=None, subdomain=None, tags=None, tail_consumers=None, updated_on=None, worker_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if logpush and not isinstance(logpush, bool):
            raise TypeError("Expected argument 'logpush' to be a bool")
        pulumi.set(__self__, "logpush", logpush)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if observability and not isinstance(observability, dict):
            raise TypeError("Expected argument 'observability' to be a dict")
        pulumi.set(__self__, "observability", observability)
        if subdomain and not isinstance(subdomain, dict):
            raise TypeError("Expected argument 'subdomain' to be a dict")
        pulumi.set(__self__, "subdomain", subdomain)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tail_consumers and not isinstance(tail_consumers, list):
            raise TypeError("Expected argument 'tail_consumers' to be a list")
        pulumi.set(__self__, "tail_consumers", tail_consumers)
        if updated_on and not isinstance(updated_on, str):
            raise TypeError("Expected argument 'updated_on' to be a str")
        pulumi.set(__self__, "updated_on", updated_on)
        if worker_id and not isinstance(worker_id, str):
            raise TypeError("Expected argument 'worker_id' to be a str")
        pulumi.set(__self__, "worker_id", worker_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> _builtins.str:
        """
        When the Worker was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier for the Worker, which can be ID or name.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def logpush(self) -> _builtins.bool:
        """
        Whether logpush is enabled for the Worker.
        """
        return pulumi.get(self, "logpush")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the Worker.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def observability(self) -> 'outputs.GetWorkerObservabilityResult':
        """
        Observability settings for the Worker.
        """
        return pulumi.get(self, "observability")

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> 'outputs.GetWorkerSubdomainResult':
        """
        Subdomain settings for the Worker.
        """
        return pulumi.get(self, "subdomain")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags associated with the Worker.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tailConsumers")
    def tail_consumers(self) -> Sequence['outputs.GetWorkerTailConsumerResult']:
        """
        Other Workers that should consume logs from the Worker.
        """
        return pulumi.get(self, "tail_consumers")

    @_builtins.property
    @pulumi.getter(name="updatedOn")
    def updated_on(self) -> _builtins.str:
        """
        When the Worker was most recently updated.
        """
        return pulumi.get(self, "updated_on")

    @_builtins.property
    @pulumi.getter(name="workerId")
    def worker_id(self) -> Optional[_builtins.str]:
        """
        Identifier for the Worker, which can be ID or name.
        """
        return pulumi.get(self, "worker_id")


class AwaitableGetWorkerResult(GetWorkerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkerResult(
            account_id=self.account_id,
            created_on=self.created_on,
            id=self.id,
            logpush=self.logpush,
            name=self.name,
            observability=self.observability,
            subdomain=self.subdomain,
            tags=self.tags,
            tail_consumers=self.tail_consumers,
            updated_on=self.updated_on,
            worker_id=self.worker_id)


def get_worker(account_id: Optional[_builtins.str] = None,
               worker_id: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkerResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_worker = cloudflare.get_worker(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        worker_id="worker_id")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str worker_id: Identifier for the Worker, which can be ID or name.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['workerId'] = worker_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getWorker:getWorker', __args__, opts=opts, typ=GetWorkerResult).value

    return AwaitableGetWorkerResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        created_on=pulumi.get(__ret__, 'created_on'),
        id=pulumi.get(__ret__, 'id'),
        logpush=pulumi.get(__ret__, 'logpush'),
        name=pulumi.get(__ret__, 'name'),
        observability=pulumi.get(__ret__, 'observability'),
        subdomain=pulumi.get(__ret__, 'subdomain'),
        tags=pulumi.get(__ret__, 'tags'),
        tail_consumers=pulumi.get(__ret__, 'tail_consumers'),
        updated_on=pulumi.get(__ret__, 'updated_on'),
        worker_id=pulumi.get(__ret__, 'worker_id'))
def get_worker_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                      worker_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkerResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_worker = cloudflare.get_worker(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        worker_id="worker_id")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str worker_id: Identifier for the Worker, which can be ID or name.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['workerId'] = worker_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getWorker:getWorker', __args__, opts=opts, typ=GetWorkerResult)
    return __ret__.apply(lambda __response__: GetWorkerResult(
        account_id=pulumi.get(__response__, 'account_id'),
        created_on=pulumi.get(__response__, 'created_on'),
        id=pulumi.get(__response__, 'id'),
        logpush=pulumi.get(__response__, 'logpush'),
        name=pulumi.get(__response__, 'name'),
        observability=pulumi.get(__response__, 'observability'),
        subdomain=pulumi.get(__response__, 'subdomain'),
        tags=pulumi.get(__response__, 'tags'),
        tail_consumers=pulumi.get(__response__, 'tail_consumers'),
        updated_on=pulumi.get(__response__, 'updated_on'),
        worker_id=pulumi.get(__response__, 'worker_id')))
