# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetWorkerVersionResult',
    'AwaitableGetWorkerVersionResult',
    'get_worker_version',
    'get_worker_version_output',
]

@pulumi.output_type
class GetWorkerVersionResult:
    """
    A collection of values returned by getWorkerVersion.
    """
    def __init__(__self__, account_id=None, annotations=None, assets=None, bindings=None, compatibility_date=None, compatibility_flags=None, created_on=None, id=None, include=None, limits=None, main_module=None, migrations=None, modules=None, number=None, placement=None, source=None, usage_model=None, version_id=None, worker_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if assets and not isinstance(assets, dict):
            raise TypeError("Expected argument 'assets' to be a dict")
        pulumi.set(__self__, "assets", assets)
        if bindings and not isinstance(bindings, list):
            raise TypeError("Expected argument 'bindings' to be a list")
        pulumi.set(__self__, "bindings", bindings)
        if compatibility_date and not isinstance(compatibility_date, str):
            raise TypeError("Expected argument 'compatibility_date' to be a str")
        pulumi.set(__self__, "compatibility_date", compatibility_date)
        if compatibility_flags and not isinstance(compatibility_flags, list):
            raise TypeError("Expected argument 'compatibility_flags' to be a list")
        pulumi.set(__self__, "compatibility_flags", compatibility_flags)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include and not isinstance(include, str):
            raise TypeError("Expected argument 'include' to be a str")
        pulumi.set(__self__, "include", include)
        if limits and not isinstance(limits, dict):
            raise TypeError("Expected argument 'limits' to be a dict")
        pulumi.set(__self__, "limits", limits)
        if main_module and not isinstance(main_module, str):
            raise TypeError("Expected argument 'main_module' to be a str")
        pulumi.set(__self__, "main_module", main_module)
        if migrations and not isinstance(migrations, dict):
            raise TypeError("Expected argument 'migrations' to be a dict")
        pulumi.set(__self__, "migrations", migrations)
        if modules and not isinstance(modules, list):
            raise TypeError("Expected argument 'modules' to be a list")
        pulumi.set(__self__, "modules", modules)
        if number and not isinstance(number, int):
            raise TypeError("Expected argument 'number' to be a int")
        pulumi.set(__self__, "number", number)
        if placement and not isinstance(placement, dict):
            raise TypeError("Expected argument 'placement' to be a dict")
        pulumi.set(__self__, "placement", placement)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if usage_model and not isinstance(usage_model, str):
            raise TypeError("Expected argument 'usage_model' to be a str")
        pulumi.set(__self__, "usage_model", usage_model)
        if version_id and not isinstance(version_id, str):
            raise TypeError("Expected argument 'version_id' to be a str")
        pulumi.set(__self__, "version_id", version_id)
        if worker_id and not isinstance(worker_id, str):
            raise TypeError("Expected argument 'worker_id' to be a str")
        pulumi.set(__self__, "worker_id", worker_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> 'outputs.GetWorkerVersionAnnotationsResult':
        """
        Metadata about the version.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def assets(self) -> 'outputs.GetWorkerVersionAssetsResult':
        """
        Configuration for assets within a Worker.
        """
        return pulumi.get(self, "assets")

    @_builtins.property
    @pulumi.getter
    def bindings(self) -> Sequence['outputs.GetWorkerVersionBindingResult']:
        return pulumi.get(self, "bindings")

    @_builtins.property
    @pulumi.getter(name="compatibilityDate")
    def compatibility_date(self) -> _builtins.str:
        return pulumi.get(self, "compatibility_date")

    @_builtins.property
    @pulumi.getter(name="compatibilityFlags")
    def compatibility_flags(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "compatibility_flags")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> _builtins.str:
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def include(self) -> Optional[_builtins.str]:
        """
        Whether to include the `modules` property of the version in the response, which contains code and sourcemap content and may add several megabytes to the response size.
        Available values: "modules".
        """
        return pulumi.get(self, "include")

    @_builtins.property
    @pulumi.getter
    def limits(self) -> 'outputs.GetWorkerVersionLimitsResult':
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter(name="mainModule")
    def main_module(self) -> _builtins.str:
        return pulumi.get(self, "main_module")

    @_builtins.property
    @pulumi.getter
    def migrations(self) -> 'outputs.GetWorkerVersionMigrationsResult':
        return pulumi.get(self, "migrations")

    @_builtins.property
    @pulumi.getter
    def modules(self) -> Sequence['outputs.GetWorkerVersionModuleResult']:
        return pulumi.get(self, "modules")

    @_builtins.property
    @pulumi.getter
    def number(self) -> _builtins.int:
        return pulumi.get(self, "number")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> 'outputs.GetWorkerVersionPlacementResult':
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="usageModel")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def usage_model(self) -> _builtins.str:
        return pulumi.get(self, "usage_model")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[_builtins.str]:
        """
        Identifier for the version, which can be ID or the literal "latest" to operate on the most recently created version.
        """
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter(name="workerId")
    def worker_id(self) -> _builtins.str:
        """
        Identifier for the Worker, which can be ID or name.
        """
        return pulumi.get(self, "worker_id")


class AwaitableGetWorkerVersionResult(GetWorkerVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkerVersionResult(
            account_id=self.account_id,
            annotations=self.annotations,
            assets=self.assets,
            bindings=self.bindings,
            compatibility_date=self.compatibility_date,
            compatibility_flags=self.compatibility_flags,
            created_on=self.created_on,
            id=self.id,
            include=self.include,
            limits=self.limits,
            main_module=self.main_module,
            migrations=self.migrations,
            modules=self.modules,
            number=self.number,
            placement=self.placement,
            source=self.source,
            usage_model=self.usage_model,
            version_id=self.version_id,
            worker_id=self.worker_id)


def get_worker_version(account_id: Optional[_builtins.str] = None,
                       include: Optional[_builtins.str] = None,
                       version_id: Optional[_builtins.str] = None,
                       worker_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkerVersionResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_worker_version = cloudflare.get_worker_version(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        worker_id="worker_id",
        version_id="version_id",
        include="modules")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str include: Whether to include the `modules` property of the version in the response, which contains code and sourcemap content and may add several megabytes to the response size.
           Available values: "modules".
    :param _builtins.str version_id: Identifier for the version, which can be ID or the literal "latest" to operate on the most recently created version.
    :param _builtins.str worker_id: Identifier for the Worker, which can be ID or name.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['include'] = include
    __args__['versionId'] = version_id
    __args__['workerId'] = worker_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getWorkerVersion:getWorkerVersion', __args__, opts=opts, typ=GetWorkerVersionResult).value

    return AwaitableGetWorkerVersionResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        annotations=pulumi.get(__ret__, 'annotations'),
        assets=pulumi.get(__ret__, 'assets'),
        bindings=pulumi.get(__ret__, 'bindings'),
        compatibility_date=pulumi.get(__ret__, 'compatibility_date'),
        compatibility_flags=pulumi.get(__ret__, 'compatibility_flags'),
        created_on=pulumi.get(__ret__, 'created_on'),
        id=pulumi.get(__ret__, 'id'),
        include=pulumi.get(__ret__, 'include'),
        limits=pulumi.get(__ret__, 'limits'),
        main_module=pulumi.get(__ret__, 'main_module'),
        migrations=pulumi.get(__ret__, 'migrations'),
        modules=pulumi.get(__ret__, 'modules'),
        number=pulumi.get(__ret__, 'number'),
        placement=pulumi.get(__ret__, 'placement'),
        source=pulumi.get(__ret__, 'source'),
        usage_model=pulumi.get(__ret__, 'usage_model'),
        version_id=pulumi.get(__ret__, 'version_id'),
        worker_id=pulumi.get(__ret__, 'worker_id'))
def get_worker_version_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                              include: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              version_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              worker_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkerVersionResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_worker_version = cloudflare.get_worker_version(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        worker_id="worker_id",
        version_id="version_id",
        include="modules")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str include: Whether to include the `modules` property of the version in the response, which contains code and sourcemap content and may add several megabytes to the response size.
           Available values: "modules".
    :param _builtins.str version_id: Identifier for the version, which can be ID or the literal "latest" to operate on the most recently created version.
    :param _builtins.str worker_id: Identifier for the Worker, which can be ID or name.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['include'] = include
    __args__['versionId'] = version_id
    __args__['workerId'] = worker_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getWorkerVersion:getWorkerVersion', __args__, opts=opts, typ=GetWorkerVersionResult)
    return __ret__.apply(lambda __response__: GetWorkerVersionResult(
        account_id=pulumi.get(__response__, 'account_id'),
        annotations=pulumi.get(__response__, 'annotations'),
        assets=pulumi.get(__response__, 'assets'),
        bindings=pulumi.get(__response__, 'bindings'),
        compatibility_date=pulumi.get(__response__, 'compatibility_date'),
        compatibility_flags=pulumi.get(__response__, 'compatibility_flags'),
        created_on=pulumi.get(__response__, 'created_on'),
        id=pulumi.get(__response__, 'id'),
        include=pulumi.get(__response__, 'include'),
        limits=pulumi.get(__response__, 'limits'),
        main_module=pulumi.get(__response__, 'main_module'),
        migrations=pulumi.get(__response__, 'migrations'),
        modules=pulumi.get(__response__, 'modules'),
        number=pulumi.get(__response__, 'number'),
        placement=pulumi.get(__response__, 'placement'),
        source=pulumi.get(__response__, 'source'),
        usage_model=pulumi.get(__response__, 'usage_model'),
        version_id=pulumi.get(__response__, 'version_id'),
        worker_id=pulumi.get(__response__, 'worker_id')))
