# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWorkersCustomDomainResult',
    'AwaitableGetWorkersCustomDomainResult',
    'get_workers_custom_domain',
    'get_workers_custom_domain_output',
]

@pulumi.output_type
class GetWorkersCustomDomainResult:
    """
    A collection of values returned by getWorkersCustomDomain.
    """
    def __init__(__self__, account_id=None, domain_id=None, environment=None, filter=None, hostname=None, id=None, service=None, zone_id=None, zone_name=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service and not isinstance(service, str):
            raise TypeError("Expected argument 'service' to be a str")
        pulumi.set(__self__, "service", service)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)
        if zone_name and not isinstance(zone_name, str):
            raise TypeError("Expected argument 'zone_name' to be a str")
        pulumi.set(__self__, "zone_name", zone_name)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifer of the account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[_builtins.str]:
        """
        Identifer of the Worker Domain.
        """
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> _builtins.str:
        """
        Worker environment associated with the zone and hostname.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetWorkersCustomDomainFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        Hostname of the Worker Domain.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifer of the Worker Domain.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        Worker service associated with the zone and hostname.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        Identifier of the zone.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> _builtins.str:
        """
        Name of the zone.
        """
        return pulumi.get(self, "zone_name")


class AwaitableGetWorkersCustomDomainResult(GetWorkersCustomDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkersCustomDomainResult(
            account_id=self.account_id,
            domain_id=self.domain_id,
            environment=self.environment,
            filter=self.filter,
            hostname=self.hostname,
            id=self.id,
            service=self.service,
            zone_id=self.zone_id,
            zone_name=self.zone_name)


def get_workers_custom_domain(account_id: Optional[_builtins.str] = None,
                              domain_id: Optional[_builtins.str] = None,
                              filter: Optional[Union['GetWorkersCustomDomainFilterArgs', 'GetWorkersCustomDomainFilterArgsDict']] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkersCustomDomainResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_workers_custom_domain = cloudflare.get_workers_custom_domain(account_id="9a7806061c88ada191ed06f989cc3dac",
        domain_id="dbe10b4bc17c295377eabd600e1787fd")
    ```


    :param _builtins.str account_id: Identifer of the account.
    :param _builtins.str domain_id: Identifer of the Worker Domain.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['domainId'] = domain_id
    __args__['filter'] = filter
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getWorkersCustomDomain:getWorkersCustomDomain', __args__, opts=opts, typ=GetWorkersCustomDomainResult).value

    return AwaitableGetWorkersCustomDomainResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        environment=pulumi.get(__ret__, 'environment'),
        filter=pulumi.get(__ret__, 'filter'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        service=pulumi.get(__ret__, 'service'),
        zone_id=pulumi.get(__ret__, 'zone_id'),
        zone_name=pulumi.get(__ret__, 'zone_name'))
def get_workers_custom_domain_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     domain_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     filter: Optional[pulumi.Input[Optional[Union['GetWorkersCustomDomainFilterArgs', 'GetWorkersCustomDomainFilterArgsDict']]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkersCustomDomainResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_workers_custom_domain = cloudflare.get_workers_custom_domain(account_id="9a7806061c88ada191ed06f989cc3dac",
        domain_id="dbe10b4bc17c295377eabd600e1787fd")
    ```


    :param _builtins.str account_id: Identifer of the account.
    :param _builtins.str domain_id: Identifer of the Worker Domain.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['domainId'] = domain_id
    __args__['filter'] = filter
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getWorkersCustomDomain:getWorkersCustomDomain', __args__, opts=opts, typ=GetWorkersCustomDomainResult)
    return __ret__.apply(lambda __response__: GetWorkersCustomDomainResult(
        account_id=pulumi.get(__response__, 'account_id'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        environment=pulumi.get(__response__, 'environment'),
        filter=pulumi.get(__response__, 'filter'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        service=pulumi.get(__response__, 'service'),
        zone_id=pulumi.get(__response__, 'zone_id'),
        zone_name=pulumi.get(__response__, 'zone_name')))
