# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetZeroTrustAccessApplicationResult',
    'AwaitableGetZeroTrustAccessApplicationResult',
    'get_zero_trust_access_application',
    'get_zero_trust_access_application_output',
]

@pulumi.output_type
class GetZeroTrustAccessApplicationResult:
    """
    A collection of values returned by getZeroTrustAccessApplication.
    """
    def __init__(__self__, account_id=None, allow_authenticate_via_warp=None, allow_iframe=None, allowed_idps=None, app_id=None, app_launcher_logo_url=None, app_launcher_visible=None, aud=None, auto_redirect_to_identity=None, bg_color=None, cors_headers=None, custom_deny_message=None, custom_deny_url=None, custom_non_identity_deny_url=None, custom_pages=None, destinations=None, domain=None, enable_binding_cookie=None, filter=None, footer_links=None, header_bg_color=None, http_only_cookie_attribute=None, id=None, landing_page_design=None, logo_url=None, name=None, options_preflight_bypass=None, path_cookie_attribute=None, policies=None, read_service_tokens_from_header=None, saas_app=None, same_site_cookie_attribute=None, scim_config=None, self_hosted_domains=None, service_auth401_redirect=None, session_duration=None, skip_app_launcher_login_page=None, skip_interstitial=None, tags=None, target_criterias=None, type=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if allow_authenticate_via_warp and not isinstance(allow_authenticate_via_warp, bool):
            raise TypeError("Expected argument 'allow_authenticate_via_warp' to be a bool")
        pulumi.set(__self__, "allow_authenticate_via_warp", allow_authenticate_via_warp)
        if allow_iframe and not isinstance(allow_iframe, bool):
            raise TypeError("Expected argument 'allow_iframe' to be a bool")
        pulumi.set(__self__, "allow_iframe", allow_iframe)
        if allowed_idps and not isinstance(allowed_idps, list):
            raise TypeError("Expected argument 'allowed_idps' to be a list")
        pulumi.set(__self__, "allowed_idps", allowed_idps)
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if app_launcher_logo_url and not isinstance(app_launcher_logo_url, str):
            raise TypeError("Expected argument 'app_launcher_logo_url' to be a str")
        pulumi.set(__self__, "app_launcher_logo_url", app_launcher_logo_url)
        if app_launcher_visible and not isinstance(app_launcher_visible, bool):
            raise TypeError("Expected argument 'app_launcher_visible' to be a bool")
        pulumi.set(__self__, "app_launcher_visible", app_launcher_visible)
        if aud and not isinstance(aud, str):
            raise TypeError("Expected argument 'aud' to be a str")
        pulumi.set(__self__, "aud", aud)
        if auto_redirect_to_identity and not isinstance(auto_redirect_to_identity, bool):
            raise TypeError("Expected argument 'auto_redirect_to_identity' to be a bool")
        pulumi.set(__self__, "auto_redirect_to_identity", auto_redirect_to_identity)
        if bg_color and not isinstance(bg_color, str):
            raise TypeError("Expected argument 'bg_color' to be a str")
        pulumi.set(__self__, "bg_color", bg_color)
        if cors_headers and not isinstance(cors_headers, dict):
            raise TypeError("Expected argument 'cors_headers' to be a dict")
        pulumi.set(__self__, "cors_headers", cors_headers)
        if custom_deny_message and not isinstance(custom_deny_message, str):
            raise TypeError("Expected argument 'custom_deny_message' to be a str")
        pulumi.set(__self__, "custom_deny_message", custom_deny_message)
        if custom_deny_url and not isinstance(custom_deny_url, str):
            raise TypeError("Expected argument 'custom_deny_url' to be a str")
        pulumi.set(__self__, "custom_deny_url", custom_deny_url)
        if custom_non_identity_deny_url and not isinstance(custom_non_identity_deny_url, str):
            raise TypeError("Expected argument 'custom_non_identity_deny_url' to be a str")
        pulumi.set(__self__, "custom_non_identity_deny_url", custom_non_identity_deny_url)
        if custom_pages and not isinstance(custom_pages, list):
            raise TypeError("Expected argument 'custom_pages' to be a list")
        pulumi.set(__self__, "custom_pages", custom_pages)
        if destinations and not isinstance(destinations, list):
            raise TypeError("Expected argument 'destinations' to be a list")
        pulumi.set(__self__, "destinations", destinations)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if enable_binding_cookie and not isinstance(enable_binding_cookie, bool):
            raise TypeError("Expected argument 'enable_binding_cookie' to be a bool")
        pulumi.set(__self__, "enable_binding_cookie", enable_binding_cookie)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if footer_links and not isinstance(footer_links, list):
            raise TypeError("Expected argument 'footer_links' to be a list")
        pulumi.set(__self__, "footer_links", footer_links)
        if header_bg_color and not isinstance(header_bg_color, str):
            raise TypeError("Expected argument 'header_bg_color' to be a str")
        pulumi.set(__self__, "header_bg_color", header_bg_color)
        if http_only_cookie_attribute and not isinstance(http_only_cookie_attribute, bool):
            raise TypeError("Expected argument 'http_only_cookie_attribute' to be a bool")
        pulumi.set(__self__, "http_only_cookie_attribute", http_only_cookie_attribute)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if landing_page_design and not isinstance(landing_page_design, dict):
            raise TypeError("Expected argument 'landing_page_design' to be a dict")
        pulumi.set(__self__, "landing_page_design", landing_page_design)
        if logo_url and not isinstance(logo_url, str):
            raise TypeError("Expected argument 'logo_url' to be a str")
        pulumi.set(__self__, "logo_url", logo_url)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if options_preflight_bypass and not isinstance(options_preflight_bypass, bool):
            raise TypeError("Expected argument 'options_preflight_bypass' to be a bool")
        pulumi.set(__self__, "options_preflight_bypass", options_preflight_bypass)
        if path_cookie_attribute and not isinstance(path_cookie_attribute, bool):
            raise TypeError("Expected argument 'path_cookie_attribute' to be a bool")
        pulumi.set(__self__, "path_cookie_attribute", path_cookie_attribute)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if read_service_tokens_from_header and not isinstance(read_service_tokens_from_header, str):
            raise TypeError("Expected argument 'read_service_tokens_from_header' to be a str")
        pulumi.set(__self__, "read_service_tokens_from_header", read_service_tokens_from_header)
        if saas_app and not isinstance(saas_app, dict):
            raise TypeError("Expected argument 'saas_app' to be a dict")
        pulumi.set(__self__, "saas_app", saas_app)
        if same_site_cookie_attribute and not isinstance(same_site_cookie_attribute, str):
            raise TypeError("Expected argument 'same_site_cookie_attribute' to be a str")
        pulumi.set(__self__, "same_site_cookie_attribute", same_site_cookie_attribute)
        if scim_config and not isinstance(scim_config, dict):
            raise TypeError("Expected argument 'scim_config' to be a dict")
        pulumi.set(__self__, "scim_config", scim_config)
        if self_hosted_domains and not isinstance(self_hosted_domains, list):
            raise TypeError("Expected argument 'self_hosted_domains' to be a list")
        pulumi.set(__self__, "self_hosted_domains", self_hosted_domains)
        if service_auth401_redirect and not isinstance(service_auth401_redirect, bool):
            raise TypeError("Expected argument 'service_auth401_redirect' to be a bool")
        pulumi.set(__self__, "service_auth401_redirect", service_auth401_redirect)
        if session_duration and not isinstance(session_duration, str):
            raise TypeError("Expected argument 'session_duration' to be a str")
        pulumi.set(__self__, "session_duration", session_duration)
        if skip_app_launcher_login_page and not isinstance(skip_app_launcher_login_page, bool):
            raise TypeError("Expected argument 'skip_app_launcher_login_page' to be a bool")
        pulumi.set(__self__, "skip_app_launcher_login_page", skip_app_launcher_login_page)
        if skip_interstitial and not isinstance(skip_interstitial, bool):
            raise TypeError("Expected argument 'skip_interstitial' to be a bool")
        pulumi.set(__self__, "skip_interstitial", skip_interstitial)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if target_criterias and not isinstance(target_criterias, list):
            raise TypeError("Expected argument 'target_criterias' to be a list")
        pulumi.set(__self__, "target_criterias", target_criterias)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="allowAuthenticateViaWarp")
    def allow_authenticate_via_warp(self) -> _builtins.bool:
        """
        When set to true, users can authenticate to this application using their WARP session.  When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        """
        return pulumi.get(self, "allow_authenticate_via_warp")

    @_builtins.property
    @pulumi.getter(name="allowIframe")
    def allow_iframe(self) -> _builtins.bool:
        """
        Enables loading application content in an iFrame.
        """
        return pulumi.get(self, "allow_iframe")

    @_builtins.property
    @pulumi.getter(name="allowedIdps")
    def allowed_idps(self) -> Sequence[_builtins.str]:
        """
        The identity providers your users can select when connecting to this application. Defaults to all IdPs configured in your account.
        """
        return pulumi.get(self, "allowed_idps")

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="appLauncherLogoUrl")
    def app_launcher_logo_url(self) -> _builtins.str:
        """
        The image URL of the logo shown in the App Launcher header.
        """
        return pulumi.get(self, "app_launcher_logo_url")

    @_builtins.property
    @pulumi.getter(name="appLauncherVisible")
    def app_launcher_visible(self) -> _builtins.bool:
        """
        Displays the application in the App Launcher.
        """
        return pulumi.get(self, "app_launcher_visible")

    @_builtins.property
    @pulumi.getter
    def aud(self) -> _builtins.str:
        """
        Audience tag.
        """
        return pulumi.get(self, "aud")

    @_builtins.property
    @pulumi.getter(name="autoRedirectToIdentity")
    def auto_redirect_to_identity(self) -> _builtins.bool:
        """
        When set to `true`, users skip the identity provider selection step during login. You must specify only one identity provider in allowed_idps.
        """
        return pulumi.get(self, "auto_redirect_to_identity")

    @_builtins.property
    @pulumi.getter(name="bgColor")
    def bg_color(self) -> _builtins.str:
        """
        The background color of the App Launcher page.
        """
        return pulumi.get(self, "bg_color")

    @_builtins.property
    @pulumi.getter(name="corsHeaders")
    def cors_headers(self) -> 'outputs.GetZeroTrustAccessApplicationCorsHeadersResult':
        return pulumi.get(self, "cors_headers")

    @_builtins.property
    @pulumi.getter(name="customDenyMessage")
    def custom_deny_message(self) -> _builtins.str:
        """
        The custom error message shown to a user when they are denied access to the application.
        """
        return pulumi.get(self, "custom_deny_message")

    @_builtins.property
    @pulumi.getter(name="customDenyUrl")
    def custom_deny_url(self) -> _builtins.str:
        """
        The custom URL a user is redirected to when they are denied access to the application when failing identity-based rules.
        """
        return pulumi.get(self, "custom_deny_url")

    @_builtins.property
    @pulumi.getter(name="customNonIdentityDenyUrl")
    def custom_non_identity_deny_url(self) -> _builtins.str:
        """
        The custom URL a user is redirected to when they are denied access to the application when failing non-identity rules.
        """
        return pulumi.get(self, "custom_non_identity_deny_url")

    @_builtins.property
    @pulumi.getter(name="customPages")
    def custom_pages(self) -> Sequence[_builtins.str]:
        """
        The custom pages that will be displayed when applicable for this application
        """
        return pulumi.get(self, "custom_pages")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.GetZeroTrustAccessApplicationDestinationResult']:
        """
        List of destinations secured by Access. This supersedes `self_hosted_domains` to allow for more flexibility in defining different types of domains. If `destinations` are provided, then `self_hosted_domains` will be ignored.
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The primary hostname and path secured by Access. This domain will be displayed if the app is visible in the App Launcher.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="enableBindingCookie")
    def enable_binding_cookie(self) -> _builtins.bool:
        """
        Enables the binding cookie, which increases security against compromised authorization tokens and CSRF attacks.
        """
        return pulumi.get(self, "enable_binding_cookie")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetZeroTrustAccessApplicationFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="footerLinks")
    def footer_links(self) -> Sequence['outputs.GetZeroTrustAccessApplicationFooterLinkResult']:
        """
        The links in the App Launcher footer.
        """
        return pulumi.get(self, "footer_links")

    @_builtins.property
    @pulumi.getter(name="headerBgColor")
    def header_bg_color(self) -> _builtins.str:
        """
        The background color of the App Launcher header.
        """
        return pulumi.get(self, "header_bg_color")

    @_builtins.property
    @pulumi.getter(name="httpOnlyCookieAttribute")
    def http_only_cookie_attribute(self) -> _builtins.bool:
        """
        Enables the HttpOnly cookie attribute, which increases security against XSS attacks.
        """
        return pulumi.get(self, "http_only_cookie_attribute")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="landingPageDesign")
    def landing_page_design(self) -> 'outputs.GetZeroTrustAccessApplicationLandingPageDesignResult':
        """
        The design of the App Launcher landing page shown to users when they log in.
        """
        return pulumi.get(self, "landing_page_design")

    @_builtins.property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> _builtins.str:
        """
        The image URL for the logo shown in the App Launcher dashboard.
        """
        return pulumi.get(self, "logo_url")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the application.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="optionsPreflightBypass")
    def options_preflight_bypass(self) -> _builtins.bool:
        """
        Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set.
        """
        return pulumi.get(self, "options_preflight_bypass")

    @_builtins.property
    @pulumi.getter(name="pathCookieAttribute")
    def path_cookie_attribute(self) -> _builtins.bool:
        """
        Enables cookie paths to scope an application's JWT to the application path. If disabled, the JWT will scope to the hostname by default
        """
        return pulumi.get(self, "path_cookie_attribute")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetZeroTrustAccessApplicationPolicyResult']:
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter(name="readServiceTokensFromHeader")
    def read_service_tokens_from_header(self) -> _builtins.str:
        """
        Allows matching Access Service Tokens passed HTTP in a single header with this name.
        This works as an alternative to the (CF-Access-Client-Id, CF-Access-Client-Secret) pair of headers.
        The header value will be interpreted as a json object similar to:
        {
        "cf-access-client-id": "88bf3b6d86161464f6509f7219099e57.access.example.com",
        "cf-access-client-secret": "bdd31cbc4dec990953e39163fbbb194c93313ca9f0a6e420346af9d326b1d2a5"
        }
        """
        return pulumi.get(self, "read_service_tokens_from_header")

    @_builtins.property
    @pulumi.getter(name="saasApp")
    def saas_app(self) -> 'outputs.GetZeroTrustAccessApplicationSaasAppResult':
        return pulumi.get(self, "saas_app")

    @_builtins.property
    @pulumi.getter(name="sameSiteCookieAttribute")
    def same_site_cookie_attribute(self) -> _builtins.str:
        """
        Sets the SameSite cookie setting, which provides increased security against CSRF attacks.
        """
        return pulumi.get(self, "same_site_cookie_attribute")

    @_builtins.property
    @pulumi.getter(name="scimConfig")
    def scim_config(self) -> 'outputs.GetZeroTrustAccessApplicationScimConfigResult':
        """
        Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        """
        return pulumi.get(self, "scim_config")

    @_builtins.property
    @pulumi.getter(name="selfHostedDomains")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def self_hosted_domains(self) -> Sequence[_builtins.str]:
        """
        List of public domains that Access will secure. This field is deprecated in favor of `destinations` and will be supported until **November 21, 2025.** If `destinations` are provided, then `self_hosted_domains` will be ignored.
        """
        return pulumi.get(self, "self_hosted_domains")

    @_builtins.property
    @pulumi.getter(name="serviceAuth401Redirect")
    def service_auth401_redirect(self) -> _builtins.bool:
        """
        Returns a 401 status code when the request is blocked by a Service Auth policy.
        """
        return pulumi.get(self, "service_auth401_redirect")

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> _builtins.str:
        """
        The amount of time that tokens issued for this application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h. Note: unsupported for infrastructure type applications.
        """
        return pulumi.get(self, "session_duration")

    @_builtins.property
    @pulumi.getter(name="skipAppLauncherLoginPage")
    def skip_app_launcher_login_page(self) -> _builtins.bool:
        """
        Determines when to skip the App Launcher landing page.
        """
        return pulumi.get(self, "skip_app_launcher_login_page")

    @_builtins.property
    @pulumi.getter(name="skipInterstitial")
    def skip_interstitial(self) -> _builtins.bool:
        """
        Enables automatic authentication through cloudflared.
        """
        return pulumi.get(self, "skip_interstitial")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        The tags you want assigned to an application. Tags are used to filter applications in the App Launcher dashboard.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetCriterias")
    def target_criterias(self) -> Sequence['outputs.GetZeroTrustAccessApplicationTargetCriteriaResult']:
        return pulumi.get(self, "target_criterias")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The application type.
        Available values: "self*hosted", "saas", "ssh", "vnc", "app*launcher", "warp", "biso", "bookmark", "dash_sso", "infrastructure", "rdp".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZeroTrustAccessApplicationResult(GetZeroTrustAccessApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustAccessApplicationResult(
            account_id=self.account_id,
            allow_authenticate_via_warp=self.allow_authenticate_via_warp,
            allow_iframe=self.allow_iframe,
            allowed_idps=self.allowed_idps,
            app_id=self.app_id,
            app_launcher_logo_url=self.app_launcher_logo_url,
            app_launcher_visible=self.app_launcher_visible,
            aud=self.aud,
            auto_redirect_to_identity=self.auto_redirect_to_identity,
            bg_color=self.bg_color,
            cors_headers=self.cors_headers,
            custom_deny_message=self.custom_deny_message,
            custom_deny_url=self.custom_deny_url,
            custom_non_identity_deny_url=self.custom_non_identity_deny_url,
            custom_pages=self.custom_pages,
            destinations=self.destinations,
            domain=self.domain,
            enable_binding_cookie=self.enable_binding_cookie,
            filter=self.filter,
            footer_links=self.footer_links,
            header_bg_color=self.header_bg_color,
            http_only_cookie_attribute=self.http_only_cookie_attribute,
            id=self.id,
            landing_page_design=self.landing_page_design,
            logo_url=self.logo_url,
            name=self.name,
            options_preflight_bypass=self.options_preflight_bypass,
            path_cookie_attribute=self.path_cookie_attribute,
            policies=self.policies,
            read_service_tokens_from_header=self.read_service_tokens_from_header,
            saas_app=self.saas_app,
            same_site_cookie_attribute=self.same_site_cookie_attribute,
            scim_config=self.scim_config,
            self_hosted_domains=self.self_hosted_domains,
            service_auth401_redirect=self.service_auth401_redirect,
            session_duration=self.session_duration,
            skip_app_launcher_login_page=self.skip_app_launcher_login_page,
            skip_interstitial=self.skip_interstitial,
            tags=self.tags,
            target_criterias=self.target_criterias,
            type=self.type,
            zone_id=self.zone_id)


def get_zero_trust_access_application(account_id: Optional[_builtins.str] = None,
                                      app_id: Optional[_builtins.str] = None,
                                      filter: Optional[Union['GetZeroTrustAccessApplicationFilterArgs', 'GetZeroTrustAccessApplicationFilterArgsDict']] = None,
                                      zone_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustAccessApplicationResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_application = cloudflare.get_zero_trust_access_application(app_id="023e105f4ecef8ad9ca31a8372d0c353",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param _builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param _builtins.str app_id: Identifier.
    :param _builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['appId'] = app_id
    __args__['filter'] = filter
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustAccessApplication:getZeroTrustAccessApplication', __args__, opts=opts, typ=GetZeroTrustAccessApplicationResult).value

    return AwaitableGetZeroTrustAccessApplicationResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        allow_authenticate_via_warp=pulumi.get(__ret__, 'allow_authenticate_via_warp'),
        allow_iframe=pulumi.get(__ret__, 'allow_iframe'),
        allowed_idps=pulumi.get(__ret__, 'allowed_idps'),
        app_id=pulumi.get(__ret__, 'app_id'),
        app_launcher_logo_url=pulumi.get(__ret__, 'app_launcher_logo_url'),
        app_launcher_visible=pulumi.get(__ret__, 'app_launcher_visible'),
        aud=pulumi.get(__ret__, 'aud'),
        auto_redirect_to_identity=pulumi.get(__ret__, 'auto_redirect_to_identity'),
        bg_color=pulumi.get(__ret__, 'bg_color'),
        cors_headers=pulumi.get(__ret__, 'cors_headers'),
        custom_deny_message=pulumi.get(__ret__, 'custom_deny_message'),
        custom_deny_url=pulumi.get(__ret__, 'custom_deny_url'),
        custom_non_identity_deny_url=pulumi.get(__ret__, 'custom_non_identity_deny_url'),
        custom_pages=pulumi.get(__ret__, 'custom_pages'),
        destinations=pulumi.get(__ret__, 'destinations'),
        domain=pulumi.get(__ret__, 'domain'),
        enable_binding_cookie=pulumi.get(__ret__, 'enable_binding_cookie'),
        filter=pulumi.get(__ret__, 'filter'),
        footer_links=pulumi.get(__ret__, 'footer_links'),
        header_bg_color=pulumi.get(__ret__, 'header_bg_color'),
        http_only_cookie_attribute=pulumi.get(__ret__, 'http_only_cookie_attribute'),
        id=pulumi.get(__ret__, 'id'),
        landing_page_design=pulumi.get(__ret__, 'landing_page_design'),
        logo_url=pulumi.get(__ret__, 'logo_url'),
        name=pulumi.get(__ret__, 'name'),
        options_preflight_bypass=pulumi.get(__ret__, 'options_preflight_bypass'),
        path_cookie_attribute=pulumi.get(__ret__, 'path_cookie_attribute'),
        policies=pulumi.get(__ret__, 'policies'),
        read_service_tokens_from_header=pulumi.get(__ret__, 'read_service_tokens_from_header'),
        saas_app=pulumi.get(__ret__, 'saas_app'),
        same_site_cookie_attribute=pulumi.get(__ret__, 'same_site_cookie_attribute'),
        scim_config=pulumi.get(__ret__, 'scim_config'),
        self_hosted_domains=pulumi.get(__ret__, 'self_hosted_domains'),
        service_auth401_redirect=pulumi.get(__ret__, 'service_auth401_redirect'),
        session_duration=pulumi.get(__ret__, 'session_duration'),
        skip_app_launcher_login_page=pulumi.get(__ret__, 'skip_app_launcher_login_page'),
        skip_interstitial=pulumi.get(__ret__, 'skip_interstitial'),
        tags=pulumi.get(__ret__, 'tags'),
        target_criterias=pulumi.get(__ret__, 'target_criterias'),
        type=pulumi.get(__ret__, 'type'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zero_trust_access_application_output(account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             app_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             filter: Optional[pulumi.Input[Optional[Union['GetZeroTrustAccessApplicationFilterArgs', 'GetZeroTrustAccessApplicationFilterArgsDict']]]] = None,
                                             zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustAccessApplicationResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_application = cloudflare.get_zero_trust_access_application(app_id="023e105f4ecef8ad9ca31a8372d0c353",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param _builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param _builtins.str app_id: Identifier.
    :param _builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['appId'] = app_id
    __args__['filter'] = filter
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustAccessApplication:getZeroTrustAccessApplication', __args__, opts=opts, typ=GetZeroTrustAccessApplicationResult)
    return __ret__.apply(lambda __response__: GetZeroTrustAccessApplicationResult(
        account_id=pulumi.get(__response__, 'account_id'),
        allow_authenticate_via_warp=pulumi.get(__response__, 'allow_authenticate_via_warp'),
        allow_iframe=pulumi.get(__response__, 'allow_iframe'),
        allowed_idps=pulumi.get(__response__, 'allowed_idps'),
        app_id=pulumi.get(__response__, 'app_id'),
        app_launcher_logo_url=pulumi.get(__response__, 'app_launcher_logo_url'),
        app_launcher_visible=pulumi.get(__response__, 'app_launcher_visible'),
        aud=pulumi.get(__response__, 'aud'),
        auto_redirect_to_identity=pulumi.get(__response__, 'auto_redirect_to_identity'),
        bg_color=pulumi.get(__response__, 'bg_color'),
        cors_headers=pulumi.get(__response__, 'cors_headers'),
        custom_deny_message=pulumi.get(__response__, 'custom_deny_message'),
        custom_deny_url=pulumi.get(__response__, 'custom_deny_url'),
        custom_non_identity_deny_url=pulumi.get(__response__, 'custom_non_identity_deny_url'),
        custom_pages=pulumi.get(__response__, 'custom_pages'),
        destinations=pulumi.get(__response__, 'destinations'),
        domain=pulumi.get(__response__, 'domain'),
        enable_binding_cookie=pulumi.get(__response__, 'enable_binding_cookie'),
        filter=pulumi.get(__response__, 'filter'),
        footer_links=pulumi.get(__response__, 'footer_links'),
        header_bg_color=pulumi.get(__response__, 'header_bg_color'),
        http_only_cookie_attribute=pulumi.get(__response__, 'http_only_cookie_attribute'),
        id=pulumi.get(__response__, 'id'),
        landing_page_design=pulumi.get(__response__, 'landing_page_design'),
        logo_url=pulumi.get(__response__, 'logo_url'),
        name=pulumi.get(__response__, 'name'),
        options_preflight_bypass=pulumi.get(__response__, 'options_preflight_bypass'),
        path_cookie_attribute=pulumi.get(__response__, 'path_cookie_attribute'),
        policies=pulumi.get(__response__, 'policies'),
        read_service_tokens_from_header=pulumi.get(__response__, 'read_service_tokens_from_header'),
        saas_app=pulumi.get(__response__, 'saas_app'),
        same_site_cookie_attribute=pulumi.get(__response__, 'same_site_cookie_attribute'),
        scim_config=pulumi.get(__response__, 'scim_config'),
        self_hosted_domains=pulumi.get(__response__, 'self_hosted_domains'),
        service_auth401_redirect=pulumi.get(__response__, 'service_auth401_redirect'),
        session_duration=pulumi.get(__response__, 'session_duration'),
        skip_app_launcher_login_page=pulumi.get(__response__, 'skip_app_launcher_login_page'),
        skip_interstitial=pulumi.get(__response__, 'skip_interstitial'),
        tags=pulumi.get(__response__, 'tags'),
        target_criterias=pulumi.get(__response__, 'target_criterias'),
        type=pulumi.get(__response__, 'type'),
        zone_id=pulumi.get(__response__, 'zone_id')))
