# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZeroTrustAccessInfrastructureTargetsResult',
    'AwaitableGetZeroTrustAccessInfrastructureTargetsResult',
    'get_zero_trust_access_infrastructure_targets',
    'get_zero_trust_access_infrastructure_targets_output',
]

@pulumi.output_type
class GetZeroTrustAccessInfrastructureTargetsResult:
    """
    A collection of values returned by getZeroTrustAccessInfrastructureTargets.
    """
    def __init__(__self__, account_id=None, created_after=None, created_before=None, direction=None, hostname=None, hostname_contains=None, id=None, ip_like=None, ip_v4=None, ip_v6=None, ips=None, ipv4_end=None, ipv4_start=None, ipv6_end=None, ipv6_start=None, max_items=None, modified_after=None, modified_before=None, order=None, results=None, target_ids=None, virtual_network_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if created_after and not isinstance(created_after, str):
            raise TypeError("Expected argument 'created_after' to be a str")
        pulumi.set(__self__, "created_after", created_after)
        if created_before and not isinstance(created_before, str):
            raise TypeError("Expected argument 'created_before' to be a str")
        pulumi.set(__self__, "created_before", created_before)
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if hostname_contains and not isinstance(hostname_contains, str):
            raise TypeError("Expected argument 'hostname_contains' to be a str")
        pulumi.set(__self__, "hostname_contains", hostname_contains)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_like and not isinstance(ip_like, str):
            raise TypeError("Expected argument 'ip_like' to be a str")
        pulumi.set(__self__, "ip_like", ip_like)
        if ip_v4 and not isinstance(ip_v4, str):
            raise TypeError("Expected argument 'ip_v4' to be a str")
        pulumi.set(__self__, "ip_v4", ip_v4)
        if ip_v6 and not isinstance(ip_v6, str):
            raise TypeError("Expected argument 'ip_v6' to be a str")
        pulumi.set(__self__, "ip_v6", ip_v6)
        if ips and not isinstance(ips, list):
            raise TypeError("Expected argument 'ips' to be a list")
        pulumi.set(__self__, "ips", ips)
        if ipv4_end and not isinstance(ipv4_end, str):
            raise TypeError("Expected argument 'ipv4_end' to be a str")
        pulumi.set(__self__, "ipv4_end", ipv4_end)
        if ipv4_start and not isinstance(ipv4_start, str):
            raise TypeError("Expected argument 'ipv4_start' to be a str")
        pulumi.set(__self__, "ipv4_start", ipv4_start)
        if ipv6_end and not isinstance(ipv6_end, str):
            raise TypeError("Expected argument 'ipv6_end' to be a str")
        pulumi.set(__self__, "ipv6_end", ipv6_end)
        if ipv6_start and not isinstance(ipv6_start, str):
            raise TypeError("Expected argument 'ipv6_start' to be a str")
        pulumi.set(__self__, "ipv6_start", ipv6_start)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if modified_after and not isinstance(modified_after, str):
            raise TypeError("Expected argument 'modified_after' to be a str")
        pulumi.set(__self__, "modified_after", modified_after)
        if modified_before and not isinstance(modified_before, str):
            raise TypeError("Expected argument 'modified_before' to be a str")
        pulumi.set(__self__, "modified_before", modified_before)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if target_ids and not isinstance(target_ids, list):
            raise TypeError("Expected argument 'target_ids' to be a list")
        pulumi.set(__self__, "target_ids", target_ids)
        if virtual_network_id and not isinstance(virtual_network_id, str):
            raise TypeError("Expected argument 'virtual_network_id' to be a str")
        pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account identifier
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="createdAfter")
    def created_after(self) -> Optional[_builtins.str]:
        """
        Date and time at which the target was created after (inclusive)
        """
        return pulumi.get(self, "created_after")

    @_builtins.property
    @pulumi.getter(name="createdBefore")
    def created_before(self) -> Optional[_builtins.str]:
        """
        Date and time at which the target was created before (inclusive)
        """
        return pulumi.get(self, "created_before")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[_builtins.str]:
        """
        The sorting direction.
        Available values: "asc", "desc".
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname of a target
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="hostnameContains")
    def hostname_contains(self) -> Optional[_builtins.str]:
        """
        Partial match to the hostname of a target
        """
        return pulumi.get(self, "hostname_contains")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipLike")
    def ip_like(self) -> Optional[_builtins.str]:
        """
        Filters for targets whose IP addresses look like the specified string.
        Supports `*` as a wildcard character
        """
        return pulumi.get(self, "ip_like")

    @_builtins.property
    @pulumi.getter(name="ipV4")
    def ip_v4(self) -> Optional[_builtins.str]:
        """
        IPv4 address of the target
        """
        return pulumi.get(self, "ip_v4")

    @_builtins.property
    @pulumi.getter(name="ipV6")
    def ip_v6(self) -> Optional[_builtins.str]:
        """
        IPv6 address of the target
        """
        return pulumi.get(self, "ip_v6")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        Filters for targets that have any of the following IP addresses. Specify
        `ips` multiple times in query parameter to build list of candidates.
        """
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter(name="ipv4End")
    def ipv4_end(self) -> Optional[_builtins.str]:
        """
        Defines an IPv4 filter range's ending value (inclusive). Requires
        `ipv4_start` to be specified as well.
        """
        return pulumi.get(self, "ipv4_end")

    @_builtins.property
    @pulumi.getter(name="ipv4Start")
    def ipv4_start(self) -> Optional[_builtins.str]:
        """
        Defines an IPv4 filter range's starting value (inclusive). Requires
        `ipv4_end` to be specified as well.
        """
        return pulumi.get(self, "ipv4_start")

    @_builtins.property
    @pulumi.getter(name="ipv6End")
    def ipv6_end(self) -> Optional[_builtins.str]:
        """
        Defines an IPv6 filter range's ending value (inclusive). Requires
        `ipv6_start` to be specified as well.
        """
        return pulumi.get(self, "ipv6_end")

    @_builtins.property
    @pulumi.getter(name="ipv6Start")
    def ipv6_start(self) -> Optional[_builtins.str]:
        """
        Defines an IPv6 filter range's starting value (inclusive). Requires
        `ipv6_end` to be specified as well.
        """
        return pulumi.get(self, "ipv6_start")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter(name="modifiedAfter")
    def modified_after(self) -> Optional[_builtins.str]:
        """
        Date and time at which the target was modified after (inclusive)
        """
        return pulumi.get(self, "modified_after")

    @_builtins.property
    @pulumi.getter(name="modifiedBefore")
    def modified_before(self) -> Optional[_builtins.str]:
        """
        Date and time at which the target was modified before (inclusive)
        """
        return pulumi.get(self, "modified_before")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.str]:
        """
        The field to sort by.
        Available values: "hostname", "created_at".
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetZeroTrustAccessInfrastructureTargetsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter(name="targetIds")
    def target_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Filters for targets that have any of the following UUIDs. Specify
        `target_ids` multiple times in query parameter to build list of
        candidates.
        """
        return pulumi.get(self, "target_ids")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[_builtins.str]:
        """
        Private virtual network identifier of the target
        """
        return pulumi.get(self, "virtual_network_id")


class AwaitableGetZeroTrustAccessInfrastructureTargetsResult(GetZeroTrustAccessInfrastructureTargetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustAccessInfrastructureTargetsResult(
            account_id=self.account_id,
            created_after=self.created_after,
            created_before=self.created_before,
            direction=self.direction,
            hostname=self.hostname,
            hostname_contains=self.hostname_contains,
            id=self.id,
            ip_like=self.ip_like,
            ip_v4=self.ip_v4,
            ip_v6=self.ip_v6,
            ips=self.ips,
            ipv4_end=self.ipv4_end,
            ipv4_start=self.ipv4_start,
            ipv6_end=self.ipv6_end,
            ipv6_start=self.ipv6_start,
            max_items=self.max_items,
            modified_after=self.modified_after,
            modified_before=self.modified_before,
            order=self.order,
            results=self.results,
            target_ids=self.target_ids,
            virtual_network_id=self.virtual_network_id)


def get_zero_trust_access_infrastructure_targets(account_id: Optional[_builtins.str] = None,
                                                 created_after: Optional[_builtins.str] = None,
                                                 created_before: Optional[_builtins.str] = None,
                                                 direction: Optional[_builtins.str] = None,
                                                 hostname: Optional[_builtins.str] = None,
                                                 hostname_contains: Optional[_builtins.str] = None,
                                                 ip_like: Optional[_builtins.str] = None,
                                                 ip_v4: Optional[_builtins.str] = None,
                                                 ip_v6: Optional[_builtins.str] = None,
                                                 ips: Optional[Sequence[_builtins.str]] = None,
                                                 ipv4_end: Optional[_builtins.str] = None,
                                                 ipv4_start: Optional[_builtins.str] = None,
                                                 ipv6_end: Optional[_builtins.str] = None,
                                                 ipv6_start: Optional[_builtins.str] = None,
                                                 max_items: Optional[_builtins.int] = None,
                                                 modified_after: Optional[_builtins.str] = None,
                                                 modified_before: Optional[_builtins.str] = None,
                                                 order: Optional[_builtins.str] = None,
                                                 target_ids: Optional[Sequence[_builtins.str]] = None,
                                                 virtual_network_id: Optional[_builtins.str] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustAccessInfrastructureTargetsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_infrastructure_targets = cloudflare.get_zero_trust_access_infrastructure_targets(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        created_after="2019-12-27T18:11:19.117Z",
        created_before="2019-12-27T18:11:19.117Z",
        direction="asc",
        hostname="hostname",
        hostname_contains="hostname_contains",
        ip_like="ip_like",
        ip_v4="ip_v4",
        ip_v6="ip_v6",
        ips=["string"],
        ipv4_end="ipv4_end",
        ipv4_start="ipv4_start",
        ipv6_end="ipv6_end",
        ipv6_start="ipv6_start",
        modified_after="2019-12-27T18:11:19.117Z",
        modified_before="2019-12-27T18:11:19.117Z",
        order="hostname",
        target_ids=["182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e"],
        virtual_network_id="182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e")
    ```


    :param _builtins.str account_id: Account identifier
    :param _builtins.str created_after: Date and time at which the target was created after (inclusive)
    :param _builtins.str created_before: Date and time at which the target was created before (inclusive)
    :param _builtins.str direction: The sorting direction.
           Available values: "asc", "desc".
    :param _builtins.str hostname: Hostname of a target
    :param _builtins.str hostname_contains: Partial match to the hostname of a target
    :param _builtins.str ip_like: Filters for targets whose IP addresses look like the specified string.
           Supports `*` as a wildcard character
    :param _builtins.str ip_v4: IPv4 address of the target
    :param _builtins.str ip_v6: IPv6 address of the target
    :param Sequence[_builtins.str] ips: Filters for targets that have any of the following IP addresses. Specify
           `ips` multiple times in query parameter to build list of candidates.
    :param _builtins.str ipv4_end: Defines an IPv4 filter range's ending value (inclusive). Requires
           `ipv4_start` to be specified as well.
    :param _builtins.str ipv4_start: Defines an IPv4 filter range's starting value (inclusive). Requires
           `ipv4_end` to be specified as well.
    :param _builtins.str ipv6_end: Defines an IPv6 filter range's ending value (inclusive). Requires
           `ipv6_start` to be specified as well.
    :param _builtins.str ipv6_start: Defines an IPv6 filter range's starting value (inclusive). Requires
           `ipv6_end` to be specified as well.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str modified_after: Date and time at which the target was modified after (inclusive)
    :param _builtins.str modified_before: Date and time at which the target was modified before (inclusive)
    :param _builtins.str order: The field to sort by.
           Available values: "hostname", "created_at".
    :param Sequence[_builtins.str] target_ids: Filters for targets that have any of the following UUIDs. Specify
           `target_ids` multiple times in query parameter to build list of
           candidates.
    :param _builtins.str virtual_network_id: Private virtual network identifier of the target
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['createdAfter'] = created_after
    __args__['createdBefore'] = created_before
    __args__['direction'] = direction
    __args__['hostname'] = hostname
    __args__['hostnameContains'] = hostname_contains
    __args__['ipLike'] = ip_like
    __args__['ipV4'] = ip_v4
    __args__['ipV6'] = ip_v6
    __args__['ips'] = ips
    __args__['ipv4End'] = ipv4_end
    __args__['ipv4Start'] = ipv4_start
    __args__['ipv6End'] = ipv6_end
    __args__['ipv6Start'] = ipv6_start
    __args__['maxItems'] = max_items
    __args__['modifiedAfter'] = modified_after
    __args__['modifiedBefore'] = modified_before
    __args__['order'] = order
    __args__['targetIds'] = target_ids
    __args__['virtualNetworkId'] = virtual_network_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustAccessInfrastructureTargets:getZeroTrustAccessInfrastructureTargets', __args__, opts=opts, typ=GetZeroTrustAccessInfrastructureTargetsResult).value

    return AwaitableGetZeroTrustAccessInfrastructureTargetsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        created_after=pulumi.get(__ret__, 'created_after'),
        created_before=pulumi.get(__ret__, 'created_before'),
        direction=pulumi.get(__ret__, 'direction'),
        hostname=pulumi.get(__ret__, 'hostname'),
        hostname_contains=pulumi.get(__ret__, 'hostname_contains'),
        id=pulumi.get(__ret__, 'id'),
        ip_like=pulumi.get(__ret__, 'ip_like'),
        ip_v4=pulumi.get(__ret__, 'ip_v4'),
        ip_v6=pulumi.get(__ret__, 'ip_v6'),
        ips=pulumi.get(__ret__, 'ips'),
        ipv4_end=pulumi.get(__ret__, 'ipv4_end'),
        ipv4_start=pulumi.get(__ret__, 'ipv4_start'),
        ipv6_end=pulumi.get(__ret__, 'ipv6_end'),
        ipv6_start=pulumi.get(__ret__, 'ipv6_start'),
        max_items=pulumi.get(__ret__, 'max_items'),
        modified_after=pulumi.get(__ret__, 'modified_after'),
        modified_before=pulumi.get(__ret__, 'modified_before'),
        order=pulumi.get(__ret__, 'order'),
        results=pulumi.get(__ret__, 'results'),
        target_ids=pulumi.get(__ret__, 'target_ids'),
        virtual_network_id=pulumi.get(__ret__, 'virtual_network_id'))
def get_zero_trust_access_infrastructure_targets_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                        created_after: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        created_before: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        direction: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        hostname: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        hostname_contains: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        ip_like: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        ip_v4: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        ip_v6: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        ips: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                                        ipv4_end: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        ipv4_start: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        ipv6_end: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        ipv6_start: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                        modified_after: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        modified_before: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        order: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        target_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                                        virtual_network_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustAccessInfrastructureTargetsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_infrastructure_targets = cloudflare.get_zero_trust_access_infrastructure_targets(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        created_after="2019-12-27T18:11:19.117Z",
        created_before="2019-12-27T18:11:19.117Z",
        direction="asc",
        hostname="hostname",
        hostname_contains="hostname_contains",
        ip_like="ip_like",
        ip_v4="ip_v4",
        ip_v6="ip_v6",
        ips=["string"],
        ipv4_end="ipv4_end",
        ipv4_start="ipv4_start",
        ipv6_end="ipv6_end",
        ipv6_start="ipv6_start",
        modified_after="2019-12-27T18:11:19.117Z",
        modified_before="2019-12-27T18:11:19.117Z",
        order="hostname",
        target_ids=["182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e"],
        virtual_network_id="182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e")
    ```


    :param _builtins.str account_id: Account identifier
    :param _builtins.str created_after: Date and time at which the target was created after (inclusive)
    :param _builtins.str created_before: Date and time at which the target was created before (inclusive)
    :param _builtins.str direction: The sorting direction.
           Available values: "asc", "desc".
    :param _builtins.str hostname: Hostname of a target
    :param _builtins.str hostname_contains: Partial match to the hostname of a target
    :param _builtins.str ip_like: Filters for targets whose IP addresses look like the specified string.
           Supports `*` as a wildcard character
    :param _builtins.str ip_v4: IPv4 address of the target
    :param _builtins.str ip_v6: IPv6 address of the target
    :param Sequence[_builtins.str] ips: Filters for targets that have any of the following IP addresses. Specify
           `ips` multiple times in query parameter to build list of candidates.
    :param _builtins.str ipv4_end: Defines an IPv4 filter range's ending value (inclusive). Requires
           `ipv4_start` to be specified as well.
    :param _builtins.str ipv4_start: Defines an IPv4 filter range's starting value (inclusive). Requires
           `ipv4_end` to be specified as well.
    :param _builtins.str ipv6_end: Defines an IPv6 filter range's ending value (inclusive). Requires
           `ipv6_start` to be specified as well.
    :param _builtins.str ipv6_start: Defines an IPv6 filter range's starting value (inclusive). Requires
           `ipv6_end` to be specified as well.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str modified_after: Date and time at which the target was modified after (inclusive)
    :param _builtins.str modified_before: Date and time at which the target was modified before (inclusive)
    :param _builtins.str order: The field to sort by.
           Available values: "hostname", "created_at".
    :param Sequence[_builtins.str] target_ids: Filters for targets that have any of the following UUIDs. Specify
           `target_ids` multiple times in query parameter to build list of
           candidates.
    :param _builtins.str virtual_network_id: Private virtual network identifier of the target
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['createdAfter'] = created_after
    __args__['createdBefore'] = created_before
    __args__['direction'] = direction
    __args__['hostname'] = hostname
    __args__['hostnameContains'] = hostname_contains
    __args__['ipLike'] = ip_like
    __args__['ipV4'] = ip_v4
    __args__['ipV6'] = ip_v6
    __args__['ips'] = ips
    __args__['ipv4End'] = ipv4_end
    __args__['ipv4Start'] = ipv4_start
    __args__['ipv6End'] = ipv6_end
    __args__['ipv6Start'] = ipv6_start
    __args__['maxItems'] = max_items
    __args__['modifiedAfter'] = modified_after
    __args__['modifiedBefore'] = modified_before
    __args__['order'] = order
    __args__['targetIds'] = target_ids
    __args__['virtualNetworkId'] = virtual_network_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustAccessInfrastructureTargets:getZeroTrustAccessInfrastructureTargets', __args__, opts=opts, typ=GetZeroTrustAccessInfrastructureTargetsResult)
    return __ret__.apply(lambda __response__: GetZeroTrustAccessInfrastructureTargetsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        created_after=pulumi.get(__response__, 'created_after'),
        created_before=pulumi.get(__response__, 'created_before'),
        direction=pulumi.get(__response__, 'direction'),
        hostname=pulumi.get(__response__, 'hostname'),
        hostname_contains=pulumi.get(__response__, 'hostname_contains'),
        id=pulumi.get(__response__, 'id'),
        ip_like=pulumi.get(__response__, 'ip_like'),
        ip_v4=pulumi.get(__response__, 'ip_v4'),
        ip_v6=pulumi.get(__response__, 'ip_v6'),
        ips=pulumi.get(__response__, 'ips'),
        ipv4_end=pulumi.get(__response__, 'ipv4_end'),
        ipv4_start=pulumi.get(__response__, 'ipv4_start'),
        ipv6_end=pulumi.get(__response__, 'ipv6_end'),
        ipv6_start=pulumi.get(__response__, 'ipv6_start'),
        max_items=pulumi.get(__response__, 'max_items'),
        modified_after=pulumi.get(__response__, 'modified_after'),
        modified_before=pulumi.get(__response__, 'modified_before'),
        order=pulumi.get(__response__, 'order'),
        results=pulumi.get(__response__, 'results'),
        target_ids=pulumi.get(__response__, 'target_ids'),
        virtual_network_id=pulumi.get(__response__, 'virtual_network_id')))
