# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetZeroTrustAccessServiceTokenResult',
    'AwaitableGetZeroTrustAccessServiceTokenResult',
    'get_zero_trust_access_service_token',
    'get_zero_trust_access_service_token_output',
]

@pulumi.output_type
class GetZeroTrustAccessServiceTokenResult:
    """
    A collection of values returned by getZeroTrustAccessServiceToken.
    """
    def __init__(__self__, account_id=None, client_id=None, duration=None, expires_at=None, filter=None, id=None, name=None, service_token_id=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if duration and not isinstance(duration, str):
            raise TypeError("Expected argument 'duration' to be a str")
        pulumi.set(__self__, "duration", duration)
        if expires_at and not isinstance(expires_at, str):
            raise TypeError("Expected argument 'expires_at' to be a str")
        pulumi.set(__self__, "expires_at", expires_at)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if service_token_id and not isinstance(service_token_id, str):
            raise TypeError("Expected argument 'service_token_id' to be a str")
        pulumi.set(__self__, "service_token_id", service_token_id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The Client ID for the service token. Access will check for this value in the `CF-Access-Client-ID` request header.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        The duration for how long the service token will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h. The default is 1 year in hours (8760h).
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> _builtins.str:
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetZeroTrustAccessServiceTokenFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        UUID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the service token.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceTokenId")
    def service_token_id(self) -> Optional[_builtins.str]:
        """
        UUID.
        """
        return pulumi.get(self, "service_token_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZeroTrustAccessServiceTokenResult(GetZeroTrustAccessServiceTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustAccessServiceTokenResult(
            account_id=self.account_id,
            client_id=self.client_id,
            duration=self.duration,
            expires_at=self.expires_at,
            filter=self.filter,
            id=self.id,
            name=self.name,
            service_token_id=self.service_token_id,
            zone_id=self.zone_id)


def get_zero_trust_access_service_token(account_id: Optional[_builtins.str] = None,
                                        filter: Optional[Union['GetZeroTrustAccessServiceTokenFilterArgs', 'GetZeroTrustAccessServiceTokenFilterArgsDict']] = None,
                                        service_token_id: Optional[_builtins.str] = None,
                                        zone_id: Optional[_builtins.str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustAccessServiceTokenResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_service_token = cloudflare.get_zero_trust_access_service_token(service_token_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param _builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param _builtins.str service_token_id: UUID.
    :param _builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['serviceTokenId'] = service_token_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustAccessServiceToken:getZeroTrustAccessServiceToken', __args__, opts=opts, typ=GetZeroTrustAccessServiceTokenResult).value

    return AwaitableGetZeroTrustAccessServiceTokenResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        client_id=pulumi.get(__ret__, 'client_id'),
        duration=pulumi.get(__ret__, 'duration'),
        expires_at=pulumi.get(__ret__, 'expires_at'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        service_token_id=pulumi.get(__ret__, 'service_token_id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zero_trust_access_service_token_output(account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               filter: Optional[pulumi.Input[Optional[Union['GetZeroTrustAccessServiceTokenFilterArgs', 'GetZeroTrustAccessServiceTokenFilterArgsDict']]]] = None,
                                               service_token_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustAccessServiceTokenResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_service_token = cloudflare.get_zero_trust_access_service_token(service_token_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param _builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param _builtins.str service_token_id: UUID.
    :param _builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['serviceTokenId'] = service_token_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustAccessServiceToken:getZeroTrustAccessServiceToken', __args__, opts=opts, typ=GetZeroTrustAccessServiceTokenResult)
    return __ret__.apply(lambda __response__: GetZeroTrustAccessServiceTokenResult(
        account_id=pulumi.get(__response__, 'account_id'),
        client_id=pulumi.get(__response__, 'client_id'),
        duration=pulumi.get(__response__, 'duration'),
        expires_at=pulumi.get(__response__, 'expires_at'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        service_token_id=pulumi.get(__response__, 'service_token_id'),
        zone_id=pulumi.get(__response__, 'zone_id')))
