# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetZeroTrustAccessTagResult',
    'AwaitableGetZeroTrustAccessTagResult',
    'get_zero_trust_access_tag',
    'get_zero_trust_access_tag_output',
]

@pulumi.output_type
class GetZeroTrustAccessTagResult:
    """
    A collection of values returned by getZeroTrustAccessTag.
    """
    def __init__(__self__, account_id=None, id=None, name=None, tag_name=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tag_name and not isinstance(tag_name, str):
            raise TypeError("Expected argument 'tag_name' to be a str")
        pulumi.set(__self__, "tag_name", tag_name)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The name of the tag
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the tag
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[_builtins.str]:
        """
        The name of the tag
        """
        return pulumi.get(self, "tag_name")


class AwaitableGetZeroTrustAccessTagResult(GetZeroTrustAccessTagResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustAccessTagResult(
            account_id=self.account_id,
            id=self.id,
            name=self.name,
            tag_name=self.tag_name)


def get_zero_trust_access_tag(account_id: Optional[_builtins.str] = None,
                              tag_name: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustAccessTagResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_tag = cloudflare.get_zero_trust_access_tag(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        tag_name="engineers")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str tag_name: The name of the tag
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['tagName'] = tag_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustAccessTag:getZeroTrustAccessTag', __args__, opts=opts, typ=GetZeroTrustAccessTagResult).value

    return AwaitableGetZeroTrustAccessTagResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        tag_name=pulumi.get(__ret__, 'tag_name'))
def get_zero_trust_access_tag_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     tag_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustAccessTagResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_access_tag = cloudflare.get_zero_trust_access_tag(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        tag_name="engineers")
    ```


    :param _builtins.str account_id: Identifier.
    :param _builtins.str tag_name: The name of the tag
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['tagName'] = tag_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustAccessTag:getZeroTrustAccessTag', __args__, opts=opts, typ=GetZeroTrustAccessTagResult)
    return __ret__.apply(lambda __response__: GetZeroTrustAccessTagResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        tag_name=pulumi.get(__response__, 'tag_name')))
