# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetZeroTrustNetworkHostnameRouteResult',
    'AwaitableGetZeroTrustNetworkHostnameRouteResult',
    'get_zero_trust_network_hostname_route',
    'get_zero_trust_network_hostname_route_output',
]

@pulumi.output_type
class GetZeroTrustNetworkHostnameRouteResult:
    """
    A collection of values returned by getZeroTrustNetworkHostnameRoute.
    """
    def __init__(__self__, account_id=None, comment=None, created_at=None, deleted_at=None, filter=None, hostname=None, hostname_route_id=None, id=None, tunnel_id=None, tunnel_name=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deleted_at and not isinstance(deleted_at, str):
            raise TypeError("Expected argument 'deleted_at' to be a str")
        pulumi.set(__self__, "deleted_at", deleted_at)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if hostname_route_id and not isinstance(hostname_route_id, str):
            raise TypeError("Expected argument 'hostname_route_id' to be a str")
        pulumi.set(__self__, "hostname_route_id", hostname_route_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tunnel_id and not isinstance(tunnel_id, str):
            raise TypeError("Expected argument 'tunnel_id' to be a str")
        pulumi.set(__self__, "tunnel_id", tunnel_id)
        if tunnel_name and not isinstance(tunnel_name, str):
            raise TypeError("Expected argument 'tunnel_name' to be a str")
        pulumi.set(__self__, "tunnel_name", tunnel_name)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        An optional description of the hostname route.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Timestamp of when the resource was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletedAt")
    def deleted_at(self) -> _builtins.str:
        """
        Timestamp of when the resource was deleted. If `null`, the resource has not been deleted.
        """
        return pulumi.get(self, "deleted_at")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetZeroTrustNetworkHostnameRouteFilterResult']:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname of the route.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="hostnameRouteId")
    def hostname_route_id(self) -> Optional[_builtins.str]:
        """
        The hostname route ID.
        """
        return pulumi.get(self, "hostname_route_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The hostname route ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> _builtins.str:
        """
        UUID of the tunnel.
        """
        return pulumi.get(self, "tunnel_id")

    @_builtins.property
    @pulumi.getter(name="tunnelName")
    def tunnel_name(self) -> _builtins.str:
        """
        A user-friendly name for a tunnel.
        """
        return pulumi.get(self, "tunnel_name")


class AwaitableGetZeroTrustNetworkHostnameRouteResult(GetZeroTrustNetworkHostnameRouteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustNetworkHostnameRouteResult(
            account_id=self.account_id,
            comment=self.comment,
            created_at=self.created_at,
            deleted_at=self.deleted_at,
            filter=self.filter,
            hostname=self.hostname,
            hostname_route_id=self.hostname_route_id,
            id=self.id,
            tunnel_id=self.tunnel_id,
            tunnel_name=self.tunnel_name)


def get_zero_trust_network_hostname_route(account_id: Optional[_builtins.str] = None,
                                          filter: Optional[Union['GetZeroTrustNetworkHostnameRouteFilterArgs', 'GetZeroTrustNetworkHostnameRouteFilterArgsDict']] = None,
                                          hostname_route_id: Optional[_builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustNetworkHostnameRouteResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_network_hostname_route = cloudflare.get_zero_trust_network_hostname_route(account_id="699d98642c564d2e855e9661899b7252",
        hostname_route_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str account_id: Cloudflare account ID
    :param _builtins.str hostname_route_id: The hostname route ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['hostnameRouteId'] = hostname_route_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustNetworkHostnameRoute:getZeroTrustNetworkHostnameRoute', __args__, opts=opts, typ=GetZeroTrustNetworkHostnameRouteResult).value

    return AwaitableGetZeroTrustNetworkHostnameRouteResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        comment=pulumi.get(__ret__, 'comment'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deleted_at=pulumi.get(__ret__, 'deleted_at'),
        filter=pulumi.get(__ret__, 'filter'),
        hostname=pulumi.get(__ret__, 'hostname'),
        hostname_route_id=pulumi.get(__ret__, 'hostname_route_id'),
        id=pulumi.get(__ret__, 'id'),
        tunnel_id=pulumi.get(__ret__, 'tunnel_id'),
        tunnel_name=pulumi.get(__ret__, 'tunnel_name'))
def get_zero_trust_network_hostname_route_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                 filter: Optional[pulumi.Input[Optional[Union['GetZeroTrustNetworkHostnameRouteFilterArgs', 'GetZeroTrustNetworkHostnameRouteFilterArgsDict']]]] = None,
                                                 hostname_route_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustNetworkHostnameRouteResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_network_hostname_route = cloudflare.get_zero_trust_network_hostname_route(account_id="699d98642c564d2e855e9661899b7252",
        hostname_route_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str account_id: Cloudflare account ID
    :param _builtins.str hostname_route_id: The hostname route ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['hostnameRouteId'] = hostname_route_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustNetworkHostnameRoute:getZeroTrustNetworkHostnameRoute', __args__, opts=opts, typ=GetZeroTrustNetworkHostnameRouteResult)
    return __ret__.apply(lambda __response__: GetZeroTrustNetworkHostnameRouteResult(
        account_id=pulumi.get(__response__, 'account_id'),
        comment=pulumi.get(__response__, 'comment'),
        created_at=pulumi.get(__response__, 'created_at'),
        deleted_at=pulumi.get(__response__, 'deleted_at'),
        filter=pulumi.get(__response__, 'filter'),
        hostname=pulumi.get(__response__, 'hostname'),
        hostname_route_id=pulumi.get(__response__, 'hostname_route_id'),
        id=pulumi.get(__response__, 'id'),
        tunnel_id=pulumi.get(__response__, 'tunnel_id'),
        tunnel_name=pulumi.get(__response__, 'tunnel_name')))
