# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZeroTrustNetworkHostnameRoutesResult',
    'AwaitableGetZeroTrustNetworkHostnameRoutesResult',
    'get_zero_trust_network_hostname_routes',
    'get_zero_trust_network_hostname_routes_output',
]

@pulumi.output_type
class GetZeroTrustNetworkHostnameRoutesResult:
    """
    A collection of values returned by getZeroTrustNetworkHostnameRoutes.
    """
    def __init__(__self__, account_id=None, comment=None, existed_at=None, hostname=None, id=None, is_deleted=None, max_items=None, results=None, tunnel_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if existed_at and not isinstance(existed_at, str):
            raise TypeError("Expected argument 'existed_at' to be a str")
        pulumi.set(__self__, "existed_at", existed_at)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_deleted and not isinstance(is_deleted, bool):
            raise TypeError("Expected argument 'is_deleted' to be a bool")
        pulumi.set(__self__, "is_deleted", is_deleted)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if tunnel_id and not isinstance(tunnel_id, str):
            raise TypeError("Expected argument 'tunnel_id' to be a str")
        pulumi.set(__self__, "tunnel_id", tunnel_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[_builtins.str]:
        """
        If set, only list hostname routes with the given comment.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="existedAt")
    def existed_at(self) -> Optional[_builtins.str]:
        """
        If provided, include only resources that were created (and not deleted) before this time. URL encoded.
        """
        return pulumi.get(self, "existed_at")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        If set, only list hostname routes that contain a substring of the given value, the filter is case-insensitive.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The hostname route ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDeleted")
    def is_deleted(self) -> _builtins.bool:
        """
        If `true`, only return deleted hostname routes. If `false`, exclude deleted hostname routes.
        """
        return pulumi.get(self, "is_deleted")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetZeroTrustNetworkHostnameRoutesResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> Optional[_builtins.str]:
        """
        If set, only list hostname routes that point to a specific tunnel.
        """
        return pulumi.get(self, "tunnel_id")


class AwaitableGetZeroTrustNetworkHostnameRoutesResult(GetZeroTrustNetworkHostnameRoutesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustNetworkHostnameRoutesResult(
            account_id=self.account_id,
            comment=self.comment,
            existed_at=self.existed_at,
            hostname=self.hostname,
            id=self.id,
            is_deleted=self.is_deleted,
            max_items=self.max_items,
            results=self.results,
            tunnel_id=self.tunnel_id)


def get_zero_trust_network_hostname_routes(account_id: Optional[_builtins.str] = None,
                                           comment: Optional[_builtins.str] = None,
                                           existed_at: Optional[_builtins.str] = None,
                                           hostname: Optional[_builtins.str] = None,
                                           id: Optional[_builtins.str] = None,
                                           is_deleted: Optional[_builtins.bool] = None,
                                           max_items: Optional[_builtins.int] = None,
                                           tunnel_id: Optional[_builtins.str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustNetworkHostnameRoutesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_network_hostname_routes = cloudflare.get_zero_trust_network_hostname_routes(account_id="699d98642c564d2e855e9661899b7252",
        id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
        comment="example%20comment",
        existed_at="2019-10-12T07%3A20%3A50.52Z",
        hostname="office-1.local",
        tunnel_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str account_id: Cloudflare account ID
    :param _builtins.str comment: If set, only list hostname routes with the given comment.
    :param _builtins.str existed_at: If provided, include only resources that were created (and not deleted) before this time. URL encoded.
    :param _builtins.str hostname: If set, only list hostname routes that contain a substring of the given value, the filter is case-insensitive.
    :param _builtins.str id: The hostname route ID.
    :param _builtins.bool is_deleted: If `true`, only return deleted hostname routes. If `false`, exclude deleted hostname routes.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str tunnel_id: If set, only list hostname routes that point to a specific tunnel.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['comment'] = comment
    __args__['existedAt'] = existed_at
    __args__['hostname'] = hostname
    __args__['id'] = id
    __args__['isDeleted'] = is_deleted
    __args__['maxItems'] = max_items
    __args__['tunnelId'] = tunnel_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustNetworkHostnameRoutes:getZeroTrustNetworkHostnameRoutes', __args__, opts=opts, typ=GetZeroTrustNetworkHostnameRoutesResult).value

    return AwaitableGetZeroTrustNetworkHostnameRoutesResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        comment=pulumi.get(__ret__, 'comment'),
        existed_at=pulumi.get(__ret__, 'existed_at'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        is_deleted=pulumi.get(__ret__, 'is_deleted'),
        max_items=pulumi.get(__ret__, 'max_items'),
        results=pulumi.get(__ret__, 'results'),
        tunnel_id=pulumi.get(__ret__, 'tunnel_id'))
def get_zero_trust_network_hostname_routes_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                  comment: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                  existed_at: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                  hostname: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                  id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                  is_deleted: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                                  max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                  tunnel_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustNetworkHostnameRoutesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_network_hostname_routes = cloudflare.get_zero_trust_network_hostname_routes(account_id="699d98642c564d2e855e9661899b7252",
        id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
        comment="example%20comment",
        existed_at="2019-10-12T07%3A20%3A50.52Z",
        hostname="office-1.local",
        tunnel_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415")
    ```


    :param _builtins.str account_id: Cloudflare account ID
    :param _builtins.str comment: If set, only list hostname routes with the given comment.
    :param _builtins.str existed_at: If provided, include only resources that were created (and not deleted) before this time. URL encoded.
    :param _builtins.str hostname: If set, only list hostname routes that contain a substring of the given value, the filter is case-insensitive.
    :param _builtins.str id: The hostname route ID.
    :param _builtins.bool is_deleted: If `true`, only return deleted hostname routes. If `false`, exclude deleted hostname routes.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str tunnel_id: If set, only list hostname routes that point to a specific tunnel.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['comment'] = comment
    __args__['existedAt'] = existed_at
    __args__['hostname'] = hostname
    __args__['id'] = id
    __args__['isDeleted'] = is_deleted
    __args__['maxItems'] = max_items
    __args__['tunnelId'] = tunnel_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustNetworkHostnameRoutes:getZeroTrustNetworkHostnameRoutes', __args__, opts=opts, typ=GetZeroTrustNetworkHostnameRoutesResult)
    return __ret__.apply(lambda __response__: GetZeroTrustNetworkHostnameRoutesResult(
        account_id=pulumi.get(__response__, 'account_id'),
        comment=pulumi.get(__response__, 'comment'),
        existed_at=pulumi.get(__response__, 'existed_at'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        is_deleted=pulumi.get(__response__, 'is_deleted'),
        max_items=pulumi.get(__response__, 'max_items'),
        results=pulumi.get(__response__, 'results'),
        tunnel_id=pulumi.get(__response__, 'tunnel_id')))
