# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZeroTrustTunnelCloudflaredVirtualNetworksResult',
    'AwaitableGetZeroTrustTunnelCloudflaredVirtualNetworksResult',
    'get_zero_trust_tunnel_cloudflared_virtual_networks',
    'get_zero_trust_tunnel_cloudflared_virtual_networks_output',
]

@pulumi.output_type
class GetZeroTrustTunnelCloudflaredVirtualNetworksResult:
    """
    A collection of values returned by getZeroTrustTunnelCloudflaredVirtualNetworks.
    """
    def __init__(__self__, account_id=None, id=None, is_default=None, is_default_network=None, is_deleted=None, max_items=None, name=None, results=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if is_default_network and not isinstance(is_default_network, bool):
            raise TypeError("Expected argument 'is_default_network' to be a bool")
        pulumi.set(__self__, "is_default_network", is_default_network)
        if is_deleted and not isinstance(is_deleted, bool):
            raise TypeError("Expected argument 'is_deleted' to be a bool")
        pulumi.set(__self__, "is_deleted", is_deleted)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        UUID of the virtual network.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[_builtins.bool]:
        """
        If `true`, only include the default virtual network. If `false`, exclude the default virtual network. If empty, all virtual networks will be included.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter(name="isDefaultNetwork")
    def is_default_network(self) -> Optional[_builtins.bool]:
        """
        If `true`, only include the default virtual network. If `false`, exclude the default virtual network. If empty, all virtual networks will be included.
        """
        return pulumi.get(self, "is_default_network")

    @_builtins.property
    @pulumi.getter(name="isDeleted")
    def is_deleted(self) -> Optional[_builtins.bool]:
        """
        If `true`, only include deleted virtual networks. If `false`, exclude deleted virtual networks. If empty, all virtual networks will be included.
        """
        return pulumi.get(self, "is_deleted")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name for the virtual network.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetZeroTrustTunnelCloudflaredVirtualNetworksResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")


class AwaitableGetZeroTrustTunnelCloudflaredVirtualNetworksResult(GetZeroTrustTunnelCloudflaredVirtualNetworksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustTunnelCloudflaredVirtualNetworksResult(
            account_id=self.account_id,
            id=self.id,
            is_default=self.is_default,
            is_default_network=self.is_default_network,
            is_deleted=self.is_deleted,
            max_items=self.max_items,
            name=self.name,
            results=self.results)


def get_zero_trust_tunnel_cloudflared_virtual_networks(account_id: Optional[_builtins.str] = None,
                                                       id: Optional[_builtins.str] = None,
                                                       is_default: Optional[_builtins.bool] = None,
                                                       is_default_network: Optional[_builtins.bool] = None,
                                                       is_deleted: Optional[_builtins.bool] = None,
                                                       max_items: Optional[_builtins.int] = None,
                                                       name: Optional[_builtins.str] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustTunnelCloudflaredVirtualNetworksResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_tunnel_cloudflared_virtual_networks = cloudflare.get_zero_trust_tunnel_cloudflared_virtual_networks(account_id="699d98642c564d2e855e9661899b7252",
        id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
        is_default=True,
        is_default_network=True,
        is_deleted=True,
        name="us-east-1-vpc")
    ```


    :param _builtins.str account_id: Cloudflare account ID
    :param _builtins.str id: UUID of the virtual network.
    :param _builtins.bool is_default: If `true`, only include the default virtual network. If `false`, exclude the default virtual network. If empty, all virtual networks will be included.
    :param _builtins.bool is_default_network: If `true`, only include the default virtual network. If `false`, exclude the default virtual network. If empty, all virtual networks will be included.
    :param _builtins.bool is_deleted: If `true`, only include deleted virtual networks. If `false`, exclude deleted virtual networks. If empty, all virtual networks will be included.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str name: A user-friendly name for the virtual network.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['id'] = id
    __args__['isDefault'] = is_default
    __args__['isDefaultNetwork'] = is_default_network
    __args__['isDeleted'] = is_deleted
    __args__['maxItems'] = max_items
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustTunnelCloudflaredVirtualNetworks:getZeroTrustTunnelCloudflaredVirtualNetworks', __args__, opts=opts, typ=GetZeroTrustTunnelCloudflaredVirtualNetworksResult).value

    return AwaitableGetZeroTrustTunnelCloudflaredVirtualNetworksResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        is_default_network=pulumi.get(__ret__, 'is_default_network'),
        is_deleted=pulumi.get(__ret__, 'is_deleted'),
        max_items=pulumi.get(__ret__, 'max_items'),
        name=pulumi.get(__ret__, 'name'),
        results=pulumi.get(__ret__, 'results'))
def get_zero_trust_tunnel_cloudflared_virtual_networks_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                              id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                              is_default: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                                              is_default_network: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                                              is_deleted: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                                              max_items: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustTunnelCloudflaredVirtualNetworksResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_tunnel_cloudflared_virtual_networks = cloudflare.get_zero_trust_tunnel_cloudflared_virtual_networks(account_id="699d98642c564d2e855e9661899b7252",
        id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
        is_default=True,
        is_default_network=True,
        is_deleted=True,
        name="us-east-1-vpc")
    ```


    :param _builtins.str account_id: Cloudflare account ID
    :param _builtins.str id: UUID of the virtual network.
    :param _builtins.bool is_default: If `true`, only include the default virtual network. If `false`, exclude the default virtual network. If empty, all virtual networks will be included.
    :param _builtins.bool is_default_network: If `true`, only include the default virtual network. If `false`, exclude the default virtual network. If empty, all virtual networks will be included.
    :param _builtins.bool is_deleted: If `true`, only include deleted virtual networks. If `false`, exclude deleted virtual networks. If empty, all virtual networks will be included.
    :param _builtins.int max_items: Max items to fetch, default: 1000
    :param _builtins.str name: A user-friendly name for the virtual network.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['id'] = id
    __args__['isDefault'] = is_default
    __args__['isDefaultNetwork'] = is_default_network
    __args__['isDeleted'] = is_deleted
    __args__['maxItems'] = max_items
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustTunnelCloudflaredVirtualNetworks:getZeroTrustTunnelCloudflaredVirtualNetworks', __args__, opts=opts, typ=GetZeroTrustTunnelCloudflaredVirtualNetworksResult)
    return __ret__.apply(lambda __response__: GetZeroTrustTunnelCloudflaredVirtualNetworksResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        is_default=pulumi.get(__response__, 'is_default'),
        is_default_network=pulumi.get(__response__, 'is_default_network'),
        is_deleted=pulumi.get(__response__, 'is_deleted'),
        max_items=pulumi.get(__response__, 'max_items'),
        name=pulumi.get(__response__, 'name'),
        results=pulumi.get(__response__, 'results')))
