# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListItemInitArgs', 'ListItem']

@pulumi.input_type
class ListItemInitArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 list_id: pulumi.Input[_builtins.str],
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input['ListItemHostnameArgs']] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect: Optional[pulumi.Input['ListItemRedirectArgs']] = None):
        """
        The set of arguments for constructing a ListItem resource.
        :param pulumi.Input[_builtins.str] account_id: The Account ID for this resource.
        :param pulumi.Input[_builtins.str] list_id: The unique ID of the list.
        :param pulumi.Input[_builtins.int] asn: A non-negative 32 bit integer
        :param pulumi.Input[_builtins.str] comment: An informative summary of the list item.
        :param pulumi.Input['ListItemHostnameArgs'] hostname: Valid characters for hostnames are ASCII(7) letters from a to z, the digits from 0 to 9, wildcards (*), and the hyphen (-).
        :param pulumi.Input[_builtins.str] ip: An IPv4 address, an IPv4 CIDR, an IPv6 address, or an IPv6 CIDR.
        :param pulumi.Input['ListItemRedirectArgs'] redirect: The definition of the redirect.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "list_id", list_id)
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Account ID for this resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="listId")
    def list_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique ID of the list.
        """
        return pulumi.get(self, "list_id")

    @list_id.setter
    def list_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "list_id", value)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A non-negative 32 bit integer
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "asn", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An informative summary of the list item.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input['ListItemHostnameArgs']]:
        """
        Valid characters for hostnames are ASCII(7) letters from a to z, the digits from 0 to 9, wildcards (*), and the hyphen (-).
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input['ListItemHostnameArgs']]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An IPv4 address, an IPv4 CIDR, an IPv6 address, or an IPv6 CIDR.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter
    def redirect(self) -> Optional[pulumi.Input['ListItemRedirectArgs']]:
        """
        The definition of the redirect.
        """
        return pulumi.get(self, "redirect")

    @redirect.setter
    def redirect(self, value: Optional[pulumi.Input['ListItemRedirectArgs']]):
        pulumi.set(self, "redirect", value)


@pulumi.input_type
class _ListItemState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input['ListItemHostnameArgs']] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect: Optional[pulumi.Input['ListItemRedirectArgs']] = None):
        """
        Input properties used for looking up and filtering ListItem resources.
        :param pulumi.Input[_builtins.str] account_id: The Account ID for this resource.
        :param pulumi.Input[_builtins.int] asn: A non-negative 32 bit integer
        :param pulumi.Input[_builtins.str] comment: An informative summary of the list item.
        :param pulumi.Input[_builtins.str] created_on: The RFC 3339 timestamp of when the item was created.
        :param pulumi.Input['ListItemHostnameArgs'] hostname: Valid characters for hostnames are ASCII(7) letters from a to z, the digits from 0 to 9, wildcards (*), and the hyphen (-).
        :param pulumi.Input[_builtins.str] ip: An IPv4 address, an IPv4 CIDR, an IPv6 address, or an IPv6 CIDR.
        :param pulumi.Input[_builtins.str] list_id: The unique ID of the list.
        :param pulumi.Input[_builtins.str] modified_on: The RFC 3339 timestamp of when the item was last modified.
        :param pulumi.Input[_builtins.str] operation_id: The unique operation ID of the asynchronous action.
        :param pulumi.Input['ListItemRedirectArgs'] redirect: The definition of the redirect.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if list_id is not None:
            pulumi.set(__self__, "list_id", list_id)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Account ID for this resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A non-negative 32 bit integer
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "asn", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An informative summary of the list item.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RFC 3339 timestamp of when the item was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input['ListItemHostnameArgs']]:
        """
        Valid characters for hostnames are ASCII(7) letters from a to z, the digits from 0 to 9, wildcards (*), and the hyphen (-).
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input['ListItemHostnameArgs']]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An IPv4 address, an IPv4 CIDR, an IPv6 address, or an IPv6 CIDR.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="listId")
    def list_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID of the list.
        """
        return pulumi.get(self, "list_id")

    @list_id.setter
    def list_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "list_id", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RFC 3339 timestamp of when the item was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique operation ID of the asynchronous action.
        """
        return pulumi.get(self, "operation_id")

    @operation_id.setter
    def operation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_id", value)

    @_builtins.property
    @pulumi.getter
    def redirect(self) -> Optional[pulumi.Input['ListItemRedirectArgs']]:
        """
        The definition of the redirect.
        """
        return pulumi.get(self, "redirect")

    @redirect.setter
    def redirect(self, value: Optional[pulumi.Input['ListItemRedirectArgs']]):
        pulumi.set(self, "redirect", value)


@pulumi.type_token("cloudflare:index/listItem:ListItem")
class ListItem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[Union['ListItemHostnameArgs', 'ListItemHostnameArgsDict']]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect: Optional[pulumi.Input[Union['ListItemRedirectArgs', 'ListItemRedirectArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_list_item = cloudflare.ListItem("example_list_item",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            list_id="2c0fc9fa937b11eaa1b71c4d701ab86e",
            ip="10.0.0.1")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/listItem:ListItem example '<account_id>/<list_id>/<item_id>'
        ```

        ```sh
        $ pulumi import cloudflare:index/listItem:ListItem example '<account_id>/<list_id>/<item_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The Account ID for this resource.
        :param pulumi.Input[_builtins.int] asn: A non-negative 32 bit integer
        :param pulumi.Input[_builtins.str] comment: An informative summary of the list item.
        :param pulumi.Input[Union['ListItemHostnameArgs', 'ListItemHostnameArgsDict']] hostname: Valid characters for hostnames are ASCII(7) letters from a to z, the digits from 0 to 9, wildcards (*), and the hyphen (-).
        :param pulumi.Input[_builtins.str] ip: An IPv4 address, an IPv4 CIDR, an IPv6 address, or an IPv6 CIDR.
        :param pulumi.Input[_builtins.str] list_id: The unique ID of the list.
        :param pulumi.Input[Union['ListItemRedirectArgs', 'ListItemRedirectArgsDict']] redirect: The definition of the redirect.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListItemInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_list_item = cloudflare.ListItem("example_list_item",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            list_id="2c0fc9fa937b11eaa1b71c4d701ab86e",
            ip="10.0.0.1")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/listItem:ListItem example '<account_id>/<list_id>/<item_id>'
        ```

        ```sh
        $ pulumi import cloudflare:index/listItem:ListItem example '<account_id>/<list_id>/<item_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ListItemInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListItemInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 asn: Optional[pulumi.Input[_builtins.int]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[Union['ListItemHostnameArgs', 'ListItemHostnameArgsDict']]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect: Optional[pulumi.Input[Union['ListItemRedirectArgs', 'ListItemRedirectArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListItemInitArgs.__new__(ListItemInitArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["asn"] = asn
            __props__.__dict__["comment"] = comment
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["ip"] = ip
            if list_id is None and not opts.urn:
                raise TypeError("Missing required property 'list_id'")
            __props__.__dict__["list_id"] = list_id
            __props__.__dict__["redirect"] = redirect
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["operation_id"] = None
        super(ListItem, __self__).__init__(
            'cloudflare:index/listItem:ListItem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            asn: Optional[pulumi.Input[_builtins.int]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            hostname: Optional[pulumi.Input[Union['ListItemHostnameArgs', 'ListItemHostnameArgsDict']]] = None,
            ip: Optional[pulumi.Input[_builtins.str]] = None,
            list_id: Optional[pulumi.Input[_builtins.str]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            operation_id: Optional[pulumi.Input[_builtins.str]] = None,
            redirect: Optional[pulumi.Input[Union['ListItemRedirectArgs', 'ListItemRedirectArgsDict']]] = None) -> 'ListItem':
        """
        Get an existing ListItem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The Account ID for this resource.
        :param pulumi.Input[_builtins.int] asn: A non-negative 32 bit integer
        :param pulumi.Input[_builtins.str] comment: An informative summary of the list item.
        :param pulumi.Input[_builtins.str] created_on: The RFC 3339 timestamp of when the item was created.
        :param pulumi.Input[Union['ListItemHostnameArgs', 'ListItemHostnameArgsDict']] hostname: Valid characters for hostnames are ASCII(7) letters from a to z, the digits from 0 to 9, wildcards (*), and the hyphen (-).
        :param pulumi.Input[_builtins.str] ip: An IPv4 address, an IPv4 CIDR, an IPv6 address, or an IPv6 CIDR.
        :param pulumi.Input[_builtins.str] list_id: The unique ID of the list.
        :param pulumi.Input[_builtins.str] modified_on: The RFC 3339 timestamp of when the item was last modified.
        :param pulumi.Input[_builtins.str] operation_id: The unique operation ID of the asynchronous action.
        :param pulumi.Input[Union['ListItemRedirectArgs', 'ListItemRedirectArgsDict']] redirect: The definition of the redirect.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListItemState.__new__(_ListItemState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["asn"] = asn
        __props__.__dict__["comment"] = comment
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["ip"] = ip
        __props__.__dict__["list_id"] = list_id
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["operation_id"] = operation_id
        __props__.__dict__["redirect"] = redirect
        return ListItem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Account ID for this resource.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def asn(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        A non-negative 32 bit integer
        """
        return pulumi.get(self, "asn")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An informative summary of the list item.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        The RFC 3339 timestamp of when the item was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[Optional['outputs.ListItemHostname']]:
        """
        Valid characters for hostnames are ASCII(7) letters from a to z, the digits from 0 to 9, wildcards (*), and the hyphen (-).
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An IPv4 address, an IPv4 CIDR, an IPv6 address, or an IPv6 CIDR.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="listId")
    def list_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique ID of the list.
        """
        return pulumi.get(self, "list_id")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        The RFC 3339 timestamp of when the item was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique operation ID of the asynchronous action.
        """
        return pulumi.get(self, "operation_id")

    @_builtins.property
    @pulumi.getter
    def redirect(self) -> pulumi.Output[Optional['outputs.ListItemRedirect']]:
        """
        The definition of the redirect.
        """
        return pulumi.get(self, "redirect")

