# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MagicTransitSiteArgs', 'MagicTransitSite']

@pulumi.input_type
class MagicTransitSiteArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input['MagicTransitSiteLocationArgs']] = None,
                 secondary_connector_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MagicTransitSite resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.str] name: The name of the site.
        :param pulumi.Input[_builtins.str] connector_id: Magic Connector identifier tag.
        :param pulumi.Input[_builtins.bool] ha_mode: Site high availability mode. If set to true, the site can have two connectors and runs in high availability mode.
        :param pulumi.Input['MagicTransitSiteLocationArgs'] location: Location of site in latitude and longitude.
        :param pulumi.Input[_builtins.str] secondary_connector_id: Magic Connector identifier tag. Used when high availability mode is on.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        if connector_id is not None:
            pulumi.set(__self__, "connector_id", connector_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ha_mode is not None:
            pulumi.set(__self__, "ha_mode", ha_mode)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if secondary_connector_id is not None:
            pulumi.set(__self__, "secondary_connector_id", secondary_connector_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the site.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Magic Connector identifier tag.
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="haMode")
    def ha_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Site high availability mode. If set to true, the site can have two connectors and runs in high availability mode.
        """
        return pulumi.get(self, "ha_mode")

    @ha_mode.setter
    def ha_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ha_mode", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['MagicTransitSiteLocationArgs']]:
        """
        Location of site in latitude and longitude.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['MagicTransitSiteLocationArgs']]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="secondaryConnectorId")
    def secondary_connector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Magic Connector identifier tag. Used when high availability mode is on.
        """
        return pulumi.get(self, "secondary_connector_id")

    @secondary_connector_id.setter
    def secondary_connector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_connector_id", value)


@pulumi.input_type
class _MagicTransitSiteState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input['MagicTransitSiteLocationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_connector_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MagicTransitSite resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.str] connector_id: Magic Connector identifier tag.
        :param pulumi.Input[_builtins.bool] ha_mode: Site high availability mode. If set to true, the site can have two connectors and runs in high availability mode.
        :param pulumi.Input['MagicTransitSiteLocationArgs'] location: Location of site in latitude and longitude.
        :param pulumi.Input[_builtins.str] name: The name of the site.
        :param pulumi.Input[_builtins.str] secondary_connector_id: Magic Connector identifier tag. Used when high availability mode is on.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if connector_id is not None:
            pulumi.set(__self__, "connector_id", connector_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ha_mode is not None:
            pulumi.set(__self__, "ha_mode", ha_mode)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secondary_connector_id is not None:
            pulumi.set(__self__, "secondary_connector_id", secondary_connector_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Magic Connector identifier tag.
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="haMode")
    def ha_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Site high availability mode. If set to true, the site can have two connectors and runs in high availability mode.
        """
        return pulumi.get(self, "ha_mode")

    @ha_mode.setter
    def ha_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ha_mode", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['MagicTransitSiteLocationArgs']]:
        """
        Location of site in latitude and longitude.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['MagicTransitSiteLocationArgs']]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the site.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="secondaryConnectorId")
    def secondary_connector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Magic Connector identifier tag. Used when high availability mode is on.
        """
        return pulumi.get(self, "secondary_connector_id")

    @secondary_connector_id.setter
    def secondary_connector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_connector_id", value)


@pulumi.type_token("cloudflare:index/magicTransitSite:MagicTransitSite")
class MagicTransitSite(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[Union['MagicTransitSiteLocationArgs', 'MagicTransitSiteLocationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_magic_transit_site = cloudflare.MagicTransitSite("example_magic_transit_site",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            name="site_1",
            connector_id="ac60d3d0435248289d446cedd870bcf4",
            description="description",
            ha_mode=True,
            location={
                "lat": "37.6192",
                "lon": "122.3816",
            },
            secondary_connector_id="8d67040d3835dbcf46ce29da440dc482")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicTransitSite:MagicTransitSite example '<account_id>/<site_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.str] connector_id: Magic Connector identifier tag.
        :param pulumi.Input[_builtins.bool] ha_mode: Site high availability mode. If set to true, the site can have two connectors and runs in high availability mode.
        :param pulumi.Input[Union['MagicTransitSiteLocationArgs', 'MagicTransitSiteLocationArgsDict']] location: Location of site in latitude and longitude.
        :param pulumi.Input[_builtins.str] name: The name of the site.
        :param pulumi.Input[_builtins.str] secondary_connector_id: Magic Connector identifier tag. Used when high availability mode is on.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MagicTransitSiteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_magic_transit_site = cloudflare.MagicTransitSite("example_magic_transit_site",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            name="site_1",
            connector_id="ac60d3d0435248289d446cedd870bcf4",
            description="description",
            ha_mode=True,
            location={
                "lat": "37.6192",
                "lon": "122.3816",
            },
            secondary_connector_id="8d67040d3835dbcf46ce29da440dc482")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicTransitSite:MagicTransitSite example '<account_id>/<site_id>'
        ```

        :param str resource_name: The name of the resource.
        :param MagicTransitSiteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MagicTransitSiteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[Union['MagicTransitSiteLocationArgs', 'MagicTransitSiteLocationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MagicTransitSiteArgs.__new__(MagicTransitSiteArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["connector_id"] = connector_id
            __props__.__dict__["description"] = description
            __props__.__dict__["ha_mode"] = ha_mode
            __props__.__dict__["location"] = location
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["secondary_connector_id"] = secondary_connector_id
        super(MagicTransitSite, __self__).__init__(
            'cloudflare:index/magicTransitSite:MagicTransitSite',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            connector_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ha_mode: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[Union['MagicTransitSiteLocationArgs', 'MagicTransitSiteLocationArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_connector_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'MagicTransitSite':
        """
        Get an existing MagicTransitSite resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier
        :param pulumi.Input[_builtins.str] connector_id: Magic Connector identifier tag.
        :param pulumi.Input[_builtins.bool] ha_mode: Site high availability mode. If set to true, the site can have two connectors and runs in high availability mode.
        :param pulumi.Input[Union['MagicTransitSiteLocationArgs', 'MagicTransitSiteLocationArgsDict']] location: Location of site in latitude and longitude.
        :param pulumi.Input[_builtins.str] name: The name of the site.
        :param pulumi.Input[_builtins.str] secondary_connector_id: Magic Connector identifier tag. Used when high availability mode is on.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MagicTransitSiteState.__new__(_MagicTransitSiteState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["connector_id"] = connector_id
        __props__.__dict__["description"] = description
        __props__.__dict__["ha_mode"] = ha_mode
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["secondary_connector_id"] = secondary_connector_id
        return MagicTransitSite(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Magic Connector identifier tag.
        """
        return pulumi.get(self, "connector_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="haMode")
    def ha_mode(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Site high availability mode. If set to true, the site can have two connectors and runs in high availability mode.
        """
        return pulumi.get(self, "ha_mode")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional['outputs.MagicTransitSiteLocation']]:
        """
        Location of site in latitude and longitude.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the site.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secondaryConnectorId")
    def secondary_connector_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Magic Connector identifier tag. Used when high availability mode is on.
        """
        return pulumi.get(self, "secondary_connector_id")

