# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MtlsCertificateArgs', 'MtlsCertificate']

@pulumi.input_type
class MtlsCertificateArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 ca: pulumi.Input[_builtins.bool],
                 certificates: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MtlsCertificate resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.bool] ca: Indicates whether the certificate is a CA or leaf certificate.
        :param pulumi.Input[_builtins.str] certificates: The uploaded root CA certificate.
        :param pulumi.Input[_builtins.str] name: Optional unique name for the certificate. Only used for human readability.
        :param pulumi.Input[_builtins.str] private_key: The private key for the certificate. This field is only needed for specific use cases such as using a custom certificate with Zero Trust's block page.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "ca", ca)
        pulumi.set(__self__, "certificates", certificates)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def ca(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates whether the certificate is a CA or leaf certificate.
        """
        return pulumi.get(self, "ca")

    @ca.setter
    def ca(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "ca", value)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> pulumi.Input[_builtins.str]:
        """
        The uploaded root CA certificate.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificates", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional unique name for the certificate. Only used for human readability.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key for the certificate. This field is only needed for specific use cases such as using a custom certificate with Zero Trust's block page.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)


@pulumi.input_type
class _MtlsCertificateState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ca: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificates: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_on: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.str]] = None,
                 signature: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 uploaded_on: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MtlsCertificate resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.bool] ca: Indicates whether the certificate is a CA or leaf certificate.
        :param pulumi.Input[_builtins.str] certificates: The uploaded root CA certificate.
        :param pulumi.Input[_builtins.str] expires_on: When the certificate expires.
        :param pulumi.Input[_builtins.str] issuer: The certificate authority that issued the certificate.
        :param pulumi.Input[_builtins.str] name: Optional unique name for the certificate. Only used for human readability.
        :param pulumi.Input[_builtins.str] private_key: The private key for the certificate. This field is only needed for specific use cases such as using a custom certificate with Zero Trust's block page.
        :param pulumi.Input[_builtins.str] serial_number: The certificate serial number.
        :param pulumi.Input[_builtins.str] signature: The type of hash used for the certificate.
        :param pulumi.Input[_builtins.str] updated_at: This is the time the certificate was updated.
        :param pulumi.Input[_builtins.str] uploaded_on: This is the time the certificate was uploaded.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if ca is not None:
            pulumi.set(__self__, "ca", ca)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if expires_on is not None:
            pulumi.set(__self__, "expires_on", expires_on)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if uploaded_on is not None:
            pulumi.set(__self__, "uploaded_on", uploaded_on)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def ca(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the certificate is a CA or leaf certificate.
        """
        return pulumi.get(self, "ca")

    @ca.setter
    def ca(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ca", value)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The uploaded root CA certificate.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificates", value)

    @_builtins.property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the certificate expires.
        """
        return pulumi.get(self, "expires_on")

    @expires_on.setter
    def expires_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_on", value)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate authority that issued the certificate.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional unique name for the certificate. Only used for human readability.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key for the certificate. This field is only needed for specific use cases such as using a custom certificate with Zero Trust's block page.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate serial number.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial_number", value)

    @_builtins.property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of hash used for the certificate.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signature", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the time the certificate was updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="uploadedOn")
    def uploaded_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the time the certificate was uploaded.
        """
        return pulumi.get(self, "uploaded_on")

    @uploaded_on.setter
    def uploaded_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uploaded_on", value)


@pulumi.type_token("cloudflare:index/mtlsCertificate:MtlsCertificate")
class MtlsCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ca: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificates: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_mtls_certificate = cloudflare.MtlsCertificate("example_mtls_certificate",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            ca=True,
            certificates=\"\"\"  -----BEGIN CERTIFICATE-----
          MIIDmDCCAoCgAwIBAgIUKTOAZNjcXVZRj4oQt0SHsl1c1vMwDQYJKoZIhvcNAQELBQAwUTELMAkGA1UEBhMCVVMxFjAUBgNVBAgMDVNhbiBGcmFuY2lzY28xEzARBgNVBAcMCkNhbGlmb3JuaWExFTATBgNVBAoMDEV4YW1wbGUgSW5jLjAgFw0yMjExMjIxNjU5NDdaGA8yMTIyMTAyOTE2NTk0N1owUTELMAkGA1UEBhMCVVMxFjAUBgNVBAgMDVNhbiBGcmFuY2lzY28xEzARBgNVBAcMCkNhbGlmb3JuaWExFTATBgNVBAoMDEV4YW1wbGUgSW5jLjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMRcORwgJFTdcG/2GKI+cFYiOBNDKjCZUXEOvXWY42BkH9wxiMT869CO+enA1w5pIrXow6kCM1sQspHHaVmJUlotEMJxyoLFfA/8Kt1EKFyobOjuZs2SwyVyJ2sStvQuUQEosULZCNGZEqoH5g6zhMPxaxm7ZLrrsDZ9maNGVqo7EWLWHrZ57Q/5MtTrbxQL+eXjUmJ9K3kS+3uEwMdqR6Z3BluU1ivanpPc1CN2GNhdO0/hSY4YkGEnuLsqJyDd3cIiB1MxuCBJ4ZaqOd2viV1WcP3oU3dxVPm4MWyfYIldMWB14FahScxLhWdRnM9YZ/i9IFcLypXsuz7DjrJPtPUCAwEAAaNmMGQwHQYDVR0OBBYEFP5JzLUawNF+c3AXsYTEWHh7z2czMB8GA1UdIwQYMBaAFP5JzLUawNF+c3AXsYTEWHh7z2czMA4GA1UdDwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEBMA0GCSqGSIb3DQEBCwUAA4IBAQBc+Be7NDhpE09y7hLPZGRPl1cSKBw4RI0XIv6rlbSTFs5EebpTGjhx/whNxwEZhB9HZ7111Oa1YlT8xkI9DshB78mjAHCKBAJ76moK8tkG0aqdYpJ4ZcJTVBB7l98Rvgc7zfTii7WemTy72deBbSeiEtXavm4EF0mWjHhQ5Nxpnp00Bqn5g1x8CyTDypgmugnep+xG+iFzNmTdsz7WI9T/7kDMXqB7M/FPWBORyS98OJqNDswCLF8bIZYwUBEe+bRHFomoShMzaC3tvim7WCb16noDkSTMlfKO4pnvKhpcVdSgwcruATV7y+W+Lvmz2OT/Gui4JhqeoTewsxndhDDE
          -----END CERTIFICATE-----
        \"\"\",
            name="example_ca_cert",
            private_key=\"\"\"  -----BEGIN PRIVATE KEY-----
          MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDEXDkcICRU3XBv9hiiPnBWIjgTQyowmVFxDr11mONgZB/cMYjE/OvQjvnpwNcOaSK16MOpAjNbELKRx2lZiVJaLRDCccqCxXwP/CrdRChcqGzo7mbNksMlcidrErb0LlEBKLFC2QjRmRKqB+YOs4TD8WsZu2S667A2fZmjRlaqOxFi1h62ee0P+TLU628UC/nl41JifSt5Evt7hMDHakemdwZblNYr2p6T3NQjdhjYXTtP4UmOGJBhJ7i7Kicg3d3CIgdTMbggSeGWqjndr4ldVnD96FN3cVT5uDFsn2CJXTFgdeBWoUnMS4VnUZzPWGf4vSBXC8qV7Ls+w46yT7T1AgMBAAECggEAQZnp/oqCeNPOR6l5S2L+1tfx0gWjZ78hJVteUpZ0iHSK7F6kKeOxyOird7vUXV0kmo+cJq+0hp0Ke4eam640FCpwKfYoSQ4/R3vgujGWJnaihCN5tv5sMet0XeJPuz5qE7ALoKCvwI6aXLHs20aAeZIDTQJ9QbGSGnJVzOWn+JDTidIgZpN57RpXfSAwnJPTQK/PN8i5z108hsaDOdEgGmxYZ7kYqMqzX20KXmth58LDfPixs5JGtS60iiKC/wOcGzkB2/AdTSojR76oEU77cANP/3zO25NG//whUdYlW0t0d7PgXxIeJe+xgYnamDQJx3qonVyt4H77ha0ObRAj9QKBgQDicZr+VTwFMnELP3a+FXGnjehRiuS1i7MXGKxNweCD+dFlML0FplSQS8Ro2n+d8lu8BBXGx0qm6VXu8Rhn7TAUL6q+PCgfarzxfIhacb/TZCqfieIHsMlVBfhV5HCXnk+kis0tuC/PRArcWTwDHJUJXkBhvkUsNswvQzavDPI7KwKBgQDd/WgLkj7A3X5fgIHZH/GbDSBiXwzKb+rF4ZCT2XFgG/OAW7vapfcX/w+v+5lBLyrocmOAS3PGGAhM5T3HLnUCQfnK4qgps1Lqibkc9Tmnsn60LanUjuUMsYv/zSw70tozbzhJ0pioEpWfRxRZBztO2Rr8Ntm7h6Fk701EXGNAXwKBgQCD1xsjy2J3sCerIdcz0u5qXLAPkeuZW+34m4/ucdwTWwc0gEz9lhsULFj9p4G351zLuiEnq+7mAWLcDJlmIO3mQt6JhiLiL9Y0T4pgBmxmWqKKYtAsJB0EmMY+1BNN44mBRqMxZFTJu1cLdhT/xstrOeoIPqytknYNanfTMZlzIwKBgHrLXe5oq0XMP8dcMneEcAUwsaU4pr6kQd3L9EmUkl5zl7J9C+DaxWAEuwzBw/iGutlxzRB+rD/7szu14wJ29EqXbDGKRzMp+se5/yfBjm7xEZ1hVPw7PwBShfqt57X/4Ktq7lwHnmH6RcGhc+P7WBc5iO/S94YAdIp8xOT3pf9JAoGAE0QkqJUY+5Mgr+fBO0VNV72ZoPveGpW+De59uhKAOnu1zljQCUtk59m6+DXfm0tNYKtawa5n8iN71Zh+s62xXSt3pYi1Y5CCCmv8Y4BhwIcPwXKk3zEvLgSHVTpC0bayA9aSO4bbZgVXa5w+Z0w/vvfp9DWo1IS3EnQRrz6WMYA=
          -----END PRIVATE KEY-----
        \"\"\")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/mtlsCertificate:MtlsCertificate example '<account_id>/<mtls_certificate_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.bool] ca: Indicates whether the certificate is a CA or leaf certificate.
        :param pulumi.Input[_builtins.str] certificates: The uploaded root CA certificate.
        :param pulumi.Input[_builtins.str] name: Optional unique name for the certificate. Only used for human readability.
        :param pulumi.Input[_builtins.str] private_key: The private key for the certificate. This field is only needed for specific use cases such as using a custom certificate with Zero Trust's block page.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MtlsCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_mtls_certificate = cloudflare.MtlsCertificate("example_mtls_certificate",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            ca=True,
            certificates=\"\"\"  -----BEGIN CERTIFICATE-----
          MIIDmDCCAoCgAwIBAgIUKTOAZNjcXVZRj4oQt0SHsl1c1vMwDQYJKoZIhvcNAQELBQAwUTELMAkGA1UEBhMCVVMxFjAUBgNVBAgMDVNhbiBGcmFuY2lzY28xEzARBgNVBAcMCkNhbGlmb3JuaWExFTATBgNVBAoMDEV4YW1wbGUgSW5jLjAgFw0yMjExMjIxNjU5NDdaGA8yMTIyMTAyOTE2NTk0N1owUTELMAkGA1UEBhMCVVMxFjAUBgNVBAgMDVNhbiBGcmFuY2lzY28xEzARBgNVBAcMCkNhbGlmb3JuaWExFTATBgNVBAoMDEV4YW1wbGUgSW5jLjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMRcORwgJFTdcG/2GKI+cFYiOBNDKjCZUXEOvXWY42BkH9wxiMT869CO+enA1w5pIrXow6kCM1sQspHHaVmJUlotEMJxyoLFfA/8Kt1EKFyobOjuZs2SwyVyJ2sStvQuUQEosULZCNGZEqoH5g6zhMPxaxm7ZLrrsDZ9maNGVqo7EWLWHrZ57Q/5MtTrbxQL+eXjUmJ9K3kS+3uEwMdqR6Z3BluU1ivanpPc1CN2GNhdO0/hSY4YkGEnuLsqJyDd3cIiB1MxuCBJ4ZaqOd2viV1WcP3oU3dxVPm4MWyfYIldMWB14FahScxLhWdRnM9YZ/i9IFcLypXsuz7DjrJPtPUCAwEAAaNmMGQwHQYDVR0OBBYEFP5JzLUawNF+c3AXsYTEWHh7z2czMB8GA1UdIwQYMBaAFP5JzLUawNF+c3AXsYTEWHh7z2czMA4GA1UdDwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEBMA0GCSqGSIb3DQEBCwUAA4IBAQBc+Be7NDhpE09y7hLPZGRPl1cSKBw4RI0XIv6rlbSTFs5EebpTGjhx/whNxwEZhB9HZ7111Oa1YlT8xkI9DshB78mjAHCKBAJ76moK8tkG0aqdYpJ4ZcJTVBB7l98Rvgc7zfTii7WemTy72deBbSeiEtXavm4EF0mWjHhQ5Nxpnp00Bqn5g1x8CyTDypgmugnep+xG+iFzNmTdsz7WI9T/7kDMXqB7M/FPWBORyS98OJqNDswCLF8bIZYwUBEe+bRHFomoShMzaC3tvim7WCb16noDkSTMlfKO4pnvKhpcVdSgwcruATV7y+W+Lvmz2OT/Gui4JhqeoTewsxndhDDE
          -----END CERTIFICATE-----
        \"\"\",
            name="example_ca_cert",
            private_key=\"\"\"  -----BEGIN PRIVATE KEY-----
          MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDEXDkcICRU3XBv9hiiPnBWIjgTQyowmVFxDr11mONgZB/cMYjE/OvQjvnpwNcOaSK16MOpAjNbELKRx2lZiVJaLRDCccqCxXwP/CrdRChcqGzo7mbNksMlcidrErb0LlEBKLFC2QjRmRKqB+YOs4TD8WsZu2S667A2fZmjRlaqOxFi1h62ee0P+TLU628UC/nl41JifSt5Evt7hMDHakemdwZblNYr2p6T3NQjdhjYXTtP4UmOGJBhJ7i7Kicg3d3CIgdTMbggSeGWqjndr4ldVnD96FN3cVT5uDFsn2CJXTFgdeBWoUnMS4VnUZzPWGf4vSBXC8qV7Ls+w46yT7T1AgMBAAECggEAQZnp/oqCeNPOR6l5S2L+1tfx0gWjZ78hJVteUpZ0iHSK7F6kKeOxyOird7vUXV0kmo+cJq+0hp0Ke4eam640FCpwKfYoSQ4/R3vgujGWJnaihCN5tv5sMet0XeJPuz5qE7ALoKCvwI6aXLHs20aAeZIDTQJ9QbGSGnJVzOWn+JDTidIgZpN57RpXfSAwnJPTQK/PN8i5z108hsaDOdEgGmxYZ7kYqMqzX20KXmth58LDfPixs5JGtS60iiKC/wOcGzkB2/AdTSojR76oEU77cANP/3zO25NG//whUdYlW0t0d7PgXxIeJe+xgYnamDQJx3qonVyt4H77ha0ObRAj9QKBgQDicZr+VTwFMnELP3a+FXGnjehRiuS1i7MXGKxNweCD+dFlML0FplSQS8Ro2n+d8lu8BBXGx0qm6VXu8Rhn7TAUL6q+PCgfarzxfIhacb/TZCqfieIHsMlVBfhV5HCXnk+kis0tuC/PRArcWTwDHJUJXkBhvkUsNswvQzavDPI7KwKBgQDd/WgLkj7A3X5fgIHZH/GbDSBiXwzKb+rF4ZCT2XFgG/OAW7vapfcX/w+v+5lBLyrocmOAS3PGGAhM5T3HLnUCQfnK4qgps1Lqibkc9Tmnsn60LanUjuUMsYv/zSw70tozbzhJ0pioEpWfRxRZBztO2Rr8Ntm7h6Fk701EXGNAXwKBgQCD1xsjy2J3sCerIdcz0u5qXLAPkeuZW+34m4/ucdwTWwc0gEz9lhsULFj9p4G351zLuiEnq+7mAWLcDJlmIO3mQt6JhiLiL9Y0T4pgBmxmWqKKYtAsJB0EmMY+1BNN44mBRqMxZFTJu1cLdhT/xstrOeoIPqytknYNanfTMZlzIwKBgHrLXe5oq0XMP8dcMneEcAUwsaU4pr6kQd3L9EmUkl5zl7J9C+DaxWAEuwzBw/iGutlxzRB+rD/7szu14wJ29EqXbDGKRzMp+se5/yfBjm7xEZ1hVPw7PwBShfqt57X/4Ktq7lwHnmH6RcGhc+P7WBc5iO/S94YAdIp8xOT3pf9JAoGAE0QkqJUY+5Mgr+fBO0VNV72ZoPveGpW+De59uhKAOnu1zljQCUtk59m6+DXfm0tNYKtawa5n8iN71Zh+s62xXSt3pYi1Y5CCCmv8Y4BhwIcPwXKk3zEvLgSHVTpC0bayA9aSO4bbZgVXa5w+Z0w/vvfp9DWo1IS3EnQRrz6WMYA=
          -----END PRIVATE KEY-----
        \"\"\")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/mtlsCertificate:MtlsCertificate example '<account_id>/<mtls_certificate_id>'
        ```

        :param str resource_name: The name of the resource.
        :param MtlsCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MtlsCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ca: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificates: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MtlsCertificateArgs.__new__(MtlsCertificateArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if ca is None and not opts.urn:
                raise TypeError("Missing required property 'ca'")
            __props__.__dict__["ca"] = ca
            if certificates is None and not opts.urn:
                raise TypeError("Missing required property 'certificates'")
            __props__.__dict__["certificates"] = certificates
            __props__.__dict__["name"] = name
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["expires_on"] = None
            __props__.__dict__["issuer"] = None
            __props__.__dict__["serial_number"] = None
            __props__.__dict__["signature"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["uploaded_on"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MtlsCertificate, __self__).__init__(
            'cloudflare:index/mtlsCertificate:MtlsCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            ca: Optional[pulumi.Input[_builtins.bool]] = None,
            certificates: Optional[pulumi.Input[_builtins.str]] = None,
            expires_on: Optional[pulumi.Input[_builtins.str]] = None,
            issuer: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            serial_number: Optional[pulumi.Input[_builtins.str]] = None,
            signature: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            uploaded_on: Optional[pulumi.Input[_builtins.str]] = None) -> 'MtlsCertificate':
        """
        Get an existing MtlsCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.bool] ca: Indicates whether the certificate is a CA or leaf certificate.
        :param pulumi.Input[_builtins.str] certificates: The uploaded root CA certificate.
        :param pulumi.Input[_builtins.str] expires_on: When the certificate expires.
        :param pulumi.Input[_builtins.str] issuer: The certificate authority that issued the certificate.
        :param pulumi.Input[_builtins.str] name: Optional unique name for the certificate. Only used for human readability.
        :param pulumi.Input[_builtins.str] private_key: The private key for the certificate. This field is only needed for specific use cases such as using a custom certificate with Zero Trust's block page.
        :param pulumi.Input[_builtins.str] serial_number: The certificate serial number.
        :param pulumi.Input[_builtins.str] signature: The type of hash used for the certificate.
        :param pulumi.Input[_builtins.str] updated_at: This is the time the certificate was updated.
        :param pulumi.Input[_builtins.str] uploaded_on: This is the time the certificate was uploaded.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MtlsCertificateState.__new__(_MtlsCertificateState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["ca"] = ca
        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["expires_on"] = expires_on
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["name"] = name
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["signature"] = signature
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["uploaded_on"] = uploaded_on
        return MtlsCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def ca(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the certificate is a CA or leaf certificate.
        """
        return pulumi.get(self, "ca")

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[_builtins.str]:
        """
        The uploaded root CA certificate.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the certificate expires.
        """
        return pulumi.get(self, "expires_on")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate authority that issued the certificate.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional unique name for the certificate. Only used for human readability.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The private key for the certificate. This field is only needed for specific use cases such as using a custom certificate with Zero Trust's block page.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate serial number.
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter
    def signature(self) -> pulumi.Output[_builtins.str]:
        """
        The type of hash used for the certificate.
        """
        return pulumi.get(self, "signature")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        This is the time the certificate was updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="uploadedOn")
    def uploaded_on(self) -> pulumi.Output[_builtins.str]:
        """
        This is the time the certificate was uploaded.
        """
        return pulumi.get(self, "uploaded_on")

