# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PageRuleArgs', 'PageRule']

@pulumi.input_type
class PageRuleArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input['PageRuleActionsArgs'],
                 target: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PageRule resource.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        :param pulumi.Input[_builtins.int] priority: The priority of the rule, used to define which Page Rule is processed
               over another. A higher number indicates a higher priority. For example,
               if you have a catch-all Page Rule (rule A: `/images/*`) but want a more
               specific Page Rule to take precedence (rule B: `/images/special/*`),
               specify a higher priority for rule B so it overrides rule A.
        :param pulumi.Input[_builtins.str] status: The status of the Page Rule.
               Available values: "active", "disabled".
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "zone_id", zone_id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Input['PageRuleActionsArgs']:
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input['PageRuleActionsArgs']):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The priority of the rule, used to define which Page Rule is processed
        over another. A higher number indicates a higher priority. For example,
        if you have a catch-all Page Rule (rule A: `/images/*`) but want a more
        specific Page Rule to take precedence (rule B: `/images/special/*`),
        specify a higher priority for rule B so it overrides rule A.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Page Rule.
        Available values: "active", "disabled".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _PageRuleState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input['PageRuleActionsArgs']] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PageRule resources.
        :param pulumi.Input[_builtins.str] created_on: The timestamp of when the Page Rule was created.
        :param pulumi.Input[_builtins.str] modified_on: The timestamp of when the Page Rule was last modified.
        :param pulumi.Input[_builtins.int] priority: The priority of the rule, used to define which Page Rule is processed
               over another. A higher number indicates a higher priority. For example,
               if you have a catch-all Page Rule (rule A: `/images/*`) but want a more
               specific Page Rule to take precedence (rule B: `/images/special/*`),
               specify a higher priority for rule B so it overrides rule A.
        :param pulumi.Input[_builtins.str] status: The status of the Page Rule.
               Available values: "active", "disabled".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input['PageRuleActionsArgs']]:
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input['PageRuleActionsArgs']]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the Page Rule was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the Page Rule was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The priority of the rule, used to define which Page Rule is processed
        over another. A higher number indicates a higher priority. For example,
        if you have a catch-all Page Rule (rule A: `/images/*`) but want a more
        specific Page Rule to take precedence (rule B: `/images/special/*`),
        specify a higher priority for rule B so it overrides rule A.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Page Rule.
        Available values: "active", "disabled".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/pageRule:PageRule")
class PageRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Union['PageRuleActionsArgs', 'PageRuleActionsArgsDict']]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/pageRule:PageRule example '<zone_id>/<pagerule_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] priority: The priority of the rule, used to define which Page Rule is processed
               over another. A higher number indicates a higher priority. For example,
               if you have a catch-all Page Rule (rule A: `/images/*`) but want a more
               specific Page Rule to take precedence (rule B: `/images/special/*`),
               specify a higher priority for rule B so it overrides rule A.
        :param pulumi.Input[_builtins.str] status: The status of the Page Rule.
               Available values: "active", "disabled".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PageRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/pageRule:PageRule example '<zone_id>/<pagerule_id>'
        ```

        :param str resource_name: The name of the resource.
        :param PageRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PageRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Union['PageRuleActionsArgs', 'PageRuleActionsArgsDict']]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PageRuleArgs.__new__(PageRuleArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            __props__.__dict__["priority"] = priority
            __props__.__dict__["status"] = status
            if target is None and not opts.urn:
                raise TypeError("Missing required property 'target'")
            __props__.__dict__["target"] = target
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
        super(PageRule, __self__).__init__(
            'cloudflare:index/pageRule:PageRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Union['PageRuleActionsArgs', 'PageRuleActionsArgsDict']]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            target: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PageRule':
        """
        Get an existing PageRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_on: The timestamp of when the Page Rule was created.
        :param pulumi.Input[_builtins.str] modified_on: The timestamp of when the Page Rule was last modified.
        :param pulumi.Input[_builtins.int] priority: The priority of the rule, used to define which Page Rule is processed
               over another. A higher number indicates a higher priority. For example,
               if you have a catch-all Page Rule (rule A: `/images/*`) but want a more
               specific Page Rule to take precedence (rule B: `/images/special/*`),
               specify a higher priority for rule B so it overrides rule A.
        :param pulumi.Input[_builtins.str] status: The status of the Page Rule.
               Available values: "active", "disabled".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PageRuleState.__new__(_PageRuleState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["priority"] = priority
        __props__.__dict__["status"] = status
        __props__.__dict__["target"] = target
        __props__.__dict__["zone_id"] = zone_id
        return PageRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output['outputs.PageRuleActions']:
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the Page Rule was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the Page Rule was last modified.
        """
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        The priority of the rule, used to define which Page Rule is processed
        over another. A higher number indicates a higher priority. For example,
        if you have a catch-all Page Rule (rule A: `/images/*`) but want a more
        specific Page Rule to take precedence (rule B: `/images/special/*`),
        specify a higher priority for rule B so it overrides rule A.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Page Rule.
        Available values: "active", "disabled".
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

